/* global describe, it, beforeEach, expect, ChartFeaturesTestUtils, inject, module, PivotTableTestUtils, beforeAll */

describe('chart pivot table - unit test', function () {

    const chartType = 'pivot_table';
    const chartVariant = 'normal';

    /* Initialize each test */
    beforeEach(() => {
        ChartFeaturesTestUtils.initEachTest();
        ChartFeaturesTestUtils.initChartType(chartType, chartVariant);
    });

    it('converts data to an ag-grid table only with row dimensions', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim1MeasureAggregAsRows();
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // 2 parent rows (Platinium member [TRUE|FALSE]) + 4 children rows (Platinium member [TRUE|FALSE] && Continent [Amerique|Europe]) + 2 subtotal rows + 1 grandtotal row
            expect(gridOptions.rowData.length).toBe(9);
            // Parent Row - Platinium Member: FALSE 
            expect(gridOptions.rowData[0].id.includes('Platinium member__FALSE')).toBeTruthy();
            expect(gridOptions.rowData[0].yDimension_1_Continent).toBeUndefined();
            expect(gridOptions.rowData[0].measure_0_nb_visit.measure.value).toBe(20);
            // Parent Row - Platinium Member: TRUE 
            expect(gridOptions.rowData[1].id.includes('Platinium member__TRUE')).toBeTruthy();
            //expect(gridOptions.rowData[1].group).toBeTruthy();
            expect(gridOptions.rowData[1].yDimension_1_Continent).toBeUndefined();
            expect(gridOptions.rowData[1].measure_0_nb_visit.measure.value).toBe(20);
            // Child Row - Platinium Member: FALSE - Continent Europe
            expect(gridOptions.rowData[2].id.includes('Platinium member__FALSE')).toBeTruthy();
            expect(gridOptions.rowData[2].group).toBeFalsy();
            expect(gridOptions.rowData[2].yDimension_1_Continent.label).toBe('Amerique');
            expect(gridOptions.rowData[2].measure_0_nb_visit.measure.value).toBe(8);
            // Child Row - Platinium Member: FALSE - Continent Amerique
            expect(gridOptions.rowData[3].id.includes('Platinium member__FALSE')).toBeTruthy();
            expect(gridOptions.rowData[3].yDimension_1_Continent.label).toBe('Europe');
            expect(gridOptions.rowData[3].measure_0_nb_visit.measure.value).toBe(12);
            // Subtotal Row - Platinium Member: FALSE
            expect(gridOptions.rowData[6].id.includes('Platinium member__FALSE')).toBeTruthy();
            expect(gridOptions.rowData[6].id.includes('__Subtotal__Leaf__Row__')).toBeTruthy();
            expect(gridOptions.rowData[6].yDimension_1_Continent).toBeUndefined();
            expect(gridOptions.rowData[6].measure_0_nb_visit.measure.value).toBe(20);

            // Beside autoGroupColumnDef that is the Platinium Member - 1 column for Continent - 1 for nb_visit;
            expect(gridOptions.columnDefs.length).toBe(2);
        });
    });

    it('converts data to an ag-grid table only with column dimensions', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2ColumnDim1Measure(); 
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // 2 parent rows (Platinium member [TRUE|FALSE]) + 4 children rows (Platinium member [TRUE|FALSE] && Continent [Amerique|Europe]) + 2 subtotal rows
            expect(gridOptions.rowData.length).toBe(1);
            const uniqueRow = gridOptions.rowData[0];
            expect(uniqueRow.id).toBe('__UNIQUE__ROW__');
            // Child column - Platinium Member: FALSE - Continent Europe
            expect(uniqueRow['xDimension_0_Platinium member-1-1'].measures[0].value).toBe(8);
            // Child column - Platinium Member: FALSE - Continent Amerique
            expect(uniqueRow['xDimension_0_Platinium member-1-2'].measures[0].value).toBe(12);
            // Subtotal column - Platinium Member: FALSE 
            expect(uniqueRow['xDimension_0_Platinium member-1__Total'].measures[0].value).toBe(20);

            // Beside autoGroupColumnDef that is the Platinium Member - 0 column for Measure label - 1 Column displaying column tree - 1 column for Grand Total
            expect(gridOptions.columnDefs.length).toBe(2);
            // Beside autoGroupColumnDef that is the Platinium Member - 0 column for Measure label - 1 Column displaying column tree
            expect(gridOptions.columnDefs[0].type).toBe('dimensionLabelColumn');
            expect(gridOptions.columnDefs[0].children.length).toBe(2);

        });
    });

    it('converts data to an ag-grid table multiple column and row dimensions', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim2ColumnDim1MeasureWithAggregationAsRows(); 
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // 2 parent rows (Gender [F|M]) + 2 children rows + 2 subtotal rows + Grand Total row
            expect(gridOptions.rowData.length).toBe(7);
            // Total Gender F - SUM visits
            expect(gridOptions.rowData[0].__Grand__Total__.measures[0].value).toBe(20);
            // Total Gender M - SUM visits
            expect(gridOptions.rowData[1].__Grand__Total__.measures[0].value).toBe(20);
            // Grand total - SUM visits
            expect(gridOptions.rowData[6].__Grand__Total__.measures[0].value).toBe(40);

            // Beside autoGroupColumnDef that is the Gender - 1 column for Content (row navigation)-  0 column for Measure label - 1 Column displaying column tree - 1 column for Grand total
            expect(gridOptions.columnDefs.length).toBe(3);
            expect(gridOptions.columnDefs[0].type).toBe('rowNavigationColumn');
            expect(gridOptions.columnDefs[1].type).toBe('dimensionLabelColumn');
            expect(gridOptions.columnDefs[1].children.length).toBe(2);
            expect(gridOptions.columnDefs[2].type).toBe('grandTotalColumn');
        });
    });

    it('converts data to an ag-grid table multiple column and row dimensions with 2 measures displayed as rows', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim2ColumnDim2MeasureAggregationAsRows();
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // 2 parent rows (Gender [F|M]) + 2 children rows + 2 subtotal rows + Grand Total row
            expect(gridOptions.rowData.length).toBe(7);
            // Total Gender F - SUM visits
            expect(gridOptions.rowData[0].__Grand__Total__.measures[0].value).toBe(20);
            // Total Gender F - AVG visits
            expect(gridOptions.rowData[0].__Grand__Total__.measures[1].value).toBe(1);
            // Total Gender M - SUM visits
            expect(gridOptions.rowData[1].__Grand__Total__.measures[0].value).toBe(20);
            // Total Gender F - AVG visits
            expect(gridOptions.rowData[1].__Grand__Total__.measures[1].value).toBe(1);
            // Grand total - SUM visits
            expect(gridOptions.rowData[6].__Grand__Total__.measures[0].value).toBe(40);
            // Grand total - AVG visits
            expect(gridOptions.rowData[6].__Grand__Total__.measures[1].value).toBe(1);

            // Beside autoGroupColumnDef that is the Gender - 1 column for Content (row navigation)-  1 column for Measure label - 1 Column displaying column tree - 1 column for Grand total
            expect(gridOptions.columnDefs.length).toBe(4);
            expect(gridOptions.columnDefs[0].type).toBe('rowNavigationColumn');
            expect(gridOptions.columnDefs[1].type).toBe('measureLabelColumn');
            expect(gridOptions.columnDefs[2].type).toBe('dimensionLabelColumn');
            expect(gridOptions.columnDefs[2].children.length).toBe(2);
            expect(getColumnTreeDepth(gridOptions.columnDefs)).toBe(4);
            expect(gridOptions.columnDefs[3].type).toBe('grandTotalColumn');
        });
    });

    it('converts data to an ag-grid table multiple column and row dimensions with 2 measures displayed as columns', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim2ColumnDim2MeasureAggregationAsColumns();
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // 2 parent rows (Gender [F|M]) + 2 children rows + 2 subtotal rows + Grand Total row
            expect(gridOptions.rowData.length).toBe(7);
            // Total Gender F - SUM visits
            expect(gridOptions.rowData[0].__Grand__Total____measure_0_nb_visit_2.measure.value).toBe(20);
            // Total Gender F - AVG visits
            expect(gridOptions.rowData[0].__Grand__Total____measure_1_nb_visit.measure.value).toBe(1);
            // Total Gender M - SUM visits
            expect(gridOptions.rowData[1].__Grand__Total____measure_0_nb_visit_2.measure.value).toBe(20);
            // Total Gender F - AVG visits
            expect(gridOptions.rowData[1].__Grand__Total____measure_1_nb_visit.measure.value).toBe(1);
            // Grand total - SUM visits
            expect(gridOptions.rowData[6].__Grand__Total____measure_0_nb_visit_2.measure.value).toBe(40);
            // Grand total - AVG visits
            expect(gridOptions.rowData[6].__Grand__Total____measure_1_nb_visit.measure.value).toBe(1);

            // Beside autoGroupColumnDef that is the Gender - 1 column for Content (row navigation)- 1 Column displaying column tree - 1 column for Grand total
            expect(gridOptions.columnDefs.length).toBe(3);
            expect(gridOptions.columnDefs[0].type).toBe('rowNavigationColumn');
            expect(gridOptions.columnDefs[1].type).toBe('dimensionLabelColumn');
            // As agggregations are displayed as columns we should have one more level of column comparing with the previous test case.
            expect(getColumnTreeDepth(gridOptions.columnDefs)).toBe(4+1);
            expect(gridOptions.columnDefs[2].type).toBe('grandTotalGroupColumn');
        });
    });

    it('hides Grand Total Columns & Row', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim2ColumnDim2MeasureAggregationAsColumns();
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            chartDef.pivotTableOptions.displayTotals.grandTotal.column = false;
            chartDef.pivotTableOptions.displayTotals.grandTotal.row = false;
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // Assert no grand total row
            expect(gridOptions.rowData.length).toBe(7 - 1);
            // Assert Grand total column is hidden
            expect(gridOptions.columnDefs[2].type).toBe('grandTotalGroupColumn');
            expect(gridOptions.columnDefs[2].initialHide).toBeTruthy();
        });
    });

    it('hides Subtotal Columns & Row', function () {
        inject(function (AgGridConverter, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper) {
            const { axesDef, chartDef, data } = PivotTableTestUtils.getPivotDataWith2RowDim2ColumnDim2MeasureAggregationAsColumns();
            const { $container, chartData, chartHandler, chartStore, tooltips, contextualMenu } = PivotTableTestUtils.initPivotTableContext(chartDef, axesDef, data, ChartFormatting, ChartTooltips, ChartContextualMenu, ChartDimension, ChartStoreFactory, ChartDataWrapperFactory, ChartLegendsWrapper);
            chartDef.pivotTableOptions.displayTotals.subTotals.columns = false;
            chartDef.pivotTableOptions.displayTotals.subTotals.rows = false;
            const gridOptions = AgGridConverter.getAgGridConverter(chartDef, chartStore, chartData, data, chartHandler, tooltips, contextualMenu, $container).convert();
            // Assert no subtotal rows
            expect(gridOptions.rowData.length).toBe(7 - 2);
            const subtotalColumn = getARandomColumnFromColumnTreeOfType(gridOptions.columnDefs, 'subtotalColumn');
            // Assert subtotal column hided
            expect(subtotalColumn.columnGroupShow).toBe('closed');
        });
    });

    function getARandomColumnFromColumnTreeOfType(columnDefs, type){
        const stack = columnDefs.filter(parentColumn => parentColumn.type === 'dimensionLabelColumn');
        while (stack.length){
            const curr = stack.pop();
            if (curr.type === type) {
                return curr;
            } else if (curr.children){
                stack.push(...curr.children);
            }
        }
        return null;
    }

    function getColumnTreeDepth(columnDefs){
        let maxDepth = 1;
        const stack = columnDefs.filter(parentColumn => parentColumn.type === 'dimensionLabelColumn').map(column => ({column, depth: 1}));
        while (stack.length){
            const curr = stack.pop();
            maxDepth = Math.max(maxDepth, curr.depth);
            if (curr.column.children){
                stack.push(...curr.column.children.map(column => ({column, depth: curr.depth + 1})));
            }
        }
        return maxDepth;
    }  
});
