import sklearn
from sklearn.metrics import make_scorer as sklearn_make_scorer

from dataiku.base.utils import package_is_at_least


def make_scorer(*args, **kwargs):
    # scikit 1.4 deprecated needs_proba, 1.6 removed it, 1.4 added response_method to replace it
    # https://scikit-learn.org/1.4/modules/generated/sklearn.metrics.make_scorer.html#sklearn.metrics.make_scorer
    if package_is_at_least(sklearn, '1.4') and "needs_proba" in kwargs:
        if kwargs.get("needs_proba"):
            kwargs["response_method"] = "predict_proba"
        del kwargs["needs_proba"]
    return sklearn_make_scorer(*args, **kwargs)
