class BaseReader(object):
    NAME = "OUTPUT_BASE_READER"

    def __init__(self, prediction_type, value_to_class):
        self.prediction_type = prediction_type
        self.value_to_class = value_to_class

    def can_read(self, endpoint_output):
        raise NotImplementedError

    def read(self, endpoint_output):
        if self.prediction_type == "BINARY_CLASSIFICATION":
            return self.read_binary(endpoint_output)
        elif self.prediction_type == "MULTICLASS":
            return self.read_multiclass(endpoint_output)
        elif self.prediction_type == "REGRESSION":
            return self.read_regression(endpoint_output)

    def read_binary(self, endpoint_output):
        raise NotImplementedError

    def read_multiclass(self, endpoint_output):
        raise NotImplementedError

    def read_regression(self, endpoint_output):
        raise NotImplementedError