from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...code.code_env_selection.code_env_selection import CodeEnvSelection, _CodeEnvSelection
    from ...llm.online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock
    from .image_support_mode import ImageSupportMode
    from .next_turn_behaviour import NextTurnBehaviour
    from .tools_using_agent_mode import ToolsUsingAgentMode
    from .used_tool import UsedTool, _UsedTool
from .agent_settings import AgentSettings, _AgentSettings

'''
Translated from class com.dataiku.dip.dao.SavedModel$ToolsUsingAgentSettings
Via: PyModel annotation in the class hierarchy
'''


class _ToolsUsingAgentSettings(_AgentSettings, TypedDict):
    allowAgentsAsLLM: bool
    blocks: List['BlocksGraphBlock']
    codeEnvSelection: 'CodeEnvSelection'
    completionSettings: 'CompletionSettings'
    debugMode: bool
    imageSupportMode: 'ImageSupportMode'
    llmId: str
    mode: 'ToolsUsingAgentMode'
    newLineAfterBlockOutput: bool
    nextTurnBehaviour: 'NextTurnBehaviour'
    nextTurnSmartModeCompletionSettings: 'CompletionSettings'
    nextTurnSmartModeInstructionsAppend: str
    nextTurnSmartModeLLMId: str
    postChainHeadBlockId: str
    preChainHeadBlockId: str
    shortTermMemoryEnabled: bool
    shortTermMemoryHorizon: NotRequired[Optional[int]]
    startingBlockId: str
    systemPromptAppend: str
    tools: List['UsedTool']


ToolsUsingAgentSettings = _ToolsUsingAgentSettings


# EOF
