from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..bivariate.chi_2_ind_test.chi_2_ind_test_result import Chi2IndTestResult, _Chi2IndTestResult
    from ..bivariate.covariance.covariance_result import CovarianceResult, _CovarianceResult
    from ..bivariate.fit_2d_distribution.fit_2d_distribution_result import Fit2DDistributionResult, _Fit2DDistributionResult
    from ..bivariate.fit_curve.fit_curve_result import FitCurveResult, _FitCurveResult
    from ..bivariate.kendall_tau.kendall_tau_result import KendallTauResult, _KendallTauResult
    from ..bivariate.mutual_information.mutual_information_result import MutualInformationResult, _MutualInformationResult
    from ..bivariate.pearson.pearson_result import PearsonResult, _PearsonResult
    from ..bivariate.spearman.spearman_result import SpearmanResult, _SpearmanResult
    from ..common.count.count_result import CountResult, _CountResult
    from ..common.dummy_computation.dummy_computation_result import DummyComputationResult, _DummyComputationResult
    from ..common.grouped_computation.grouped_computation_result import GroupedComputationResult, _GroupedComputationResult
    from ..common.multi_computation.multi_computation_result import MultiComputationResult, _MultiComputationResult
    from ..common.resampled_computation.resampled_computation_result import ResampledComputationResult, _ResampledComputationResult
    from ..multivariate.fetch_csv.fetch_csv_result import FetchCSVResult, _FetchCSVResult
    from ..multivariate.fetch_values.fetch_values_result import FetchValuesResult, _FetchValuesResult
    from ..multivariate.pca.pca_result import PCAResult, _PCAResult
    from ..timeseries.acf.acf_result import ACFResult, _ACFResult
    from ..timeseries.durbin_watson.durbin_watson_result import DurbinWatsonResult, _DurbinWatsonResult
    from ..timeseries.mann_kendall_test.mann_kendall_test_result import MannKendallTestResult, _MannKendallTestResult
    from ..timeseries.pacf.pacf_result import PACFResult, _PACFResult
    from ..timeseries.stl_decomposition.stl_decomposition_result import STLDecompositionResult, _STLDecompositionResult
    from ..timeseries.unit_root_test_adf.unit_root_test_adf_result import UnitRootTestADFResult, _UnitRootTestADFResult
    from ..timeseries.unit_root_test_kpss.unit_root_test_kpss_result import UnitRootTestKPSSResult, _UnitRootTestKPSSResult
    from ..timeseries.unit_root_test_za.unit_root_test_za_result import UnitRootTestZAResult, _UnitRootTestZAResult
    from ..univariate.count_distinct.count_distinct_result import CountDistinctResult, _CountDistinctResult
    from ..univariate.empirical_cdf.empirical_cdf_result import EmpiricalCDFResult, _EmpiricalCDFResult
    from ..univariate.entropy.entropy_result import EntropyResult, _EntropyResult
    from ..univariate.fit_distribution.fit_distribution_result import FitDistributionResult, _FitDistributionResult
    from ..univariate.guess_time_step.guess_time_step_result import GuessTimeStepResult, _GuessTimeStepResult
    from ..univariate.ks_test_2_samp.ks_test_2_samp_result import KsTest2SampResult, _KsTest2SampResult
    from ..univariate.kurtosis.kurtosis_result import KurtosisResult, _KurtosisResult
    from ..univariate.levene_test_n_samp.levene_test_n_samp_result import LeveneTestNSampResult, _LeveneTestNSampResult
    from ..univariate.match_time_step.match_time_step_result import MatchTimeStepResult, _MatchTimeStepResult
    from ..univariate.max.max_result import MaxResult, _MaxResult
    from ..univariate.max_time.max_time_result import MaxTimeResult, _MaxTimeResult
    from ..univariate.mean.mean_result import MeanResult, _MeanResult
    from ..univariate.min.min_result import MinResult, _MinResult
    from ..univariate.min_time.min_time_result import MinTimeResult, _MinTimeResult
    from ..univariate.mood_test_n_samp.mood_test_n_samp_result import MoodTestNSampResult, _MoodTestNSampResult
    from ..univariate.one_way_anova.one_way_anova_result import OneWayAnovaResult, _OneWayAnovaResult
    from ..univariate.pairwise_levene_test.pairwise_levene_test_result import PairwiseLeveneTestResult, _PairwiseLeveneTestResult
    from ..univariate.pairwise_mood_test.pairwise_mood_test_result import PairwiseMoodTestResult, _PairwiseMoodTestResult
    from ..univariate.pairwise_t_test.pairwise_t_test_result import PairwiseTTestResult, _PairwiseTTestResult
    from ..univariate.quantiles.quantiles_result import QuantilesResult, _QuantilesResult
    from ..univariate.sem.sem_result import SemResult, _SemResult
    from ..univariate.shapiro.shapiro_result import ShapiroResult, _ShapiroResult
    from ..univariate.sign_test_1_samp.sign_test_1_samp_result import SignTest1SampResult, _SignTest1SampResult
    from ..univariate.skewness.skewness_result import SkewnessResult, _SkewnessResult
    from ..univariate.std_dev.std_dev_result import StdDevResult, _StdDevResult
    from ..univariate.sum.sum_result import SumResult, _SumResult
    from ..univariate.t_test_1_samp.t_test_1_samp_result import TTest1SampResult, _TTest1SampResult
    from ..univariate.test_distribution.test_distribution_result import TestDistributionResult, _TestDistributionResult
    from ..univariate.variance.variance_result import VarianceResult, _VarianceResult
    from ..univariate.z_test_1_samp.z_test_1_samp_result import ZTest1SampResult, _ZTest1SampResult
from ..computation_result.computation_result import ComputationResult, _ComputationResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.AvailableResult
Via: PyModel annotation in the class hierarchy
'''


class _AvailableResult(_ComputationResult, TypedDict):
    warnings: NotRequired[Optional[List[str]]]


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.AvailableResult
AvailableResult = Union[
    'Chi2IndTestResult',
    'CovarianceResult',
    'Fit2DDistributionResult',
    'FitCurveResult',
    'KendallTauResult',
    'MutualInformationResult',
    'PearsonResult',
    'SpearmanResult',
    'CountResult',
    'DummyComputationResult',
    'GroupedComputationResult',
    'MultiComputationResult',
    'ResampledComputationResult',
    'FetchCSVResult',
    'FetchValuesResult',
    'PCAResult',
    'ACFResult',
    'DurbinWatsonResult',
    'MannKendallTestResult',
    'PACFResult',
    'STLDecompositionResult',
    'UnitRootTestADFResult',
    'UnitRootTestKPSSResult',
    'UnitRootTestZAResult',
    'CountDistinctResult',
    'EmpiricalCDFResult',
    'EntropyResult',
    'FitDistributionResult',
    'GuessTimeStepResult',
    'KsTest2SampResult',
    'KurtosisResult',
    'LeveneTestNSampResult',
    'MatchTimeStepResult',
    'MaxResult',
    'MaxTimeResult',
    'MeanResult',
    'MinResult',
    'MinTimeResult',
    'MoodTestNSampResult',
    'OneWayAnovaResult',
    'PairwiseLeveneTestResult',
    'PairwiseMoodTestResult',
    'PairwiseTTestResult',
    'QuantilesResult',
    'SemResult',
    'ShapiroResult',
    'SignTest1SampResult',
    'SkewnessResult',
    'StdDevResult',
    'SumResult',
    'TTest1SampResult',
    'TestDistributionResult',
    'VarianceResult',
    'ZTest1SampResult',
]

# Types of class com.dataiku.dip.eda.compute.computations.AvailableResult in PolyJSON mappings (as literal type)
AvailableResultTypeLiteral = Literal["chi2_ind_test", "covariance", "fit_2d_distribution", "fit_curve", "kendall_tau", "mutual_information", "pearson", "spearman", "count", "dummy", "grouped", "multi", "resampled", "fetch_csv", "fetch_values", "pca", "acf", "durbin_watson", "mann_kendall", "pacf", "stl_decomposition", "unit_root_adf", "unit_root_kpss", "unit_root_za", "count_distinct", "empirical_cdf", "entropy", "fit_distribution", "guess_time_step", "ks_test_2samp", "kurtosis", "levene_test_nsamp", "match_time_step", "max", "max_time", "mean", "min", "min_time", "mood_test_nsamp", "one_way_anova", "pairwise_levene_test", "pairwise_mood_test", "pairwise_ttest", "quantiles", "sem", "shapiro", "sign_test_1samp", "skewness", "std_dev", "sum", "ttest_1samp", "test_distribution", "variance", "ztest_1samp", ]


# EOF
