from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..anum_grouping.anum_grouping_result import AnumGroupingResult, _AnumGroupingResult
    from ..binned_grouping.binned_grouping_result import BinnedGroupingResult, _BinnedGroupingResult
    from ..cross_grouping.cross_grouping_result import CrossGroupingResult, _CrossGroupingResult
    from ..merge_grouping.merge_grouping_result import MergeGroupingResult, _MergeGroupingResult
    from ..multi_anum_grouping.multi_anum_grouping_result import MultiAnumGroupingResult, _MultiAnumGroupingResult
    from ..subsampled_grouping.subsampled_grouping_result import SubsampledGroupingResult, _SubsampledGroupingResult
    from ..subset_grouping.subset_grouping_result import SubsetGroupingResult, _SubsetGroupingResult
    from ..top_n_time_grouping.top_n_time_grouping_result import TopNTimeGroupingResult, _TopNTimeGroupingResult
    from ..union_grouping.union_grouping_result import UnionGroupingResult, _UnionGroupingResult
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.grouping.GroupingResult
Via: com.dataiku.dip.eda.compute.computations.common.GroupedComputation$GroupedComputationResult
'''


class _GroupingResult(_ImmutableValueObject, TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.eda.compute.grouping.GroupingResult
GroupingResult = Union[
    'AnumGroupingResult',
    'BinnedGroupingResult',
    'CrossGroupingResult',
    'MergeGroupingResult',
    'MultiAnumGroupingResult',
    'SubsampledGroupingResult',
    'SubsetGroupingResult',
    'TopNTimeGroupingResult',
    'UnionGroupingResult',
]

# Types of class com.dataiku.dip.eda.compute.grouping.GroupingResult in PolyJSON mappings (as literal type)
GroupingResultTypeLiteral = Literal["anum", "binned", "cross", "merge", "multi_anum", "subsampled", "subset", "topn_time", "union", ]


# EOF
