class Artifact:
    def __init__(self, json):
        """
        Instantiate a new Govern Artifact.

        :param str json: A Python dict containing the artifact data.
            This class is actually mostly a wrapper around that json dict.
        """
        self.json = json

    @property
    def id(self):
        """
        Return the artifact id.

        :return: the artifact id as a Python str
        """
        if 'id' not in self.json:
            raise Exception("id not set for artifact {name}".format(name=self.name))
        return self.json.get('id')

    @property
    def name(self):
        """
        Return the artifact name.

        :return: the artifact name as a Python str
        """
        return self.json.get('name')

    @name.setter
    def name(self, name):
        """
        Set the artifact name.

        :param str name: the artifact name

        :return: None
        """
        self.json['name'] = name

    @property
    def fields(self):
        """
        Return the artifact fields.

        :return: the artifact fields as a Python dict
        """
        return self.json.get('fields', {})

    @fields.setter
    def fields(self, fields):
        """
        Set the artifact fields.

        :param dict fields: the artifact fields

        :return: None
        """
        self.json['fields'] = fields
