dataframe_to_dss_schema <- function(df) {
    # First, we build the DSS schema in JSON
    outputSchema <- list()
    outputSchema[["userModified"]] <- FALSE
    convertedColumns = list()
    for(i in 1:length(df)) {
        columnName <- colnames(df[i])
        columnRType <- class(df[[i]])
        columnDSSType <- "string"
        if(length(columnRType) == 1) {
            if(columnRType == "numeric") {
                columnDSSType <- "double"
            }
            if(columnRType == "integer") {
                columnDSSType <- "bigint"
            }
            if(columnRType == "logical") {
                columnDSSType <- "boolean"
            }
            # In type system v1, this will automatically roll back to string
            if(columnRType == "Date") {
                columnDSSType <- "dateonly"
            }
        }
        if(inherits(df[[i]], "POSIXt")) {
            # In type system v1, these will automatically roll back to string
            columnTZone <- attr(df[, i], "tzone")
            if (dku__is_timezone_set(columnTZone)) {
                columnDSSType <- "date"
            } else {
                columnDSSType <- "datetimenotz"
            }
        }
        convertedColumn = {}
        convertedColumn$name <- columnName
        convertedColumn$type <- columnDSSType
        convertedColumns[[length(convertedColumns)+1]] <- convertedColumn
    }
    outputSchema$columns=convertedColumns
    return(outputSchema)
}