from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .llm_mesh_trace_event import LLMMeshTraceEvent, _LLMMeshTraceEvent
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$LLMMeshTraceObservation
Via: com.dataiku.dip.llm.online.LLMClient$LLMMeshTraceSpan
'''


class _LLMMeshTraceObservation(TypedDict):
    attributes: Dict[str, Any]
    children: List['_LLMMeshTraceObservation']
    inputs: NotRequired[Optional[Dict[str, Any]]]
    name: str
    outputs: NotRequired[Optional[Dict[str, Any]]]


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$LLMMeshTraceObservation
LLMMeshTraceObservation = Union[
    'LLMMeshTraceEvent',
    'LLMMeshTraceSpan',
]

# Types of class com.dataiku.dip.llm.online.LLMClient$LLMMeshTraceObservation in PolyJSON mappings (as literal type)
LLMMeshTraceObservationTypeLiteral = Literal["event", "span", ]


# EOF
