import sys

from typing import Any as _Any, Generic as _Generic


class _SubscriptableAny:
    def __getitem__(self, params):
        return _Any


Literal = _SubscriptableAny()
Final = _SubscriptableAny()
NotRequired = _SubscriptableAny()


# TypedDict with generics
def _dict_new(*args, **kwargs):
    if not args:
        raise TypeError('TypedDict.__new__(): not enough arguments')
    _, args = args[0], args[1:]  # allow the "cls" keyword be passed
    return dict(*args, **kwargs)


_dict_new.__text_signature__ = '($cls, _typename, _fields=None, /, **kwargs)'


def _typeddict_new(*args, total=True, **kwargs):
    if not args:
        raise TypeError('TypedDict.__new__(): not enough arguments')
    _, args = args[0], args[1:]  # allow the "cls" keyword be passed
    if args:
        typename, args = args[0], args[1:]  # allow the "_typename" keyword be passed
    elif '_typename' in kwargs:
        typename = kwargs.pop('_typename')
    else:
        raise TypeError("TypedDict.__new__() missing 1 required positional "
                        "argument: '_typename'")
    if args:
        try:
            fields, = args  # allow the "_fields" keyword be passed
        except ValueError:
            raise TypeError('TypedDict.__new__() takes from 2 to 3 '
                            f'positional arguments but {len(args) + 2} '
                            'were given')
    elif '_fields' in kwargs and len(kwargs) == 1:
        fields = kwargs.pop('_fields')
        import warnings
        warnings.warn("Passing '_fields' as keyword argument is deprecated",
                      DeprecationWarning, stacklevel=2)
    else:
        fields = None

    if fields is None:
        fields = kwargs
    elif kwargs:
        raise TypeError("TypedDict takes either a dict or keyword arguments,"
                        " but not both")

    ns = {'__annotations__': dict(fields)}
    try:
        # Setting correct module is necessary to make typed dict classes pickleable.
        ns['__module__'] = sys._getframe(1).f_globals.get('__name__', '__main__')
    except (AttributeError, ValueError):
        pass

    return _TypedDictMeta(typename, (), ns, total=total)


_typeddict_new.__text_signature__ = ('($cls, _typename, _fields=None,'
                                     ' /, *, total=True, **kwargs)')


# type(Generic) is necessary to be able to do ClassA(Generic[T], TypedDict)
# it's very ugly and maybe unstable but it works for generated types, and it shouldn't crash
class _TypedDictMeta(type(_Generic)):
    def __init__(cls, name, bases, ns, total=True):
        super().__init__(name, bases, ns)

    def __new__(cls, name, bases, ns, total=True, **kwargs):
        ns['__new__'] = _typeddict_new if name == 'TypedDict' else _dict_new
        tp_dict = super().__new__(cls, name, (dict,), ns)
        if not hasattr(tp_dict, '__total__'):
            tp_dict.__total__ = total
        return tp_dict

    # Fixes "double" generics (ClassB(ClassA, TypedDict), ClassA(Generic[T], TypedDict))
    def __getitem__(self, params):
        return TypedDict

    def __subclasscheck__(cls, other):
        if sys.version_info >= (3, 8):
            # typing_extensions 4.7.0 switch to this (Python 3.7 support is dropped in 4.8.0)
            raise TypeError('TypedDict does not support instance and class checks')
        else:
            # Taken from https://github.com/python/typing_extensions/blob/4.1.1/src/typing_extensions.py#L1056-L1065
            try:
                if sys._getframe(1).f_globals['__name__'] not in ['abc',
                                                                'functools',
                                                                'typing']:
                    # Typed dicts are only for static structural subtyping.
                    raise TypeError('TypedDict does not support instance and class checks')
            except (AttributeError, ValueError):
                pass
            return False

    __instancecheck__ = __subclasscheck__


TypedDict = _TypedDictMeta('TypedDict', (dict,), {})
TypedDict.__module__ = __name__
