from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...llm.online.llm_client.completion_settings import CompletionSettings, _CompletionSettings
    from .llm_request_block import LLMRequestBlock, _LLMRequestBlock
    from .output_mode import OutputMode
    from .standard_react_block import StandardReactBlock, _StandardReactBlock
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$LLMBaseBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _LLMBaseBlock(_BlocksGraphBlock, TypedDict):
    additionalUserMessage: str
    completionSettings: 'CompletionSettings'
    llmId: str
    outputMode: 'OutputMode'
    outputScratchpadKey: str
    outputStateKey: str
    passConversationHistory: bool
    streamOutput: bool
    systemPromptAfterHistory: str
    systemPromptBeforeHistory: str


# List of all concrete subclasses of com.dataiku.dip.dao.SavedModel$LLMBaseBlock
LLMBaseBlock = Union[
    'LLMRequestBlock',
    'StandardReactBlock',
]

# Types of class com.dataiku.dip.dao.SavedModel$LLMBaseBlock in PolyJSON mappings (as literal type)
LLMBaseBlockTypeLiteral = Literal["LLM_REQUEST", "STANDARD_REACT", ]


# EOF
