from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .expression_language import ExpressionLanguage
    from .filter_ui_data import FilterUiData, _FilterUiData

'''
Translated from class com.dataiku.dip.dataflow.exec.filter.FilterDesc
Via: com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings
'''


class _FilterDesc(TypedDict):
    distinct: bool
    enabled: bool
    expression: NotRequired[Optional[str]]
    language: NotRequired[Optional['ExpressionLanguage']]
    uiData: NotRequired[Optional['FilterUiData']]


FilterDesc = _FilterDesc


# EOF
