from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..unit_root_test_adf.unit_root_test_adf_result import UnitRootTestADFResult, _UnitRootTestADFResult
    from ..unit_root_test_kpss.unit_root_test_kpss_result import UnitRootTestKPSSResult, _UnitRootTestKPSSResult
    from ..unit_root_test_za.unit_root_test_za_result import UnitRootTestZAResult, _UnitRootTestZAResult
from ...available_result.available_result import AvailableResult, _AvailableResult

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest$UnitRootTestResult
Via: PyModel annotation in the class hierarchy
'''


class _UnitRootTestResult(_AvailableResult, TypedDict):
    criticalValues: Dict[str, float]
    nObservations: int
    pValue: float
    statistic: float
    usedLag: int


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest$UnitRootTestResult
UnitRootTestResult = Union[
    'UnitRootTestADFResult',
    'UnitRootTestKPSSResult',
    'UnitRootTestZAResult',
]

# Types of class com.dataiku.dip.eda.compute.computations.timeseries.UnitRootTest$UnitRootTestResult in PolyJSON mappings (as literal type)
UnitRootTestResultTypeLiteral = Literal["unit_root_adf", "unit_root_kpss", "unit_root_za", ]


# EOF
