/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.util.ExponentialBackOff;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationType;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CoopLockRecordsDao;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.DeleteOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.RenameOperation;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.RenameOperationLogRecord;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Stopwatch;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Streams;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.Uninterruptibles;
import com.google.cloud.hadoop.repackaged.gcs.com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CoopLockOperationDao {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final String OPERATION_LOG_FILE_FORMAT = "%s_%s_%s.log";
    private static final String OPERATION_LOCK_FILE_FORMAT = "%s_%s_%s.lock";
    private static final CreateObjectOptions CREATE_OBJECT_OPTIONS = CreateObjectOptions.DEFAULT_NO_OVERWRITE.toBuilder().setContentType("application/text").build();
    private static final CreateObjectOptions UPDATE_OBJECT_OPTIONS = CreateObjectOptions.DEFAULT_OVERWRITE.toBuilder().setContentType("application/text").build();
    private static final int LOCK_MODIFY_RETRY_BACK_OFF_MILLIS = 1100;
    private static final int MAX_LOCK_RENEW_TIMEOUT_MILLIS = 11000;
    private static final DateTimeFormatter LOCK_FILE_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss.SSSXXX").withZone(ZoneOffset.UTC);
    private static final Gson GSON = CoopLockRecordsDao.createGson();
    private final ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(0, new ThreadFactoryBuilder().setNameFormat("coop-lock-thread-%d").setDaemon(true).build());
    private final GoogleCloudStorage gcs;
    private final CooperativeLockingOptions options;

    public CoopLockOperationDao(GoogleCloudStorage gcs) {
        this.gcs = gcs;
        this.options = gcs.getOptions().getCooperativeLockingOptions();
    }

    public Future<?> persistDeleteOperation(String operationId, Instant operationInstant, StorageResourceId resourceId, List<FileInfo> itemsToDelete, List<FileInfo> bucketsToDelete) throws IOException {
        URI operationLockPath = this.writeOperationFile(resourceId.getBucketName(), OPERATION_LOCK_FILE_FORMAT, CREATE_OBJECT_OPTIONS, CoopLockOperationType.DELETE, operationId, operationInstant, ImmutableList.of(GSON.toJson(new DeleteOperation().setLockExpiration(Instant.now().plusMillis(this.options.getLockExpirationTimeoutMilli())).setResource(resourceId.toString()))));
        List logRecords = Streams.concat(itemsToDelete.stream(), bucketsToDelete.stream()).map(i -> i.getPath().toString()).collect(ImmutableList.toImmutableList());
        this.writeOperationFile(resourceId.getBucketName(), OPERATION_LOG_FILE_FORMAT, CREATE_OBJECT_OPTIONS, CoopLockOperationType.DELETE, operationId, operationInstant, logRecords);
        return this.scheduleLockUpdate(operationId, operationLockPath, DeleteOperation.class, (operation, updateInstant) -> operation.setLockExpiration(updateInstant.plusMillis(this.options.getLockExpirationTimeoutMilli())));
    }

    public Future<?> persistRenameOperation(String operationId, Instant operationInstant, StorageResourceId src, StorageResourceId dst, Map<FileInfo, URI> srcToDstItemNames, Map<FileInfo, URI> srcToDstMarkerItemNames) throws IOException {
        URI operationLockPath = this.writeOperationFile(dst.getBucketName(), OPERATION_LOCK_FILE_FORMAT, CREATE_OBJECT_OPTIONS, CoopLockOperationType.RENAME, operationId, operationInstant, ImmutableList.of(GSON.toJson(new RenameOperation().setLockExpiration(Instant.now().plusMillis(this.options.getLockExpirationTimeoutMilli())).setSrcResource(src.toString()).setDstResource(dst.toString()).setCopySucceeded(false))));
        List logRecords = Streams.concat(srcToDstItemNames.entrySet().stream(), srcToDstMarkerItemNames.entrySet().stream()).map(e -> GSON.toJson(CoopLockOperationDao.toRenameOperationLogRecord(e))).collect(ImmutableList.toImmutableList());
        this.writeOperationFile(dst.getBucketName(), OPERATION_LOG_FILE_FORMAT, CREATE_OBJECT_OPTIONS, CoopLockOperationType.RENAME, operationId, operationInstant, logRecords);
        return this.scheduleLockUpdate(operationId, operationLockPath, RenameOperation.class, (o, updateInstant) -> o.setLockExpiration(updateInstant.plusMillis(this.options.getLockExpirationTimeoutMilli())));
    }

    public void checkpointRenameOperation(String bucketName, String operationId, Instant operationInstant, boolean copySucceeded) throws IOException {
        URI operationLockPath = this.getOperationFilePath(bucketName, OPERATION_LOCK_FILE_FORMAT, CoopLockOperationType.RENAME, operationId, operationInstant);
        ExponentialBackOff backOff = CoopLockOperationDao.newLockModifyBackoff();
        for (int i = 0; i < 10; ++i) {
            try {
                this.modifyOperationLock(operationId, operationLockPath, l -> {
                    RenameOperation operation = GSON.fromJson((String)l, RenameOperation.class);
                    operation.setLockExpiration(Instant.now().plusMillis(this.options.getLockExpirationTimeoutMilli())).setCopySucceeded(copySucceeded);
                    return GSON.toJson(operation);
                });
                return;
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to checkpoint '%s' lock for %s operation, attempt #%d", operationLockPath, operationId, i + 1);
                Uninterruptibles.sleepUninterruptibly(Duration.ofMillis(backOff.nextBackOffMillis()));
                continue;
            }
        }
        throw new IOException(String.format("Failed to checkpoint '%s' lock for %s operation", operationLockPath, operationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renewLockOrExit(String operationId, URI operationLockPath, Function<String, String> renewFn, Duration timeout) {
        block8: {
            Stopwatch stopwatch = Stopwatch.createStarted();
            AtomicBoolean renewalSucceeded = new AtomicBoolean(false);
            ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> timeoutFuture = timeoutExecutor.schedule(() -> {
                if (renewalSucceeded.get()) {
                    return;
                }
                ((GoogleLogger.Api)logger.atSevere()).log("Renewal of '%s' lock for %s operation timed out in %s, exiting", operationLockPath, operationId, timeout);
                System.exit(1);
            }, timeout.toMillis(), TimeUnit.MILLISECONDS);
            int attempt = 1;
            ExponentialBackOff backoff = CoopLockOperationDao.newLockModifyBackoff();
            while (true) {
                try {
                    ((GoogleLogger.Api)logger.atFine()).log("Renewing '%s' lock for %s operation with %s timeout after %s, attempt %d", operationLockPath, operationId, timeout, stopwatch.elapsed(), attempt);
                    this.modifyOperationLock(operationId, operationLockPath, renewFn);
                    renewalSucceeded.set(true);
                    return;
                }
                catch (IOException e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to renew '%s' lock for %s operation with %s timeout after %s, attempt #%d", operationLockPath, operationId, timeout, stopwatch.elapsed(), attempt++);
                    Uninterruptibles.sleepUninterruptibly(Duration.ofMillis(backoff.nextBackOffMillis()));
                    if (timeout.compareTo(stopwatch.elapsed()) > 0) continue;
                    ((GoogleLogger.Api)logger.atSevere()).log("Renewal of '%s' lock for %s operation with %s timeout in %s, exiting", operationLockPath, operationId, timeout, stopwatch.elapsed());
                    System.exit(1);
                    break block8;
                }
                catch (Exception e) {
                    ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed to renew '%s' lock for %s operation with %s timeout in %s, exiting", operationLockPath, operationId, timeout, stopwatch.elapsed());
                    System.exit(1);
                    break block8;
                }
                break;
            }
            finally {
                timeoutFuture.cancel(true);
                timeoutExecutor.shutdownNow();
            }
        }
        System.exit(1);
    }

    private void modifyOperationLock(String operationId, URI operationLockPath, Function<String, String> modifyFn) throws IOException {
        String lock;
        StorageResourceId lockId = StorageResourceId.fromUriPath(operationLockPath, false);
        GoogleCloudStorageItemInfo lockInfo = this.gcs.getItemInfo(lockId);
        Preconditions.checkState(lockInfo.exists(), "lock file for %s operation should exist", (Object)operationId);
        try (BufferedReader reader = new BufferedReader(Channels.newReader((ReadableByteChannel)this.gcs.open(lockId), StandardCharsets.UTF_8.name()));){
            lock = reader.lines().collect(Collectors.joining());
        }
        lock = modifyFn.apply(lock);
        StorageResourceId lockIdWithGeneration = new StorageResourceId(lockId.getBucketName(), lockId.getObjectName(), lockInfo.getContentGeneration());
        this.writeOperation(lockIdWithGeneration, UPDATE_OBJECT_OPTIONS, ImmutableList.of(lock));
    }

    private URI writeOperationFile(String bucket, String fileNameFormat, CreateObjectOptions createObjectOptions, CoopLockOperationType operationType, String operationId, Instant operationInstant, List<String> records) throws IOException {
        URI path = this.getOperationFilePath(bucket, fileNameFormat, operationType, operationId, operationInstant);
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, false);
        this.writeOperation(resourceId, createObjectOptions, records);
        return path;
    }

    private URI getOperationFilePath(String bucket, String fileNameFormat, CoopLockOperationType operationType, String operationId, Instant operationInstant) {
        String date = LOCK_FILE_DATE_TIME_FORMAT.format(operationInstant);
        String file = String.format("_lock/" + fileNameFormat, new Object[]{date, operationType, operationId});
        return UriPaths.fromStringPathComponents(bucket, file, false);
    }

    private void writeOperation(StorageResourceId resourceId, CreateObjectOptions createObjectOptions, List<String> records) throws IOException {
        try (WritableByteChannel channel = this.gcs.create(resourceId, createObjectOptions);){
            for (String record : records) {
                channel.write(ByteBuffer.wrap(record.getBytes(StandardCharsets.UTF_8)));
                channel.write(ByteBuffer.wrap(new byte[]{10}));
            }
        }
    }

    public <T> Future<?> scheduleLockUpdate(String operationId, URI operationLockPath, Class<T> clazz, BiConsumer<T, Instant> renewFn) {
        long lockRenewalPeriodMilli = this.options.getLockExpirationTimeoutMilli() / 2L;
        long lockRenewTimeoutMilli = Math.min(this.options.getLockExpirationTimeoutMilli() / 4L, 11000L);
        return this.scheduledThreadPool.scheduleAtFixedRate(() -> this.renewLockOrExit(operationId, operationLockPath, l -> {
            Object operation = GSON.fromJson((String)l, clazz);
            renewFn.accept(operation, Instant.now());
            return GSON.toJson(operation);
        }, Duration.ofMillis(lockRenewTimeoutMilli)), lockRenewalPeriodMilli, lockRenewalPeriodMilli, TimeUnit.MILLISECONDS);
    }

    private static RenameOperationLogRecord toRenameOperationLogRecord(Map.Entry<FileInfo, URI> record) {
        return new RenameOperationLogRecord().setSrc(record.getKey().getPath().toString()).setDst(record.getValue().toString());
    }

    private static ExponentialBackOff newLockModifyBackoff() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(1100).setMultiplier(1.1).setRandomizationFactor(0.2).setMaxIntervalMillis(1375).setMaxElapsedTimeMillis(Integer.MAX_VALUE).build();
    }
}

