/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.cache;

import java.nio.ByteBuffer;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;

public class DateColumnStatsDataInspector
extends DateColumnStatsData {
    private NumDistinctValueEstimator ndvEstimator;

    public DateColumnStatsDataInspector() {
    }

    public DateColumnStatsDataInspector(long numNulls, long numDVs) {
        super(numNulls, numDVs);
    }

    public DateColumnStatsDataInspector(DateColumnStatsDataInspector other) {
        super(other);
        if (other.ndvEstimator != null) {
            super.setBitVectors(this.ndvEstimator.serialize());
        }
    }

    @Override
    public DateColumnStatsDataInspector deepCopy() {
        return new DateColumnStatsDataInspector(this);
    }

    @Override
    public byte[] getBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.getBitVectors();
    }

    @Override
    public ByteBuffer bufferForBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.bufferForBitVectors();
    }

    @Override
    public void setBitVectors(byte[] bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    @Override
    public void setBitVectors(ByteBuffer bitVectors) {
        super.setBitVectors(bitVectors);
        this.ndvEstimator = null;
    }

    @Override
    public void unsetBitVectors() {
        super.unsetBitVectors();
        this.ndvEstimator = null;
    }

    @Override
    public boolean isSetBitVectors() {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        return super.isSetBitVectors();
    }

    @Override
    public void setBitVectorsIsSet(boolean value) {
        if (this.ndvEstimator != null) {
            this.updateBitVectors();
        }
        super.setBitVectorsIsSet(value);
    }

    public NumDistinctValueEstimator getNdvEstimator() {
        if (this.isSetBitVectors() && this.getBitVectors().length != 0) {
            this.updateNdvEstimator();
        }
        return this.ndvEstimator;
    }

    public void setNdvEstimator(NumDistinctValueEstimator ndvEstimator) {
        super.unsetBitVectors();
        this.ndvEstimator = ndvEstimator;
    }

    private void updateBitVectors() {
        super.setBitVectors(this.ndvEstimator.serialize());
        this.ndvEstimator = null;
    }

    private void updateNdvEstimator() {
        this.ndvEstimator = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator(super.getBitVectors());
        super.unsetBitVectors();
    }
}

