/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.expressions;

import org.apache.spark.SparkException;
import org.apache.spark.sql.delta.expressions.HilbertCompactStateList;
import org.apache.spark.sql.delta.expressions.HilbertIndex;

public class HilbertStates {
    private static HilbertCompactStateList constructHilbertState(int n) {
        HilbertIndex.GeneratorTable generatorTable = HilbertIndex.getStateGenerator(n);
        return generatorTable.generateStateList().getNPointToDKeyStateMap();
    }

    private HilbertStates() {
    }

    public static HilbertCompactStateList getStateList(int n) throws SparkException {
        switch (n) {
            case 2: {
                return HilbertIndex2.STATE_LIST;
            }
            case 3: {
                return HilbertIndex3.STATE_LIST;
            }
            case 4: {
                return HilbertIndex4.STATE_LIST;
            }
            case 5: {
                return HilbertIndex5.STATE_LIST;
            }
            case 6: {
                return HilbertIndex6.STATE_LIST;
            }
            case 7: {
                return HilbertIndex7.STATE_LIST;
            }
            case 8: {
                return HilbertIndex8.STATE_LIST;
            }
            case 9: {
                return HilbertIndex9.STATE_LIST;
            }
        }
        throw new SparkException(String.format("Cannot perform hilbert clustering on fewer than 2 or more than 9 dimensions; got %d dimensions", n));
    }

    static /* synthetic */ HilbertCompactStateList access$000(int n) {
        return HilbertStates.constructHilbertState(n);
    }

    private static class HilbertIndex9 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(9);

        private HilbertIndex9() {
        }
    }

    private static class HilbertIndex8 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(8);

        private HilbertIndex8() {
        }
    }

    private static class HilbertIndex7 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(7);

        private HilbertIndex7() {
        }
    }

    private static class HilbertIndex6 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(6);

        private HilbertIndex6() {
        }
    }

    private static class HilbertIndex5 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(5);

        private HilbertIndex5() {
        }
    }

    private static class HilbertIndex4 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(4);

        private HilbertIndex4() {
        }
    }

    private static class HilbertIndex3 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(3);

        private HilbertIndex3() {
        }
    }

    private static class HilbertIndex2 {
        static final HilbertCompactStateList STATE_LIST = HilbertStates.access$000(2);

        private HilbertIndex2() {
        }
    }
}

