/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.glue.model.ConfigurationObject;
import java.util.List;

@SdkInternalApi
public class ConfigurationObjectMarshaller {
    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DefaultValue").build();
    private static final MarshallingInfo<List> ALLOWEDVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AllowedValues").build();
    private static final MarshallingInfo<String> MINVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinValue").build();
    private static final MarshallingInfo<String> MAXVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxValue").build();
    private static final ConfigurationObjectMarshaller instance = new ConfigurationObjectMarshaller();

    public static ConfigurationObjectMarshaller getInstance() {
        return instance;
    }

    public void marshall(ConfigurationObject configurationObject, ProtocolMarshaller protocolMarshaller) {
        if (configurationObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)configurationObject.getDefaultValue(), DEFAULTVALUE_BINDING);
            protocolMarshaller.marshall(configurationObject.getAllowedValues(), ALLOWEDVALUES_BINDING);
            protocolMarshaller.marshall((Object)configurationObject.getMinValue(), MINVALUE_BINDING);
            protocolMarshaller.marshall((Object)configurationObject.getMaxValue(), MAXVALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

