/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.glue.catalog.metastore.AWSGlueDecoratorBase;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.BatchCreatePartitionRequest;
import com.amazonaws.services.glue.model.BatchCreatePartitionResult;
import com.amazonaws.services.glue.model.BatchDeletePartitionRequest;
import com.amazonaws.services.glue.model.BatchDeletePartitionResult;
import com.amazonaws.services.glue.model.BatchDeleteTableRequest;
import com.amazonaws.services.glue.model.BatchDeleteTableResult;
import com.amazonaws.services.glue.model.BatchGetPartitionRequest;
import com.amazonaws.services.glue.model.BatchGetPartitionResult;
import com.amazonaws.services.glue.model.CreateDatabaseRequest;
import com.amazonaws.services.glue.model.CreateDatabaseResult;
import com.amazonaws.services.glue.model.CreatePartitionRequest;
import com.amazonaws.services.glue.model.CreatePartitionResult;
import com.amazonaws.services.glue.model.CreateTableRequest;
import com.amazonaws.services.glue.model.CreateTableResult;
import com.amazonaws.services.glue.model.CreateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.CreateUserDefinedFunctionResult;
import com.amazonaws.services.glue.model.DeleteDatabaseRequest;
import com.amazonaws.services.glue.model.DeleteDatabaseResult;
import com.amazonaws.services.glue.model.DeletePartitionRequest;
import com.amazonaws.services.glue.model.DeletePartitionResult;
import com.amazonaws.services.glue.model.DeleteTableRequest;
import com.amazonaws.services.glue.model.DeleteTableResult;
import com.amazonaws.services.glue.model.DeleteUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.DeleteUserDefinedFunctionResult;
import com.amazonaws.services.glue.model.GetDatabaseRequest;
import com.amazonaws.services.glue.model.GetDatabaseResult;
import com.amazonaws.services.glue.model.GetPartitionRequest;
import com.amazonaws.services.glue.model.GetPartitionResult;
import com.amazonaws.services.glue.model.GetPartitionsRequest;
import com.amazonaws.services.glue.model.GetPartitionsResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTableVersionsRequest;
import com.amazonaws.services.glue.model.GetTableVersionsResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionResult;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsRequest;
import com.amazonaws.services.glue.model.GetUserDefinedFunctionsResult;
import com.amazonaws.services.glue.model.UpdateDatabaseRequest;
import com.amazonaws.services.glue.model.UpdateDatabaseResult;
import com.amazonaws.services.glue.model.UpdatePartitionRequest;
import com.amazonaws.services.glue.model.UpdatePartitionResult;
import com.amazonaws.services.glue.model.UpdateTableRequest;
import com.amazonaws.services.glue.model.UpdateTableResult;
import com.amazonaws.services.glue.model.UpdateUserDefinedFunctionRequest;
import com.amazonaws.services.glue.model.UpdateUserDefinedFunctionResult;
import com.google.common.base.Strings;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AWSGlueMultipleCatalogDecorator
extends AWSGlueDecoratorBase {
    private static final String DEFAULT_DATABASE_NAME = "default";
    private String catalogSeparator;

    public AWSGlueMultipleCatalogDecorator(AWSGlue awsGlueToBeDecorated, String catalogSeparator) {
        super(awsGlueToBeDecorated);
        this.catalogSeparator = catalogSeparator;
    }

    private void configureRequest(Supplier<String> getDatabaseFunc, Consumer<String> setDatabaseFunc, Consumer<String> setCatalogFunc) {
        String databaseName;
        int idx;
        if (!Strings.isNullOrEmpty((String)this.catalogSeparator) && getDatabaseFunc.get() != null && !getDatabaseFunc.get().equals(DEFAULT_DATABASE_NAME) && (idx = (databaseName = getDatabaseFunc.get()).indexOf(this.catalogSeparator)) >= 0) {
            setCatalogFunc.accept(databaseName.substring(0, idx));
            setDatabaseFunc.accept(databaseName.substring(idx + this.catalogSeparator.length()));
        }
    }

    @Override
    public BatchCreatePartitionResult batchCreatePartition(BatchCreatePartitionRequest batchCreatePartitionRequest) {
        this.configureRequest(() -> ((BatchCreatePartitionRequest)batchCreatePartitionRequest).getDatabaseName(), arg_0 -> ((BatchCreatePartitionRequest)batchCreatePartitionRequest).setDatabaseName(arg_0), arg_0 -> ((BatchCreatePartitionRequest)batchCreatePartitionRequest).setCatalogId(arg_0));
        return super.batchCreatePartition(batchCreatePartitionRequest);
    }

    @Override
    public BatchDeletePartitionResult batchDeletePartition(BatchDeletePartitionRequest batchDeletePartitionRequest) {
        this.configureRequest(() -> ((BatchDeletePartitionRequest)batchDeletePartitionRequest).getDatabaseName(), arg_0 -> ((BatchDeletePartitionRequest)batchDeletePartitionRequest).setDatabaseName(arg_0), arg_0 -> ((BatchDeletePartitionRequest)batchDeletePartitionRequest).setCatalogId(arg_0));
        return super.batchDeletePartition(batchDeletePartitionRequest);
    }

    @Override
    public BatchDeleteTableResult batchDeleteTable(BatchDeleteTableRequest batchDeleteTableRequest) {
        this.configureRequest(() -> ((BatchDeleteTableRequest)batchDeleteTableRequest).getDatabaseName(), arg_0 -> ((BatchDeleteTableRequest)batchDeleteTableRequest).setDatabaseName(arg_0), arg_0 -> ((BatchDeleteTableRequest)batchDeleteTableRequest).setCatalogId(arg_0));
        return super.batchDeleteTable(batchDeleteTableRequest);
    }

    @Override
    public BatchGetPartitionResult batchGetPartition(BatchGetPartitionRequest batchGetPartitionRequest) {
        String originalDatabaseName = batchGetPartitionRequest.getDatabaseName();
        this.configureRequest(() -> ((BatchGetPartitionRequest)batchGetPartitionRequest).getDatabaseName(), arg_0 -> ((BatchGetPartitionRequest)batchGetPartitionRequest).setDatabaseName(arg_0), arg_0 -> ((BatchGetPartitionRequest)batchGetPartitionRequest).setCatalogId(arg_0));
        BatchGetPartitionResult result = super.batchGetPartition(batchGetPartitionRequest);
        result.getPartitions().forEach(partition -> partition.setDatabaseName(originalDatabaseName));
        return result;
    }

    @Override
    public CreateDatabaseResult createDatabase(CreateDatabaseRequest createDatabaseRequest) {
        this.configureRequest(() -> createDatabaseRequest.getDatabaseInput().getName(), name -> createDatabaseRequest.getDatabaseInput().setName(name), arg_0 -> ((CreateDatabaseRequest)createDatabaseRequest).setCatalogId(arg_0));
        return super.createDatabase(createDatabaseRequest);
    }

    @Override
    public CreatePartitionResult createPartition(CreatePartitionRequest createPartitionRequest) {
        this.configureRequest(() -> ((CreatePartitionRequest)createPartitionRequest).getDatabaseName(), arg_0 -> ((CreatePartitionRequest)createPartitionRequest).setDatabaseName(arg_0), arg_0 -> ((CreatePartitionRequest)createPartitionRequest).setCatalogId(arg_0));
        return super.createPartition(createPartitionRequest);
    }

    @Override
    public CreateTableResult createTable(CreateTableRequest createTableRequest) {
        this.configureRequest(() -> ((CreateTableRequest)createTableRequest).getDatabaseName(), arg_0 -> ((CreateTableRequest)createTableRequest).setDatabaseName(arg_0), arg_0 -> ((CreateTableRequest)createTableRequest).setCatalogId(arg_0));
        return super.createTable(createTableRequest);
    }

    @Override
    public CreateUserDefinedFunctionResult createUserDefinedFunction(CreateUserDefinedFunctionRequest createUserDefinedFunctionRequest) {
        this.configureRequest(() -> ((CreateUserDefinedFunctionRequest)createUserDefinedFunctionRequest).getDatabaseName(), arg_0 -> ((CreateUserDefinedFunctionRequest)createUserDefinedFunctionRequest).setDatabaseName(arg_0), arg_0 -> ((CreateUserDefinedFunctionRequest)createUserDefinedFunctionRequest).setCatalogId(arg_0));
        return super.createUserDefinedFunction(createUserDefinedFunctionRequest);
    }

    @Override
    public DeleteDatabaseResult deleteDatabase(DeleteDatabaseRequest deleteDatabaseRequest) {
        this.configureRequest(() -> ((DeleteDatabaseRequest)deleteDatabaseRequest).getName(), arg_0 -> ((DeleteDatabaseRequest)deleteDatabaseRequest).setName(arg_0), arg_0 -> ((DeleteDatabaseRequest)deleteDatabaseRequest).setCatalogId(arg_0));
        return super.deleteDatabase(deleteDatabaseRequest);
    }

    @Override
    public DeletePartitionResult deletePartition(DeletePartitionRequest deletePartitionRequest) {
        this.configureRequest(() -> ((DeletePartitionRequest)deletePartitionRequest).getDatabaseName(), arg_0 -> ((DeletePartitionRequest)deletePartitionRequest).setDatabaseName(arg_0), arg_0 -> ((DeletePartitionRequest)deletePartitionRequest).setCatalogId(arg_0));
        return super.deletePartition(deletePartitionRequest);
    }

    @Override
    public DeleteTableResult deleteTable(DeleteTableRequest deleteTableRequest) {
        this.configureRequest(() -> ((DeleteTableRequest)deleteTableRequest).getDatabaseName(), arg_0 -> ((DeleteTableRequest)deleteTableRequest).setDatabaseName(arg_0), arg_0 -> ((DeleteTableRequest)deleteTableRequest).setCatalogId(arg_0));
        return super.deleteTable(deleteTableRequest);
    }

    @Override
    public DeleteUserDefinedFunctionResult deleteUserDefinedFunction(DeleteUserDefinedFunctionRequest deleteUserDefinedFunctionRequest) {
        this.configureRequest(() -> ((DeleteUserDefinedFunctionRequest)deleteUserDefinedFunctionRequest).getDatabaseName(), arg_0 -> ((DeleteUserDefinedFunctionRequest)deleteUserDefinedFunctionRequest).setDatabaseName(arg_0), arg_0 -> ((DeleteUserDefinedFunctionRequest)deleteUserDefinedFunctionRequest).setCatalogId(arg_0));
        return super.deleteUserDefinedFunction(deleteUserDefinedFunctionRequest);
    }

    @Override
    public GetDatabaseResult getDatabase(GetDatabaseRequest getDatabaseRequest) {
        String originalDatabaseName = getDatabaseRequest.getName();
        this.configureRequest(() -> ((GetDatabaseRequest)getDatabaseRequest).getName(), arg_0 -> ((GetDatabaseRequest)getDatabaseRequest).setName(arg_0), arg_0 -> ((GetDatabaseRequest)getDatabaseRequest).setCatalogId(arg_0));
        GetDatabaseResult result = super.getDatabase(getDatabaseRequest);
        result.getDatabase().setName(originalDatabaseName);
        return result;
    }

    @Override
    public GetPartitionResult getPartition(GetPartitionRequest getPartitionRequest) {
        String originalDatabaseName = getPartitionRequest.getDatabaseName();
        this.configureRequest(() -> ((GetPartitionRequest)getPartitionRequest).getDatabaseName(), arg_0 -> ((GetPartitionRequest)getPartitionRequest).setDatabaseName(arg_0), arg_0 -> ((GetPartitionRequest)getPartitionRequest).setCatalogId(arg_0));
        GetPartitionResult result = super.getPartition(getPartitionRequest);
        result.getPartition().setDatabaseName(originalDatabaseName);
        return result;
    }

    @Override
    public GetPartitionsResult getPartitions(GetPartitionsRequest getPartitionsRequest) {
        String originalDatabaseName = getPartitionsRequest.getDatabaseName();
        this.configureRequest(() -> ((GetPartitionsRequest)getPartitionsRequest).getDatabaseName(), arg_0 -> ((GetPartitionsRequest)getPartitionsRequest).setDatabaseName(arg_0), arg_0 -> ((GetPartitionsRequest)getPartitionsRequest).setCatalogId(arg_0));
        GetPartitionsResult result = super.getPartitions(getPartitionsRequest);
        result.getPartitions().forEach(partition -> partition.setDatabaseName(originalDatabaseName));
        return result;
    }

    @Override
    public GetTableResult getTable(GetTableRequest getTableRequest) {
        String originalDatabaseName = getTableRequest.getDatabaseName();
        this.configureRequest(() -> ((GetTableRequest)getTableRequest).getDatabaseName(), arg_0 -> ((GetTableRequest)getTableRequest).setDatabaseName(arg_0), arg_0 -> ((GetTableRequest)getTableRequest).setCatalogId(arg_0));
        GetTableResult result = super.getTable(getTableRequest);
        result.getTable().setDatabaseName(originalDatabaseName);
        return result;
    }

    @Override
    public GetTableVersionsResult getTableVersions(GetTableVersionsRequest getTableVersionsRequest) {
        String originalDatabaseName = getTableVersionsRequest.getDatabaseName();
        this.configureRequest(() -> ((GetTableVersionsRequest)getTableVersionsRequest).getDatabaseName(), arg_0 -> ((GetTableVersionsRequest)getTableVersionsRequest).setDatabaseName(arg_0), arg_0 -> ((GetTableVersionsRequest)getTableVersionsRequest).setCatalogId(arg_0));
        GetTableVersionsResult result = super.getTableVersions(getTableVersionsRequest);
        result.getTableVersions().forEach(tableVersion -> tableVersion.getTable().setDatabaseName(originalDatabaseName));
        return result;
    }

    @Override
    public GetTablesResult getTables(GetTablesRequest getTablesRequest) {
        String originalDatabaseName = getTablesRequest.getDatabaseName();
        this.configureRequest(() -> ((GetTablesRequest)getTablesRequest).getDatabaseName(), arg_0 -> ((GetTablesRequest)getTablesRequest).setDatabaseName(arg_0), arg_0 -> ((GetTablesRequest)getTablesRequest).setCatalogId(arg_0));
        GetTablesResult result = super.getTables(getTablesRequest);
        result.getTableList().forEach(table -> table.setDatabaseName(originalDatabaseName));
        return result;
    }

    @Override
    public GetUserDefinedFunctionResult getUserDefinedFunction(GetUserDefinedFunctionRequest getUserDefinedFunctionRequest) {
        this.configureRequest(() -> ((GetUserDefinedFunctionRequest)getUserDefinedFunctionRequest).getDatabaseName(), arg_0 -> ((GetUserDefinedFunctionRequest)getUserDefinedFunctionRequest).setDatabaseName(arg_0), arg_0 -> ((GetUserDefinedFunctionRequest)getUserDefinedFunctionRequest).setCatalogId(arg_0));
        return super.getUserDefinedFunction(getUserDefinedFunctionRequest);
    }

    @Override
    public GetUserDefinedFunctionsResult getUserDefinedFunctions(GetUserDefinedFunctionsRequest getUserDefinedFunctionsRequest) {
        this.configureRequest(() -> ((GetUserDefinedFunctionsRequest)getUserDefinedFunctionsRequest).getDatabaseName(), arg_0 -> ((GetUserDefinedFunctionsRequest)getUserDefinedFunctionsRequest).setDatabaseName(arg_0), arg_0 -> ((GetUserDefinedFunctionsRequest)getUserDefinedFunctionsRequest).setCatalogId(arg_0));
        return super.getUserDefinedFunctions(getUserDefinedFunctionsRequest);
    }

    @Override
    public UpdateDatabaseResult updateDatabase(UpdateDatabaseRequest updateDatabaseRequest) {
        this.configureRequest(() -> ((UpdateDatabaseRequest)updateDatabaseRequest).getName(), arg_0 -> ((UpdateDatabaseRequest)updateDatabaseRequest).setName(arg_0), arg_0 -> ((UpdateDatabaseRequest)updateDatabaseRequest).setCatalogId(arg_0));
        this.configureRequest(() -> updateDatabaseRequest.getDatabaseInput().getName(), name -> updateDatabaseRequest.getDatabaseInput().setName(name), catalogId -> {});
        return super.updateDatabase(updateDatabaseRequest);
    }

    @Override
    public UpdatePartitionResult updatePartition(UpdatePartitionRequest updatePartitionRequest) {
        this.configureRequest(() -> ((UpdatePartitionRequest)updatePartitionRequest).getDatabaseName(), arg_0 -> ((UpdatePartitionRequest)updatePartitionRequest).setDatabaseName(arg_0), arg_0 -> ((UpdatePartitionRequest)updatePartitionRequest).setCatalogId(arg_0));
        return super.updatePartition(updatePartitionRequest);
    }

    @Override
    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) {
        this.configureRequest(() -> ((UpdateTableRequest)updateTableRequest).getDatabaseName(), arg_0 -> ((UpdateTableRequest)updateTableRequest).setDatabaseName(arg_0), arg_0 -> ((UpdateTableRequest)updateTableRequest).setCatalogId(arg_0));
        return super.updateTable(updateTableRequest);
    }

    @Override
    public UpdateUserDefinedFunctionResult updateUserDefinedFunction(UpdateUserDefinedFunctionRequest updateUserDefinedFunctionRequest) {
        this.configureRequest(() -> ((UpdateUserDefinedFunctionRequest)updateUserDefinedFunctionRequest).getDatabaseName(), arg_0 -> ((UpdateUserDefinedFunctionRequest)updateUserDefinedFunctionRequest).setDatabaseName(arg_0), arg_0 -> ((UpdateUserDefinedFunctionRequest)updateUserDefinedFunctionRequest).setCatalogId(arg_0));
        return super.updateUserDefinedFunction(updateUserDefinedFunctionRequest);
    }
}

