/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(unit, quantity, timestamp) - Adds the specified number of units to the given timestamp.", arguments="\n    Arguments:\n      * unit - this indicates the units of datetime that you want to add.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\", \"DAYOFYEAR\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * quantity - this is the number of units of time that you want to add.\n      * timestamp - this is a timestamp (w/ or w/o timezone) to which you want to add.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, 8, timestamp_ntz'2022-02-11 20:30:00');\n       2022-02-12 04:30:00\n      > SELECT _FUNC_(MONTH, 1, timestamp_ltz'2022-01-31 00:00:00');\n       2022-02-28 00:00:00\n      > SELECT _FUNC_(SECOND, -10, date'2022-01-01');\n       2021-12-31 23:59:50\n      > SELECT _FUNC_(YEAR, 10, timestamp'2000-01-01 01:02:03.123456');\n       2010-01-01 01:02:03.123456\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\t}c\u0001\u0002\u0016,\u0001bB\u0001b\u0015\u0001\u0003\u0016\u0004%\t\u0001\u0016\u0005\tA\u0002\u0011\t\u0012)A\u0005+\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00035\u0001\u0005#\u0005\u000b\u0011B2\t\u0011%\u0004!Q3A\u0005\u0002)D\u0001B\u001c\u0001\u0003\u0012\u0003\u0006Ia\u001b\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0006_\u0002!\tA\u001e\u0005\u0006u\u0002!\tE\u0019\u0005\u0006w\u0002!\tE\u0019\u0005\u0006y\u0002!\t% \u0005\b\u00033\u0001A\u0011IA\u000e\u0011\u001d\t\u0019\u0003\u0001C!\u0003KA!\"!\u000b\u0001\u0011\u000b\u0007I\u0011BA\u0016\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!a\u0016\u0001\t\u0003\nI\u0006\u0003\u0004\u0002v\u0001!\t\u0005\u0016\u0005\u0006a\u0001!\t\u0005\u0016\u0005\b\u0003o\u0002A\u0011KA=\u0011%\t\u0019\tAA\u0001\n\u0003\t)\tC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u0011q\u0015\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003[\u0003\u0011\u0013!C\u0001\u0003SC\u0011\"a,\u0001#\u0003%\t!!-\t\u0013\u0005U\u0006!!A\u0005B\u0005]\u0006\"CAb\u0001\u0005\u0005I\u0011AAc\u0011%\ti\rAA\u0001\n\u0003\ty\rC\u0005\u0002V\u0002\t\t\u0011\"\u0011\u0002X\"I\u0011Q\u001d\u0001\u0002\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0003c\u0004\u0011\u0011!C!\u0003g<\u0011B!\b,\u0003\u0003E\tAa\b\u0007\u0011)Z\u0013\u0011!E\u0001\u0005CAaa\u001c\u0012\u0005\u0002\t=\u0002\"\u0003B\u0019E\u0005\u0005IQ\tB\u001a\u0011%\u0011)DIA\u0001\n\u0003\u00139\u0004C\u0005\u0003B\t\n\n\u0011\"\u0001\u00022\"I!1\t\u0012\u0002\u0002\u0013\u0005%Q\t\u0005\n\u0005'\u0012\u0013\u0013!C\u0001\u0003cC\u0011B!\u0016#\u0003\u0003%IAa\u0016\u0003\u0019QKW.Z:uC6\u0004\u0018\t\u001a3\u000b\u00051j\u0013aC3yaJ,7o]5p]NT!AL\u0018\u0002\u0011\r\fG/\u00197zgRT!\u0001M\u0019\u0002\u0007M\fHN\u0003\u00023g\u0005)1\u000f]1sW*\u0011A'N\u0001\u0007CB\f7\r[3\u000b\u0003Y\n1a\u001c:h\u0007\u0001\u0019r\u0001A\u001d>\u0001\u001eS\u0005\u000b\u0005\u0002;w5\t1&\u0003\u0002=W\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003uyJ!aP\u0016\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0011#\u000f\u0005i\u0012\u0015BA\",\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0012$\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u00111i\u000b\t\u0003u!K!!S\u0016\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA&O\u001b\u0005a%\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0017FK!A\u0015'\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\tUt\u0017\u000e^\u000b\u0002+B\u0011a+\u0018\b\u0003/n\u0003\"\u0001\u0017'\u000e\u0003eS!AW\u001c\u0002\rq\u0012xn\u001c;?\u0013\taF*\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001/M\u0003\u0015)h.\u001b;!\u0003!\tX/\u00198uSRLX#A2\u0011\u0005i\"\u0017BA3,\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\ncV\fg\u000e^5us\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b%\u0001\u0006uS6,'l\u001c8f\u0013\u0012,\u0012a\u001b\t\u0004\u00172,\u0016BA7M\u0005\u0019y\u0005\u000f^5p]\u0006YA/[7f5>tW-\u00133!\u0003\u0019a\u0014N\\5u}Q)\u0011O]:ukB\u0011!\b\u0001\u0005\u0006'&\u0001\r!\u0016\u0005\u0006C&\u0001\ra\u0019\u0005\u0006O&\u0001\ra\u0019\u0005\bS&\u0001\n\u00111\u0001l)\u0011\tx\u000f_=\t\u000bMS\u0001\u0019A+\t\u000b\u0005T\u0001\u0019A2\t\u000b\u001dT\u0001\u0019A2\u0002\t1,g\r^\u0001\u0006e&<\u0007\u000e^\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001@\u0011\u000b}\f9!!\u0004\u000f\t\u0005\u0005\u0011Q\u0001\b\u00041\u0006\r\u0011\"A'\n\u0005\rc\u0015\u0002BA\u0005\u0003\u0017\u00111aU3r\u0015\t\u0019E\n\u0005\u0003\u0002\u0010\u0005UQBAA\t\u0015\r\t\u0019bL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003/\t\tB\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u001eA!\u0011qBA\u0010\u0013\u0011\t\t#!\u0005\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAb^5uQRKW.\u001a.p]\u0016$2aRA\u0014\u0011\u0015Iw\u00021\u0001V\u00031QxN\\3JI&sWI^1m+\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\tQLW.\u001a\u0006\u0003\u0003o\tAA[1wC&!\u00111HA\u0019\u0005\u0019QvN\\3JI\"\u001a\u0001#a\u0010\u0011\u0007-\u000b\t%C\u0002\u0002D1\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\r\u0005%\u0013qJA*!\rY\u00151J\u0005\u0004\u0003\u001bb%aA!os\"9\u0011\u0011K\tA\u0002\u0005%\u0013!A9\t\u000f\u0005U\u0013\u00031\u0001\u0002J\u00051Q.[2s_N\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005m\u0013qMA9!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA1W\u000591m\u001c3fO\u0016t\u0017\u0002BA3\u0003?\u0012\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003S\u0012\u0002\u0019AA6\u0003\r\u0019G\u000f\u001f\t\u0005\u0003;\ni'\u0003\u0003\u0002p\u0005}#AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003g\u0012\u0002\u0019AA.\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u000bE\fY(a \t\r\u0005uT\u00031\u0001d\u0003\u001dqWm\u001e'fMRDa!!!\u0016\u0001\u0004\u0019\u0017\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\nc\u0006\u001d\u0015\u0011RAF\u0003\u001bCqa\u0015\f\u0011\u0002\u0003\u0007Q\u000bC\u0004b-A\u0005\t\u0019A2\t\u000f\u001d4\u0002\u0013!a\u0001G\"9\u0011N\u0006I\u0001\u0002\u0004Y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003'S3!VAKW\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0013Ut7\r[3dW\u0016$'bAAQ\u0019\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00161\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WS3aYAK\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00024*\u001a1.!&\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\u0011\ty,!\u000e\u0002\t1\fgnZ\u0005\u0004=\u0006u\u0016\u0001\u00049s_\u0012,8\r^!sSRLXCAAd!\rY\u0015\u0011Z\u0005\u0004\u0003\u0017d%aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA%\u0003#D\u0011\"a5\u001e\u0003\u0003\u0005\r!a2\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u000e\u0005\u0004\u0002\\\u0006\u0005\u0018\u0011J\u0007\u0003\u0003;T1!a8M\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\fiN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAu\u0003_\u00042aSAv\u0013\r\ti\u000f\u0014\u0002\b\u0005>|G.Z1o\u0011%\t\u0019nHA\u0001\u0002\u0004\tI%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003S\f)\u0010C\u0005\u0002T\u0002\n\t\u00111\u0001\u0002J!:\u0002!!?\u0002\u0000\n\u0005!Q\u0001B\u0004\u0005\u0017\u0011iA!\u0005\u0003\u0014\t]!\u0011\u0004\t\u0004u\u0005m\u0018bAA\u007fW\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017E\u0001B\u0002\u0003y{f)\u0016(D?\"*h.\u001b;-AE,\u0018M\u001c;jifd\u0003\u0005^5nKN$\u0018-\u001c9*A5\u0002\u0013\t\u001a3tAQDW\rI:qK\u000eLg-[3eA9,XNY3sA=4\u0007%\u001e8jiN\u0004Co\u001c\u0011uQ\u0016\u0004s-\u001b<f]\u0002\"\u0018.\\3ti\u0006l\u0007OL\u0001\nCJ<W/\\3oiN\f#A!\u0003\u0002\t[R\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I;oSR\u0004S\u0006\t;iSN\u0004\u0013N\u001c3jG\u0006$Xm\u001d\u0011uQ\u0016\u0004SO\\5ug\u0002zg\r\t3bi\u0016$\u0018.\\3!i\"\fG\u000fI=pk\u0002:\u0018M\u001c;!i>\u0004\u0013\r\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u001aV\u000f\u001d9peR,G\rI:ue&tw\r\t<bYV,7\u000fI8gA\u0001,h.\u001b;aA\u0005\u0014X\r\t\u0015dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wK&R$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011![\u0001\u0012\u0013,R!SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!EE+\u0016I\u0015+F%\n\u0002S\u0006I\u001a![>tG\u000f[:\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u001f:#\u0006J\t\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003EI,F\u000b.\u0013\u0003%\f\u00118A\u0011\f\u0017p\u001d\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#B3\nb\u0003E\t#B3>3\u0015,R!SE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E!{UK\u0015\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u0013:+F+\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012T\u000b\u000e{e\n\u0012\u0012\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012N\u00132c\u0015jU#D\u001f:#%E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%D%>\u001bViQ(O\t\nR\u0001\u0005\t\u0011!A\u0001R\u0003%];b]RLG/\u001f\u0011.AQD\u0017n\u001d\u0011jg\u0002\"\b.\u001a\u0011ok6\u0014WM\u001d\u0011pM\u0002*h.\u001b;tA=4\u0007\u0005^5nK\u0002\"\b.\u0019;!s>,\be^1oi\u0002\"x\u000eI1eI:R\u0001\u0005\t\u0011!A\u0001R\u0003\u0005^5nKN$\u0018-\u001c9![\u0001\"\b.[:!SN\u0004\u0013\r\t;j[\u0016\u001cH/Y7qA!:x\u0006I8sA]|s\u000e\t;j[\u0016TxN\\3*AQ|\u0007e\u001e5jG\"\u0004\u0013p\\;!o\u0006tG\u000f\t;pA\u0005$GM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003\u0010\u0005\u00199B\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015I\u001fV\u0013F\u0006\t\u001d-AQLW.Z:uC6\u0004xL\u001c;{OI\u0002$GM\u00171e5\n\u0014\u0007\t\u001a1uM\u0002$\b\r\u0019(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u001a3[A\u0012T&\r\u001a!aQR4\u0007\r\u001e1a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CSj\u0014(U\u00112\u0002\u0013\u0007\f\u0011uS6,7\u000f^1na~cGO_\u00143aI\u0012T\u0006M\u0019.gE\u0002\u0003\u0007\r\u001e1ai\u0002\u0004gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002$GM\u00171e5\u0012\u0004\b\t\u00191uA\u0002$\b\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QM+5i\u0014(EY\u0001j\u0013\u0007\r\u0017!I\u0006$Xm\n\u001a1eIj\u0003'M\u00171c\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a1eEj\u0013GM\u00174c\u0001\u00124GO\u001b:uU\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK-F\u0003Jc\u0003%\r\u0019-AQLW.Z:uC6\u0004xE\r\u00191a5\u0002\u0014'\f\u00192AA\n$\b\r\u001a;aMr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aE\u0002T\u0006M\u0019.aE\u0002\u0003'\r\u001e1ei\u00024GL\u00193gQ*dG\u0003\u0011!\u0003\u00159'o\\;qC\t\u0011)\"\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\tm\u0011!B\u001a/g9\u0002\u0014\u0001\u0004+j[\u0016\u001cH/Y7q\u0003\u0012$\u0007C\u0001\u001e#'\u0011\u0011#1\u0005)\u0011\u0013\t\u0015\"1F+dG.\fXB\u0001B\u0014\u0015\r\u0011I\u0003T\u0001\beVtG/[7f\u0013\u0011\u0011iCa\n\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003 \u0005AAo\\*ue&tw\r\u0006\u0002\u0002:\u0006)\u0011\r\u001d9msRI\u0011O!\u000f\u0003<\tu\"q\b\u0005\u0006'\u0016\u0002\r!\u0016\u0005\u0006C\u0016\u0002\ra\u0019\u0005\u0006O\u0016\u0002\ra\u0019\u0005\bS\u0016\u0002\n\u00111\u0001l\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u000f\u0012y\u0005\u0005\u0003LY\n%\u0003cB&\u0003LU\u001b7m[\u0005\u0004\u0005\u001bb%A\u0002+va2,G\u0007\u0003\u0005\u0003R\u001d\n\t\u00111\u0001r\u0003\rAH\u0005M\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00053\u0002B!a/\u0003\\%!!QLA_\u0005\u0019y%M[3di\u0002")
public class TimestampAdd
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
TimeZoneAwareExpression,
scala.Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression quantity;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampAdd$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampAdd timestampAdd) {
        return TimestampAdd$.MODULE$.unapply(timestampAdd);
    }

    public static Option<String> apply$default$4() {
        return TimestampAdd$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampAdd> tupled() {
        return TimestampAdd$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampAdd>>>> curried() {
        return TimestampAdd$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression quantity() {
        return this.quantity;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Expression left() {
        return this.quantity();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)AnyTimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return this.timestamp().dataType();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.timestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object q, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd(this.unit(), BoxesRunTime.unboxToInt((Object)q), BoxesRunTime.unboxToLong((Object)micros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(q, micros) -> new StringBuilder(23).append(dtu).append(".timestampAdd(\"").append(this.unit()).append("\", ").append((String)q).append(", ").append((String)micros).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "timestampadd";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((TraversableOnce)((SeqLike)this.children().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.sql(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new StringBuilder(2).append(this.prettyName()).append("(").append(childrenSQL).append(")").toString();
    }

    @Override
    public TimestampAdd withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampAdd copy(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        return new TimestampAdd(unit, quantity, timestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.quantity();
    }

    public Expression copy$default$3() {
        return this.timestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampAdd";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.quantity();
            }
            case 2: {
                return this.timestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampAdd;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampAdd)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampAdd timestampAdd = (TimestampAdd)x$1;
        String string = this.unit();
        String string2 = timestampAdd.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.quantity();
        Expression expression2 = timestampAdd.quantity();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = timestampAdd.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampAdd.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampAdd.canEqual(this)) return false;
        return true;
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.quantity = quantity;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }
}

