/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.bytebuddy;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CoreTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.OverridingClassFileLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.SafeCacheProvider;

public class ModelTypePool
extends TypePool.Default
implements EnhancerClassLocator {
    private final ConcurrentHashMap<String, TypePool.Resolution> resolutions = new ConcurrentHashMap();
    private final OverridingClassFileLocator locator;
    private final SafeCacheProvider poolCache;

    private ModelTypePool(SafeCacheProvider cacheProvider, OverridingClassFileLocator classFileLocator, CoreTypePool parent) {
        super((TypePool.CacheProvider)cacheProvider, (ClassFileLocator)classFileLocator, TypePool.Default.ReaderMode.FAST, (TypePool)parent);
        this.poolCache = cacheProvider;
        this.locator = classFileLocator;
    }

    public static EnhancerClassLocator buildModelTypePool(ClassLoader classLoader) {
        return ModelTypePool.buildModelTypePool(ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader));
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator) {
        return ModelTypePool.buildModelTypePool(classFileLocator, new CoreTypePool());
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool) {
        return ModelTypePool.buildModelTypePool(classFileLocator, coreTypePool, new SafeCacheProvider());
    }

    public static EnhancerClassLocator buildModelTypePool(ClassFileLocator classFileLocator, CoreTypePool coreTypePool, SafeCacheProvider cacheProvider) {
        Objects.requireNonNull(classFileLocator);
        Objects.requireNonNull(coreTypePool);
        Objects.requireNonNull(cacheProvider);
        return new ModelTypePool(cacheProvider, new OverridingClassFileLocator(classFileLocator), coreTypePool);
    }

    protected TypePool.Resolution doDescribe(String name) {
        TypePool.Resolution resolution = this.resolutions.get(name);
        if (resolution != null) {
            return resolution;
        }
        return this.resolutions.computeIfAbsent(name, x$0 -> super.doDescribe(x$0));
    }

    @Override
    public void registerClassNameAndBytes(String className, byte[] bytes) {
        this.resolutions.remove(className);
        this.poolCache.remove(className);
        this.locator.put(className, new ClassFileLocator.Resolution.Explicit(Objects.requireNonNull(bytes)));
    }

    @Override
    public void deregisterClassNameAndBytes(String className) {
        this.locator.remove(className);
    }

    @Override
    public ClassFileLocator asClassFileLocator() {
        return this.locator;
    }
}

