/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.RulePriorityPair;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class SetRulePrioritiesRequestMarshaller
implements Marshaller<Request<SetRulePrioritiesRequest>, SetRulePrioritiesRequest> {
    @Override
    public Request<SetRulePrioritiesRequest> marshall(SetRulePrioritiesRequest setRulePrioritiesRequest) {
        if (setRulePrioritiesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SetRulePrioritiesRequest> request = new DefaultRequest<SetRulePrioritiesRequest>(setRulePrioritiesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "SetRulePriorities");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setRulePrioritiesRequest.getRulePriorities() != null) {
            List<RulePriorityPair> rulePrioritiesList = setRulePrioritiesRequest.getRulePriorities();
            if (rulePrioritiesList.isEmpty()) {
                request.addParameter("RulePriorities", "");
            } else {
                int rulePrioritiesListIndex = 1;
                for (RulePriorityPair rulePrioritiesListValue : rulePrioritiesList) {
                    if (rulePrioritiesListValue != null) {
                        if (rulePrioritiesListValue.getRuleArn() != null) {
                            request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".RuleArn", StringUtils.fromString(rulePrioritiesListValue.getRuleArn()));
                        }
                        if (rulePrioritiesListValue.getPriority() != null) {
                            request.addParameter("RulePriorities.member." + rulePrioritiesListIndex + ".Priority", StringUtils.fromInteger(rulePrioritiesListValue.getPriority()));
                        }
                    }
                    ++rulePrioritiesListIndex;
                }
            }
        }
        return request;
    }
}

