/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.identitymanagement.model.TagInstanceProfileRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class TagInstanceProfileRequestMarshaller
implements Marshaller<Request<TagInstanceProfileRequest>, TagInstanceProfileRequest> {
    @Override
    public Request<TagInstanceProfileRequest> marshall(TagInstanceProfileRequest tagInstanceProfileRequest) {
        if (tagInstanceProfileRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TagInstanceProfileRequest> request = new DefaultRequest<TagInstanceProfileRequest>(tagInstanceProfileRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "TagInstanceProfile");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (tagInstanceProfileRequest.getInstanceProfileName() != null) {
            request.addParameter("InstanceProfileName", StringUtils.fromString(tagInstanceProfileRequest.getInstanceProfileName()));
        }
        if (!tagInstanceProfileRequest.getTags().isEmpty() || !((SdkInternalList)tagInstanceProfileRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)tagInstanceProfileRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue != null) {
                    if (tagsListValue.getKey() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                    }
                    if (tagsListValue.getValue() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                    }
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

