/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.AutoMLS3DataSource;

@SdkInternalApi
public class AutoMLS3DataSourceMarshaller {
    private static final MarshallingInfo<String> S3DATATYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3DataType").build();
    private static final MarshallingInfo<String> S3URI_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Uri").build();
    private static final AutoMLS3DataSourceMarshaller instance = new AutoMLS3DataSourceMarshaller();

    public static AutoMLS3DataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(AutoMLS3DataSource autoMLS3DataSource, ProtocolMarshaller protocolMarshaller) {
        if (autoMLS3DataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(autoMLS3DataSource.getS3DataType(), S3DATATYPE_BINDING);
            protocolMarshaller.marshall(autoMLS3DataSource.getS3Uri(), S3URI_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

