/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.cloud.aws.AWSCloudNetworkService;
import com.dataiku.fm.cloud.azure.AzureCloudNetworkService;
import com.dataiku.fm.cloud.gcp.GCPCloudNetworkService;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.simulator.CloudSimulatorService;
import java.util.Optional;
import javax.annotation.PostConstruct;

public class CloudNetworkService
implements CloudNetworkServiceInterface {
    private CloudNetworkServiceInterface adapter;

    @PostConstruct
    public void init() {
        this.adapter = CloudNetworkService.createAdapter();
        SpringUtils.getInstance().autowire((Object)this.adapter);
    }

    @Override
    public VirtualNetwork createManagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        return this.adapter.createManagedVirtualNetwork(tenantId, input, smartLogTail);
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetwork(VirtualNetwork vn, boolean deletePeering) {
        return this.adapter.deleteVirtualNetwork(vn, deletePeering);
    }

    @Override
    public VirtualNetwork createUnmanagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        return this.adapter.createUnmanagedVirtualNetwork(tenantId, input, smartLogTail);
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetworkSecurityGroups(VirtualNetwork vn) {
        return this.adapter.deleteVirtualNetworkSecurityGroups(vn);
    }

    @Override
    public VirtualNetworkMetadata getDefaultCreationValues(String tenantId) {
        return this.adapter.getDefaultCreationValues(tenantId);
    }

    @Override
    public boolean needsPeering(String tenantId, VirtualNetwork vn) {
        return this.adapter.needsPeering(tenantId, vn);
    }

    @Override
    public Optional<String> getPeeringId(String tenantId, VirtualNetwork vn) {
        return this.adapter.getPeeringId(tenantId, vn);
    }

    private static CloudNetworkServiceInterface createAdapter() {
        if (FMApp.ENABLE_CLOUD_SIMULATOR) {
            return ((CloudSimulatorService)SpringUtils.getBean(CloudSimulatorService.class)).createNetworkService();
        }
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                return new AWSCloudNetworkService();
            }
            case AZURE: {
                return new AzureCloudNetworkService();
            }
            case GCP: {
                return new GCPCloudNetworkService();
            }
        }
        throw new IllegalStateException("Invalid cloud type: " + String.valueOf((Object)settings.cloud));
    }

    @Override
    public void validateSettings(VirtualNetwork vn, VirtualNetworkSettingsDTO dto) {
        this.adapter.validateSettings(vn, dto);
    }
}

