/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.VirtualNetwork;
import java.util.Map;
import java.util.Optional;

public interface DNSservice {
    public Map<ZoneType, PhysicalDNSRecord> addDNSRecords(VirtualNetwork var1, String var2, String var3, String var4, RecordType var5, Map<String, String> var6);

    public void removeDNSRecords(VirtualNetwork var1, String var2, RecordType var3, boolean var4);

    public Map<ZoneType, String> getHostnames(VirtualNetwork var1, String var2);

    public String getPublicDNSZoneDomain(VirtualNetwork var1);

    default public boolean hasDNSManaged(VirtualNetwork virtualNetwork) {
        return virtualNetwork.getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE;
    }

    default public String computeNodeMappingHostname(LogicalLoadBalancer lb, String hostname) {
        Map<ZoneType, String> hostnames = this.getHostnames(lb.getVirtualNetwork(), hostname);
        if (lb.getPublicIpMode() == LoadBalancerPublicIPMode.NO_PUBLIC_IP) {
            return hostnames.getOrDefault((Object)ZoneType.PRIVATE, hostname);
        }
        return hostnames.getOrDefault((Object)ZoneType.PUBLIC, hostname);
    }

    public String getPrivateDNSZoneDomain(VirtualNetwork var1);

    public Optional<String> getDNSRecord(VirtualNetwork var1, String var2, ZoneType var3, RecordType var4, boolean var5);

    public void removeDNSRecord(VirtualNetwork var1, PhysicalDNSRecord var2);

    public void checkIfZoneExist(VirtualNetwork var1, String var2);

    public static enum ZoneType {
        PRIVATE,
        PUBLIC;

    }

    public static enum RecordType {
        A,
        CNAME;

    }
}

