/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.Credentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.aws.sdk.AcmClientWrapper;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.settings.AWSSettings;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.net.URI;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class AWSClientService {
    @Autowired
    private CloudAccountsService accountService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private AWSClientBrokerService awsClientBrokerService;
    @Autowired
    FMApp fmApp;

    public Ec2Client getEC2Client(CloudAccount account, String region) {
        Ec2ClientBuilder builder = (Ec2ClientBuilder)((Ec2ClientBuilder)this.awsClientBrokerService.createEc2ClientBuilder().region(Region.of((String)region))).credentialsProvider(this.getCustomerCredentialsProvider(account));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
        return (Ec2Client)builder.build();
    }

    public Route53Client getRoute53Client(CloudAccount account, String region) {
        Route53ClientBuilder builder = (Route53ClientBuilder)((Route53ClientBuilder)this.awsClientBrokerService.createRoute53ClientBuilder().region(Region.of((String)region))).credentialsProvider(this.getCustomerCredentialsProvider(account));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
        return (Route53Client)builder.build();
    }

    public KmsClient getKMSClient(CloudAccount account) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        KmsClientBuilder builder = (KmsClientBuilder)((KmsClientBuilder)this.awsClientBrokerService.createKmsClientBuilder().region(Region.of((String)settings.awsSettings.regionId))).credentialsProvider(this.getCustomerCredentialsProvider(account));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
        return (KmsClient)builder.build();
    }

    public ElasticLoadBalancingV2Client getElasticLoadBalancingClient(CloudAccount account, String region) {
        ElasticLoadBalancingV2ClientBuilder builder = (ElasticLoadBalancingV2ClientBuilder)((ElasticLoadBalancingV2ClientBuilder)this.awsClientBrokerService.createElasticLoadBalancingV2ClientBuilder().region(Region.of((String)region))).credentialsProvider(this.getCustomerCredentialsProvider(account));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
        return (ElasticLoadBalancingV2Client)builder.build();
    }

    public AcmClientWrapper getACMClient(CloudAccount account, String region) {
        AcmClientBuilder builder = (AcmClientBuilder)((AcmClientBuilder)this.awsClientBrokerService.createAcmClientBuilder().region(Region.of((String)region))).credentialsProvider(this.getCustomerCredentialsProvider(account));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
        return new AcmClientWrapper((AcmClient)builder.build());
    }

    public String getTenantAccountId(CloudAccount account) {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)this.initializeStsClientBuilder().credentialsProvider(this.getCustomerCredentialsProvider(account));
        try (StsClient stsClient = (StsClient)stsClientBuilder.build();){
            String string = stsClient.getCallerIdentity().account();
            return string;
        }
    }

    private AwsCredentialsProvider getCustomerCredentialsProvider(CloudAccount account) {
        return this.getAWSCredentials(account).map(credentials -> AwsSessionCredentials.builder().accessKeyId(credentials.accessKeyId()).secretAccessKey(credentials.secretAccessKey()).sessionToken(credentials.sessionToken()).build()).map(StaticCredentialsProvider::create).orElse((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build());
    }

    private Optional<Credentials> getAWSCredentials(CloudAccount account) {
        Optional<Credentials> optional;
        CloudCryptoService cryptoService = (CloudCryptoService)SpringUtils.getBean(CloudCryptoService.class);
        switch (account.getAwsAuthenticationMode()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT_INSTANCE_CREDENTIALS: {
                Optional<Credentials> optional2;
                optional = optional2 = Optional.empty();
                break;
            }
            case IAM_ROLE: {
                Optional<String> decryptedExternalId = Optional.ofNullable(account.getAwsIAMRoleExternalId()).filter(externalId -> !externalId.isBlank()).map(externalId -> account.isEncrypted() ? cryptoService.decrypt(account.getTenant(), account.getAwsIAMRoleExternalId()) : externalId);
                try (StsClient stsClient = (StsClient)this.initializeStsClientBuilder().build();){
                    Optional<Credentials> optional3 = Optional.of(stsClient.assumeRole((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(account.getAwsIAMRoleARN()).roleSessionName("fm-access").externalId((String)decryptedExternalId.orElse(null)).build()).credentials());
                    optional = optional3;
                    break;
                }
            }
            case KEYPAIR: {
                String accessKey = account.isEncrypted() ? cryptoService.decrypt(account.getTenant(), account.getAwsSecretAccessKey()) : account.getAwsSecretAccessKey();
                StsClientBuilder stsClientBuilder = (StsClientBuilder)this.initializeStsClientBuilder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.builder().accessKeyId(account.getAwsAccessKeyId()).secretAccessKey(accessKey).build()));
                try (StsClient stsClient = (StsClient)stsClientBuilder.build();){
                    Optional<Credentials> optional4 = Optional.of(stsClient.getSessionToken((GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(3600)).build()).credentials());
                    optional = optional4;
                    break;
                }
            }
        }
        return optional;
    }

    private StsClientBuilder initializeStsClientBuilder() {
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)this.awsClientBrokerService.createStsClientBuilder().region(Region.of((String)fmSettings.awsSettings.regionId))).endpointOverride(this.getSTSEndpointURI(fmSettings.awsSettings));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)stsClientBuilder);
        return stsClientBuilder;
    }

    private void conditionallyConfigureProxy(AwsSyncClientBuilder<?, ?> clientBuilder) {
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        if (this.fmApp.isCloudProxyEnabledWrapper(fmSettings)) {
            ProxyUtils.addHttpClientBuilderAndApplyProxySettings((ProxySettings)fmSettings.proxySettings, clientBuilder, (boolean)this.fmApp.isSSLVerificationDisabled());
        }
    }

    private URI getSTSEndpointURI(AWSSettings awsSettings) {
        return URI.create((String)(awsSettings.stsServiceEndpoint == null ? "https://sts." + awsSettings.regionId + ".amazonaws.com" : awsSettings.stsServiceEndpoint));
    }
}

