/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.azure;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachine;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.compute.models.VirtualMachines;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.dns.models.ARecordSet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGateway;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayFirewallMode;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayListener;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayOperationalState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySkuName;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewaySslCertificate;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ApplicationGatewayTier;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedServiceIdentity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ManagedServiceIdentityUserAssignedIdentities;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NetworkInterface;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.NicIpConfiguration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.PublicIpAddress;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.network.models.ResourceIdentityType;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasName;
import com.dataiku.fm.cloud.CloudLoadBalancerServiceInterface;
import com.dataiku.fm.cloud.DNSservice;
import com.dataiku.fm.cloud.azure.AzureClientService;
import com.dataiku.fm.cloud.azure.AzureDNSService;
import com.dataiku.fm.cloud.azure.AzureUtils;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;

public class AzureCloudLoadBalancerService
implements CloudLoadBalancerServiceInterface {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.azure.loadbalancer");
    public static final String LB_RESOURCE_NAME_PREFIX = "FM-managed.for-hostname.";
    @Autowired
    private AzureClientService clientService;
    @Autowired
    private AzureDNSService azureDNSService;
    @Autowired
    private DatabaseAccessService dbService;

    @Override
    public PhysicalLoadBalancer createPhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        if (lb.getLoadBalancerNodeMapping().size() == 0) {
            throw new IllegalStateException("Load balancer should have at least one node mapping");
        }
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Creating load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            PhysicalLoadBalancer physicalLoadBalancer = new PhysicalLoadBalancer();
            String physicalLoadBalancerId = "plb-" + SecretKeyGenerator.generate((int)12);
            physicalLoadBalancer.setId(physicalLoadBalancerId);
            physicalLoadBalancer.setLogicalLoadBalancer(lb);
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement preparingLBStep = FutureProgress.pushAutoCloseableState((String)"Preparing Azure load balancer", (double)1.0);){
                smartLogTail.appendLine("Initializing Azure gateway setup.", logger, Priority.INFO);
                physicalLoadBalancer.setAzureApplicationGatewayId(this.buildApplicationGatewayResourceId(lb.getVirtualNetwork().getAzureRgName(), lb.getVirtualNetwork().getCloudAccount().getAzureSubscription(), physicalLoadBalancerId));
                lb.setCurrentPhysicalLoadBalancer(physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)physicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
            }
            try {
                ApplicationGateway applicationGateway;
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createLBStep = FutureProgress.pushAutoCloseableState((String)"Creating Azure load balancer", (double)1.0);){
                    smartLogTail.appendLine("Starting the creation of Azure gateway...", logger, Priority.INFO);
                    applicationGateway = new AzureGatewayBuilder(lb, physicalLoadBalancer).build();
                    smartLogTail.replaceLastLine("Azure gateway successfully created with ID: '" + applicationGateway.id() + "'", logger, Priority.INFO);
                }
                PublicIpAddress publicIPAddress = applicationGateway.defaultPublicFrontend().getPublicIpAddress();
                try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dssRecordsStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)lb.getLoadBalancerNodeMapping().size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                    Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = lb.getLoadBalancerActiveNodeMappingsPerHostName();
                    for (String hostname : nodeMappingsPerHostName.keySet()) {
                        FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dssRecordStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)1.0);
                        try {
                            smartLogTail.appendLine("Setting up DNS record for '" + hostname + "'...", logger, Priority.INFO);
                            Map<DNSservice.ZoneType, PhysicalDNSRecord> zoneTypePhysicalDNSRecordMap = this.azureDNSService.addDNSRecords(lb.getVirtualNetwork(), hostname, publicIPAddress.ipAddress(), null, DNSservice.RecordType.A, AzureUtils.getTagsWithName(LB_RESOURCE_NAME_PREFIX + hostname, lb.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())));
                            smartLogTail.replaceLastLine("DNS record for '" + hostname + "' has been successfully created", logger, Priority.INFO);
                            for (LoadBalancerNodeMapping nodeMapping : nodeMappingsPerHostName.get(hostname)) {
                                if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                                    nodeMapping.setPrivatePhysicalDNSRecord(zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PRIVATE));
                                }
                                if (!zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PUBLIC)) continue;
                                nodeMapping.setPublicPhysicalDNSRecord(zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PUBLIC));
                            }
                        }
                        finally {
                            if (dssRecordStep == null) continue;
                            dssRecordStep.close();
                        }
                    }
                }
                PhysicalLoadBalancer physicalLoadBalancer2 = physicalLoadBalancer;
                return physicalLoadBalancer2;
            }
            catch (Throwable e) {
                logger.error((Object)"An error occurred during gateway creation: ", e);
                logger.info((Object)"Cleaning up gateway components");
                smartLogTail.appendLine("Encountered an error during gateway creation, initiating cleanup...");
                this.deletePhysicalLoadBalancer(lb, rwt, smartLogTail);
                lb.setCurrentPhysicalLoadBalancer(null);
                rwt.getThreadEM().persist((Object)lb);
                rwt.getThreadEM().remove((Object)physicalLoadBalancer);
                rwt.commit();
                throw e;
            }
        }
    }

    @Override
    public boolean deletePhysicalLoadBalancer(LogicalLoadBalancer lb, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        PhysicalLoadBalancer plb = lb.getCurrentPhysicalLoadBalancer();
        try (FutureProgress.AutocloseableFutureProgressState globalState = FutureProgress.pushAutoCloseableState((String)"Deleting Azure load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            CloudAccount cloudAccount;
            if (plb == null) {
                boolean bl = true;
                return bl;
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement nodeMappingsStep = FutureProgress.pushAutoCloseableState((String)"Deleting node mappings", (double)lb.getLoadBalancerNodeMapping().size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = lb.getLoadBalancerActiveNodeMappingsPerHostName();
                for (String hostname : nodeMappingsPerHostName.keySet()) {
                    FutureProgress.AutocloseableFutureProgressStateWithAutoincrement nodeMappingStep = FutureProgress.pushAutoCloseableState((String)("Deleting DNS records for node mapping '" + hostname + "'"), (double)1.0);
                    try {
                        Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerHostName.get(hostname);
                        LoadBalancerNodeMapping anyNodeMapping = nodeMappings.iterator().next();
                        smartLogTail.appendLine("Removing public DNS record for '" + hostname + "'...", logger, Priority.INFO);
                        this.azureDNSService.removeDNSRecord(lb.getVirtualNetwork(), anyNodeMapping.getPublicPhysicalDNSRecord());
                        smartLogTail.replaceLastLine("Public DNS record for '" + hostname + "' successfully deleted", logger, Priority.INFO);
                        smartLogTail.appendLine("Removing private DNS record for '" + hostname + "'...", logger, Priority.INFO);
                        this.azureDNSService.removeDNSRecord(lb.getVirtualNetwork(), anyNodeMapping.getPrivatePhysicalDNSRecord());
                        smartLogTail.replaceLastLine("Private DNS record for '" + hostname + "' successfully deleted", logger, Priority.INFO);
                        for (LoadBalancerNodeMapping nodeMapping : nodeMappings) {
                            if (nodeMapping.getPublicPhysicalDNSRecord() != null) {
                                this.dbService.getThreadEM().remove((Object)nodeMapping.getPublicPhysicalDNSRecord());
                            }
                            if (nodeMapping.getPrivatePhysicalDNSRecord() != null) {
                                this.dbService.getThreadEM().remove((Object)nodeMapping.getPrivatePhysicalDNSRecord());
                            }
                            nodeMapping.setPublicPhysicalDNSRecord(null);
                            nodeMapping.setPrivatePhysicalDNSRecord(null);
                        }
                    }
                    finally {
                        if (nodeMappingStep == null) continue;
                        nodeMappingStep.close();
                    }
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement lbStep = FutureProgress.pushAutoCloseableState((String)"Deleting Azure load balancer", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                if (plb.getAzureApplicationGatewayId() != null) {
                    smartLogTail.appendLine("Initiating deletion of load balancer with ID '" + plb.getAzureApplicationGatewayId() + "'...", logger, Priority.INFO);
                    cloudAccount = lb.getVirtualNetwork().getCloudAccount();
                    this.clientService.getAzureClient(cloudAccount).applicationGateways().deleteById(plb.getAzureApplicationGatewayId());
                    smartLogTail.replaceLastLine("Load balancer with ID '" + plb.getAzureApplicationGatewayId() + "' has been deleted", logger, Priority.INFO);
                    plb.setAzureApplicationGatewayId(null);
                } else {
                    smartLogTail.appendLine("No Azure load balancer found to delete", logger, Priority.INFO);
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement externalIPStep = FutureProgress.pushAutoCloseableState((String)"Deleting managed external IP", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                if (plb.getAzureFMManagedExternalIpId() != null) {
                    smartLogTail.appendLine("Removing public IP address with ID '" + plb.getAzureFMManagedExternalIpId() + "'...", logger, Priority.INFO);
                    cloudAccount = lb.getVirtualNetwork().getCloudAccount();
                    this.clientService.getAzureClient(cloudAccount).publicIpAddresses().deleteById(plb.getAzureFMManagedExternalIpId());
                    smartLogTail.replaceLastLine("Public IP address with ID '" + plb.getAzureFMManagedExternalIpId() + "' successfully deleted", logger, Priority.INFO);
                    plb.setAzureExternalIpId(null);
                } else {
                    smartLogTail.appendLine("No managed external IP found to delete", logger, Priority.INFO);
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void updatePhysicalLoadBalancer(LogicalLoadBalancer loadBalancer, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail, @Nonnull PhysicalLoadBalancer physicalLoadBalancer) throws InterruptedException {
        CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
        ApplicationGateway applicationGateway = (ApplicationGateway)this.clientService.getAzureClient(cloudAccount).applicationGateways().getById(physicalLoadBalancer.getAzureApplicationGatewayId());
        if (applicationGateway == null) {
            throw new IllegalStateException("Application gateway not provisioned. Please provision or reprovision instead.");
        }
        ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils = new ApplicationGatewayUpdateUtils((ApplicationGateway.Update)applicationGateway.update());
        try (FutureProgress.AutocloseableFutureProgressState global = FutureProgress.pushAutoCloseableState((String)"Updating load balancer", (double)3.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement step = FutureProgress.pushAutoCloseableState((String)"Preparing load balancer update", (double)1.0);){
                this.updateSSL(loadBalancer, physicalLoadBalancer, applicationGateway, applicationGatewayUpdateUtils, smartLogTail);
                Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
                this.deleteOrphanResources(applicationGateway, nodeMappingsPerHostName, applicationGatewayUpdateUtils, smartLogTail);
                for (String hostname : nodeMappingsPerHostName.keySet()) {
                    this.updateListeners(loadBalancer, physicalLoadBalancer, smartLogTail, hostname, applicationGateway, applicationGatewayUpdateUtils);
                    this.updateBackendConfigs(loadBalancer, smartLogTail, hostname, applicationGateway, applicationGatewayUpdateUtils);
                    this.updateRequestRoutingRules(smartLogTail, hostname, applicationGateway, applicationGatewayUpdateUtils);
                    this.updateBackends(loadBalancer, smartLogTail, hostname, applicationGateway, applicationGatewayUpdateUtils);
                }
            }
            step = FutureProgress.pushAutoCloseableState((String)"Updating Azure load balancer", (double)1.0);
            try {
                if (applicationGatewayUpdateUtils.needUpdate) {
                    smartLogTail.appendLine("Updating Azure load balancer, this step may take several minutes", logger, Priority.INFO);
                    applicationGatewayUpdateUtils.gateway().apply();
                }
            }
            finally {
                if (step != null) {
                    step.close();
                }
            }
            this.updateDnsRecords(applicationGateway, loadBalancer, rwt, smartLogTail);
        }
    }

    private void deleteOrphanResources(ApplicationGateway applicationGateway, Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail) {
        Predicate<HasName> isOrphan = lbEntity -> lbEntity.name().startsWith(LB_RESOURCE_NAME_PREFIX) && !nodeMappingsPerHostName.containsKey(lbEntity.name().substring(LB_RESOURCE_NAME_PREFIX.length()));
        applicationGateway.backends().values().stream().filter(isOrphan).map(HasName::name).collect(Collectors.toSet()).forEach(name -> {
            smartLogTail.appendLine("Deleting orphan backend '" + name + "'", logger, Priority.INFO);
            applicationGatewayUpdateUtils.gateway().withoutBackend(name);
        });
        applicationGateway.requestRoutingRules().values().stream().filter(isOrphan).map(HasName::name).collect(Collectors.toSet()).forEach(name -> {
            smartLogTail.appendLine("Deleting orphan request routing rule '" + name + "'", logger, Priority.INFO);
            applicationGatewayUpdateUtils.gateway().withoutRequestRoutingRule(name);
        });
        applicationGateway.backendHttpConfigurations().values().stream().filter(isOrphan).map(HasName::name).collect(Collectors.toSet()).forEach(name -> {
            smartLogTail.appendLine("Deleting orphan HTTP configuration '" + name + "'", logger, Priority.INFO);
            applicationGatewayUpdateUtils.gateway().withoutBackendHttpConfiguration(name);
        });
        applicationGateway.listeners().values().stream().filter(isOrphan).map(HasName::name).collect(Collectors.toSet()).forEach(name -> {
            smartLogTail.appendLine("Deleting orphan listener '" + name + "'", logger, Priority.INFO);
            applicationGatewayUpdateUtils.gateway().withoutListener(name);
        });
    }

    private void updateRequestRoutingRules(DKUtils.SmartLogTailBuilder smartLogTail, String hostname, ApplicationGateway applicationGateway, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils) {
        if (!applicationGateway.requestRoutingRules().containsKey(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname))) {
            smartLogTail.appendLine("Setting up for rule creation: '" + AzureCloudLoadBalancerService.getResourceIdForHostname(hostname) + "'", logger, Priority.INFO);
            applicationGatewayUpdateUtils.gateway().defineRequestRoutingRule(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).fromListener(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).toBackendHttpConfiguration(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).toBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).attach();
        } else {
            smartLogTail.appendLine("No updates required for the rule: configurations are in the listener, backend, or backend settings", logger, Priority.INFO);
        }
    }

    private static String getResourceIdForHostname(String hostname) {
        return LB_RESOURCE_NAME_PREFIX + hostname;
    }

    private void updateBackends(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, ApplicationGateway applicationGateway, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils) {
        Set<LoadBalancerNodeMapping> nodeMappings = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName().get(hostname);
        Set<PhysicalInstance> physicalInstances = nodeMappings.stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(nodeMapping -> nodeMapping.getLogicalInstance().getCurrentPhysicalInstance()).collect(Collectors.toSet());
        ApplicationGatewayBackend currentBackend = (ApplicationGatewayBackend)applicationGateway.backends().get(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname));
        if (currentBackend == null) {
            if (physicalInstances.isEmpty()) {
                this.createEmptyBackend(applicationGatewayUpdateUtils, smartLogTail, hostname);
            } else {
                this.createBackend(loadBalancer, applicationGatewayUpdateUtils, smartLogTail, hostname, physicalInstances);
            }
        } else if (physicalInstances.isEmpty()) {
            this.emptyExistingBackend(applicationGatewayUpdateUtils, smartLogTail, hostname, currentBackend);
        } else {
            this.synchronizeBackend(loadBalancer, applicationGatewayUpdateUtils, smartLogTail, hostname, physicalInstances, currentBackend);
        }
    }

    private void updateBackendConfigs(LogicalLoadBalancer loadBalancer, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, ApplicationGateway applicationGateway, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils) {
        int backendPort;
        String backendConfigId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
        int n = backendPort = loadBalancer.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? 80 : 443;
        if (!applicationGateway.backendHttpConfigurations().containsKey(backendConfigId)) {
            smartLogTail.appendLine("Setting up for backend configuration creation: '" + backendConfigId + "'", logger, Priority.INFO);
            if (loadBalancer.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE) {
                ((ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.WithAttach)applicationGatewayUpdateUtils.gateway().defineBackendHttpConfiguration(backendConfigId).withPort(backendPort)).withCookieBasedAffinity().attach();
            } else {
                ((ApplicationGatewayBackendHttpConfiguration.UpdateDefinitionStages.WithAttach)applicationGatewayUpdateUtils.gateway().defineBackendHttpConfiguration(backendConfigId).withPort(backendPort)).withCookieBasedAffinity().withHttps().attach();
            }
        } else if (((ApplicationGatewayBackendHttpConfiguration)applicationGateway.backendHttpConfigurations().get(backendConfigId)).port() != backendPort) {
            smartLogTail.appendLine("Setting up for backend configuration update: '" + backendConfigId + "'", logger, Priority.INFO);
            if (loadBalancer.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE) {
                ((ApplicationGatewayBackendHttpConfiguration.Update)applicationGatewayUpdateUtils.gateway().updateBackendHttpConfiguration(backendConfigId).withPort(backendPort)).withCookieBasedAffinity().parent();
            } else {
                ((ApplicationGatewayBackendHttpConfiguration.Update)applicationGatewayUpdateUtils.gateway().updateBackendHttpConfiguration(backendConfigId).withPort(backendPort)).withCookieBasedAffinity().withHttps().parent();
            }
        }
    }

    private void updateListeners(LogicalLoadBalancer loadBalancer, PhysicalLoadBalancer physicalLoadBalancer, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, ApplicationGateway applicationGateway, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils) {
        String listenerId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
        int expectedPort = loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE ? 80 : 443;
        String nodeMappingHostname = this.azureDNSService.computeNodeMappingHostname(loadBalancer, hostname);
        if (!applicationGateway.listeners().containsKey(listenerId)) {
            smartLogTail.appendLine("Setting up for listener creation: '" + listenerId + "'", logger, Priority.INFO);
            if (loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE) {
                ((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)applicationGatewayUpdateUtils.gateway().defineListener(listenerId).withPublicFrontend().withFrontendPort(expectedPort).withHttp().withHostname(nodeMappingHostname)).attach();
            } else {
                ((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)((ApplicationGatewayListener.UpdateDefinitionStages.WithAttach)applicationGatewayUpdateUtils.gateway().defineListener(listenerId).withPublicFrontend().withFrontendPort(expectedPort).withHttps().withSslCertificate(this.getCertificateConfigId(physicalLoadBalancer.getId()))).withHostname(nodeMappingHostname)).attach();
            }
        } else {
            ApplicationGatewayListener applicationGatewayListener = (ApplicationGatewayListener)applicationGateway.listeners().get(listenerId);
            if (!applicationGatewayListener.hostname().equals(nodeMappingHostname) || applicationGatewayListener.frontendPortNumber() != expectedPort) {
                smartLogTail.appendLine("Setting up for listener update: '" + listenerId + "'", logger, Priority.INFO);
                if (loadBalancer.getCertificateMode() == CertificateMode.NO_CERTIFICATE) {
                    ((ApplicationGatewayListener.Update)applicationGatewayUpdateUtils.gateway().updateListener(listenerId).withPublicFrontend().withFrontendPort(expectedPort).withHttp().withHostname(nodeMappingHostname)).parent();
                } else {
                    ((ApplicationGatewayListener.Update)((ApplicationGatewayListener.Update)applicationGatewayUpdateUtils.gateway().updateListener(listenerId).withPublicFrontend().withFrontendPort(expectedPort).withHttps().withSslCertificate(this.getCertificateConfigId(physicalLoadBalancer.getId()))).withHostname(nodeMappingHostname)).parent();
                }
            }
        }
    }

    @Override
    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        LoadBalancerPhysicalStatus loadBalancerPhysicalStatus = new LoadBalancerPhysicalStatus();
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
        if (currentPhysicalLoadBalancer == null || currentPhysicalLoadBalancer.getAzureApplicationGatewayId() == null) {
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_NOT_PROVISIONED, "");
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
        } else {
            CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
            ApplicationGateway applicationGateway = (ApplicationGateway)this.clientService.getAzureClient(cloudAccount).applicationGateways().getById(currentPhysicalLoadBalancer.getAzureApplicationGatewayId());
            if (applicationGateway == null) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_NOT_PROVISIONED, "Couldn't find application gateway with id '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "'");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
            } else {
                loadBalancerPhysicalStatus.loadBalancerLink = this.getLoadBalancerLink(loadBalancer);
                ApplicationGatewayOperationalState applicationGatewayOperationalState = applicationGateway.operationalState();
                if (ApplicationGatewayOperationalState.STOPPED.equals((Object)applicationGatewayOperationalState) || ApplicationGatewayOperationalState.STOPPING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_UNAVAILABLE, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' is stopped.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                    return loadBalancerPhysicalStatus;
                }
                if (ApplicationGatewayOperationalState.STARTING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_PROVISIONING, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' is starting.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONING);
                    return loadBalancerPhysicalStatus;
                }
                if (ApplicationGatewayOperationalState.RUNNING.equals((Object)applicationGatewayOperationalState)) {
                    loadBalancerPhysicalStatus.infoMessages.withInfo((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_PROVISIONED, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' is running.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.PROVISIONED);
                } else {
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_UNAVAILABLE, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' status unknown: '" + String.valueOf(applicationGatewayOperationalState) + "'");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
                }
                if (!Objects.equals(applicationGateway.networkId(), loadBalancer.getVirtualNetwork().getAzureVnId())) {
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_WRONG_NETWORK, "Load balancer is in virtual network '" + applicationGateway.networkId() + "' instead of expected virtual network '" + loadBalancer.getVirtualNetwork().getAzureVnId() + "'");
                }
                this.getLoadBalancerPublicIPStatus(loadBalancer, loadBalancerPhysicalStatus);
                this.getLoadBalancerListenersStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
                this.getLoadBalancerBackendConfigStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
                this.getLoadBalancerRequestRoutingRulesStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
                this.getLoadBalancerBackendsStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
                this.getLoadBalancerDNSStatus(loadBalancer, loadBalancerPhysicalStatus, applicationGateway);
            }
        }
        List inactiveNodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE).collect(Collectors.toList());
        if (inactiveNodes.size() > 0) {
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING, "The following node mappings are inactive but still associated to cloud resources: " + inactiveNodes.stream().map(n -> n.getHostname() + "->" + n.getLogicalInstance().getLabel()).collect(Collectors.joining(",")));
        }
        return loadBalancerPhysicalStatus;
    }

    @Override
    public void onInstancePhysicalStateChange(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer currentLoadBalancer, LogicalInstance logicalInstance) {
        if (currentLoadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return;
        }
        logger.info((Object)("Instance '" + logicalInstance.getLabel() + "' physical state has changed, updating LB."));
        String gatewayId = currentLoadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId();
        CloudAccount cloudAccount = currentLoadBalancer.getVirtualNetwork().getCloudAccount();
        ApplicationGateway applicationGateway = (ApplicationGateway)this.clientService.getAzureClient(cloudAccount).applicationGateways().getById(gatewayId);
        if (applicationGateway == null) {
            throw new IllegalStateException("Couldn't find gateway '" + gatewayId + "'");
        }
        LoadBalancerNodeMapping nodeMapping = currentLoadBalancer.getLoadBalancerNodeMapping().stream().filter(e -> e.getLogicalInstance().getId().equals(logicalInstance.getId())).findAny().orElseThrow(() -> new IllegalArgumentException("Load balancer '" + currentLoadBalancer.getName() + "' doesn't have a node mapping for instance '" + logicalInstance.getLabel() + "'"));
        ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils = new ApplicationGatewayUpdateUtils((ApplicationGateway.Update)applicationGateway.update());
        this.updateBackends(currentLoadBalancer, new DKUtils.SmartLogTailBuilder(), nodeMapping.getHostname(), applicationGateway, applicationGatewayUpdateUtils);
        if (applicationGatewayUpdateUtils.needUpdate) {
            applicationGatewayUpdateUtils.gateway().apply();
        }
    }

    @Override
    public boolean isLoadBalancerNodeMappingProvisioned(LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return false;
        }
        return ((ApplicationGateway)this.clientService.getAzureClient(loadBalancer.getVirtualNetwork().getCloudAccount()).applicationGateways().getById(loadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId())).backends().get(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getHostname())) != null;
    }

    @Override
    public void onInstanceDeleteEvent(DatabaseAccessService.ReadWriteTransaction rwt, LogicalLoadBalancer loadBalancer, LoadBalancerNodeMapping nodeMapping, LogicalInstance logicalInstance) {
        Set nodeMappingsForHostname;
        PhysicalLoadBalancer physicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        if (physicalLoadBalancer != null && (nodeMappingsForHostname = (Set)loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName().getOrDefault(nodeMapping.getHostname(), new HashSet())).isEmpty()) {
            logger.infoV("Instance '%s' was deleted, removing it from load balancer", new Object[]{logicalInstance.getId()});
            ((ApplicationGateway.Update)((ApplicationGateway)this.clientService.getAzureClient(loadBalancer.getVirtualNetwork().getCloudAccount()).applicationGateways().getById(physicalLoadBalancer.getAzureApplicationGatewayId())).update()).withoutBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getHostname())).withoutRequestRoutingRule(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getHostname())).withoutListener(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getHostname())).withoutBackendHttpConfiguration(AzureCloudLoadBalancerService.getResourceIdForHostname(nodeMapping.getHostname())).apply();
        }
    }

    @Override
    public String getLoadBalancerLink(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return "";
        }
        ApplicationGateway applicationGateway = (ApplicationGateway)this.clientService.getAzureClient(loadBalancer.getVirtualNetwork().getCloudAccount()).applicationGateways().getById(loadBalancer.getCurrentPhysicalLoadBalancer().getAzureApplicationGatewayId());
        return "https://app.azure.com/" + loadBalancer.getVirtualNetwork().getCloudAccount().getAzureTenantId() + "/subscriptions/" + loadBalancer.getVirtualNetwork().getCloudAccount().getAzureSubscription() + "/resourceGroups/" + loadBalancer.getVirtualNetwork().getAzureRgName() + "/providers/Microsoft.Network/applicationGateways/" + applicationGateway.name();
    }

    private void getLoadBalancerPublicIPStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus) {
        PhysicalLoadBalancer currentPhysicalLoadBalancer = loadBalancer.getCurrentPhysicalLoadBalancer();
        if (loadBalancer.getPublicIpMode() == LoadBalancerPublicIPMode.DYNAMIC_PUBLIC_IP) {
            if (currentPhysicalLoadBalancer.getAzureFMManagedExternalIpId() == null) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' has no reference of a public IP.");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
            } else {
                CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
                PublicIpAddress externalIp = (PublicIpAddress)this.clientService.getAzureClient(cloudAccount).publicIpAddresses().getById(currentPhysicalLoadBalancer.getAzureFMManagedExternalIpId());
                if (externalIp != null) {
                    loadBalancerPhysicalStatus.azureExternalIPLink = this.buildExternalIpLink(loadBalancer.getVirtualNetwork().getCloudAccount().getAzureTenantId(), loadBalancer.getVirtualNetwork().getCloudAccount().getAzureSubscription(), loadBalancer.getVirtualNetwork().getAzureRgName(), externalIp.name());
                    loadBalancerPhysicalStatus.azureExternalIPName = externalIp.name();
                } else {
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Application gateway '" + currentPhysicalLoadBalancer.getAzureApplicationGatewayId() + "' refers a public IP '" + currentPhysicalLoadBalancer.getAzureFMManagedExternalIpId() + "' which doesn't exist anymore.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_REPROVISIONING);
                }
            }
        }
    }

    private void getLoadBalancerListenersStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, ApplicationGateway applicationGateway) {
        HashMap listeners = new HashMap(applicationGateway.listeners());
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
        for (String hostname : nodeMappingsPerHostName.keySet()) {
            String listenerId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
            if (!listeners.containsKey(listenerId)) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' couldn't be found.");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                continue;
            }
            ApplicationGatewayListener applicationGatewayListener = (ApplicationGatewayListener)listeners.get(listenerId);
            if (!applicationGatewayListener.hostname().equals(this.azureDNSService.computeNodeMappingHostname(loadBalancer, hostname))) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' refers to hostname '" + applicationGatewayListener.hostname() + "' instead of '" + hostname + "'");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            }
            switch (loadBalancer.getCertificateMode()) {
                case NO_CERTIFICATE: {
                    if (applicationGatewayListener.frontendPortNumber() != 80) {
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' refers to port '" + applicationGatewayListener.frontendPortNumber() + "' instead of port 80");
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    }
                    if (applicationGatewayListener.sslCertificate() == null) break;
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' refers to a certificate.");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    break;
                }
                default: {
                    if (applicationGatewayListener.frontendPortNumber() != 443) {
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' refers to port '" + applicationGatewayListener.frontendPortNumber() + "' instead of port 443");
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    }
                    if (applicationGatewayListener.sslCertificate() == null) {
                        loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' doesn't have a certificate attached.");
                        loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                        break;
                    }
                    if (Objects.equals(((ApplicationGatewaySslCertificate)applicationGatewayListener.sslCertificate()).keyVaultSecretId(), loadBalancer.getAzureCertificateSecretId())) break;
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The listener '" + listenerId + "' refers to certificate secret id '" + ((ApplicationGatewaySslCertificate)applicationGatewayListener.sslCertificate()).keyVaultSecretId() + "' instead of '" + loadBalancer.getAzureCertificateSecretId() + "'");
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                }
            }
            listeners.remove(listenerId);
        }
        if (!listeners.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Found listeners not associated to a current node mapping: '" + String.join((CharSequence)"', '", listeners.keySet()) + "'");
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
    }

    private void getLoadBalancerBackendConfigStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, ApplicationGateway applicationGateway) {
        HashMap backendConfigs = new HashMap(applicationGateway.backendHttpConfigurations());
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
        for (String hostname : nodeMappingsPerHostName.keySet()) {
            int backendPort;
            String backendConfigId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
            if (!backendConfigs.containsKey(backendConfigId)) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The backend config '" + backendConfigId + "' couldn't be found.");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                continue;
            }
            ApplicationGatewayBackendHttpConfiguration backendConfig = (ApplicationGatewayBackendHttpConfiguration)backendConfigs.get(backendConfigId);
            int n = backendPort = loadBalancer.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? 80 : 443;
            if (backendConfig.port() != backendPort) {
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "The backend config '" + backendConfigId + "' refers to port '" + backendConfig.port() + "' instead of port '" + backendPort + "'");
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            }
            backendConfigs.remove(backendConfigId);
        }
        if (!backendConfigs.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Found backend configs not associated to a current node mapping: '" + backendConfigs.keySet().stream().collect(Collectors.joining("', '")) + "'");
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
    }

    private void getLoadBalancerRequestRoutingRulesStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, ApplicationGateway applicationGateway) {
        Set ruleHostnames = applicationGateway.requestRoutingRules().keySet().stream().filter(name -> name.startsWith(LB_RESOURCE_NAME_PREFIX)).map(name -> name.substring(LB_RESOURCE_NAME_PREFIX.length())).collect(Collectors.toSet());
        Set<String> nodeMappingHostnames = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName().keySet();
        HashSet rulesToDelete = new HashSet(ruleHostnames);
        rulesToDelete.removeAll(nodeMappingHostnames);
        if (!rulesToDelete.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_ORPHAN_RESOURCES, "Orphan request routing rule should be deleted for hostnames [%s]", new Object[]{String.join((CharSequence)", ", rulesToDelete)});
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
        HashSet<String> rulesToAdd = new HashSet<String>(nodeMappingHostnames);
        rulesToAdd.removeAll(ruleHostnames);
        if (!rulesToAdd.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withErrorV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Request routing rules missing for hostnames [%s]", new Object[]{String.join((CharSequence)", ", rulesToAdd)});
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
    }

    private void getLoadBalancerBackendsStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, ApplicationGateway applicationGateway) {
        Set backendHostnames = applicationGateway.backends().keySet().stream().filter(name -> name.startsWith(LB_RESOURCE_NAME_PREFIX)).map(name -> name.substring(LB_RESOURCE_NAME_PREFIX.length())).collect(Collectors.toSet());
        Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
        Set<String> nodeMappingHostnames = nodeMappingsPerHostName.keySet();
        HashSet backendsToDelete = new HashSet(backendHostnames);
        backendsToDelete.removeAll(nodeMappingHostnames);
        if (!backendsToDelete.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_ORPHAN_RESOURCES, "Orphan backend pool should be deleted for hostnames [%s]", new Object[]{String.join((CharSequence)", ", backendsToDelete)});
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
        HashSet<String> backendsToAdd = new HashSet<String>(nodeMappingHostnames);
        backendsToAdd.removeAll(backendHostnames);
        if (!backendsToAdd.isEmpty()) {
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "Backend pools missing for hostnames [%s]", new Object[]{String.join((CharSequence)", ", backendsToAdd)});
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
        HashSet<String> commonHostnames = new HashSet<String>(nodeMappingHostnames);
        commonHostnames.retainAll(backendHostnames);
        CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
        VirtualMachines virtualMachines = this.clientService.getAzureClient(cloudAccount).virtualMachines();
        for (String hostname : commonHostnames) {
            ApplicationGatewayBackend backend = (ApplicationGatewayBackend)applicationGateway.backends().get(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname));
            Set nodeMappings = nodeMappingsPerHostName.get(hostname).stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).collect(Collectors.toSet());
            HashMap<String, String> ipToInstanceLabel = new HashMap<String, String>();
            for (LoadBalancerNodeMapping nodeMapping : nodeMappings) {
                try {
                    String vmId = nodeMapping.getLogicalInstance().getCurrentPhysicalInstance().getAzureVMInstanceId();
                    NetworkInterface networkInterface = ((VirtualMachine)virtualMachines.getById(vmId)).getPrimaryNetworkInterface();
                    String ip = networkInterface.primaryIPConfiguration().privateIpAddress();
                    String label = nodeMapping.getLogicalInstance().getLabel();
                    ipToInstanceLabel.put(ip, label);
                }
                catch (Exception e) {
                    loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_VM_LOOKUP_FAILED, "Failed to retrieve VM or IP for instance label '%s': %s", new Object[]{nodeMapping.getLogicalInstance().getLabel(), e.getMessage()});
                }
            }
            Set backendsIps = backend.addresses().stream().map(ApplicationGatewayBackendAddress::ipAddress).collect(Collectors.toSet());
            HashSet ipsToAdd = new HashSet(ipToInstanceLabel.keySet());
            ipsToAdd.removeAll(backendsIps);
            if (!ipsToAdd.isEmpty()) {
                Set instanceLabels = ipsToAdd.stream().map(ipToInstanceLabel::get).collect(Collectors.toSet());
                loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_CLOUD_PARTIALLY_PROVISIONED, "IP of instances [%s] missing in backend pool for hostname '%s'", new Object[]{String.join((CharSequence)", ", instanceLabels), hostname});
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
            }
            HashSet ipsToDelete = new HashSet(backendsIps);
            ipsToDelete.removeAll(ipToInstanceLabel.keySet());
            if (ipsToDelete.isEmpty()) continue;
            loadBalancerPhysicalStatus.infoMessages.withWarningV((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_ORPHAN_RESOURCES, "Orphan IPs [%s] in backend pool for hostname '%s' should be deleted", new Object[]{String.join((CharSequence)", ", ipsToDelete), hostname});
            loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
        }
    }

    private void getLoadBalancerDNSStatus(LogicalLoadBalancer loadBalancer, LoadBalancerPhysicalStatus loadBalancerPhysicalStatus, ApplicationGateway applicationGateway) {
        if (loadBalancer.getVirtualNetwork().getDnsStrategy() != VirtualNetwork.DNSStrategy.NONE) {
            PublicIpAddress publicIPAddress = applicationGateway.defaultPublicFrontend().getPublicIpAddress();
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
            for (String hostname : nodeMappingsPerHostName.keySet()) {
                Optional<String> dnsRecord = this.azureDNSService.getDNSRecord(loadBalancer.getVirtualNetwork(), hostname, DNSservice.ZoneType.PUBLIC, DNSservice.RecordType.A, true);
                if (dnsRecord.isPresent()) {
                    if (dnsRecord.get().equals(publicIPAddress.ipAddress())) continue;
                    loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                    loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_WRONG_DNS_RECORD, "DNS record  '" + hostname + "' = '" + dnsRecord.get() + "' not matching Load balancing DNS '" + publicIPAddress.ipAddress() + "'.");
                    continue;
                }
                loadBalancerPhysicalStatus.setStatus(LoadBalancerDTO.PhysicalStatus.NEED_UPDATING);
                loadBalancerPhysicalStatus.infoMessages.withWarning((InfoMessage.MessageCode)LoadBalancerAzureCodes.AZURE_LB_MISSING_DNS_RECORD, "DNS record  '" + hostname + "' not found.");
            }
        }
    }

    private void updateSSL(LogicalLoadBalancer loadBalancer, PhysicalLoadBalancer currentPhysicalLoadBalancer, ApplicationGateway applicationGateway, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail) {
        String sslConfigId = this.getCertificateConfigId(currentPhysicalLoadBalancer.getId());
        switch (loadBalancer.getCertificateMode()) {
            case AZURE_SECRET_ID: {
                if (!applicationGateway.sslCertificates().containsKey(sslConfigId)) {
                    smartLogTail.appendLine("Setting up SSL configuration creation: '" + sslConfigId + "'", logger, Priority.INFO);
                    applicationGatewayUpdateUtils.gateway().defineSslCertificate(sslConfigId).withKeyVaultSecretId(loadBalancer.getAzureCertificateSecretId()).attach();
                    break;
                }
                ApplicationGatewaySslCertificate applicationGatewaySslCertificate = (ApplicationGatewaySslCertificate)applicationGateway.sslCertificates().get(sslConfigId);
                if (applicationGatewaySslCertificate.keyVaultSecretId().equals(loadBalancer.getAzureCertificateSecretId())) break;
                throw new IllegalStateException("Could not update a SSL certificate of an already provisioned gateway. Please provision or reprovision instead.");
            }
            default: {
                if (!applicationGateway.sslCertificates().containsKey(sslConfigId)) break;
                smartLogTail.appendLine("Setting up SSL configuration removal: '" + sslConfigId + "'", logger, Priority.INFO);
                applicationGatewayUpdateUtils.gateway().withoutSslCertificate(sslConfigId);
            }
        }
    }

    private void synchronizeBackend(LogicalLoadBalancer loadBalancer, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, Set<PhysicalInstance> physicalInstances, ApplicationGatewayBackend backend) {
        smartLogTail.appendLine("Setting up for backend update: '" + AzureCloudLoadBalancerService.getResourceIdForHostname(hostname) + "'", logger, Priority.INFO);
        CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
        VirtualMachines virtualMachines = this.clientService.getAzureClient(cloudAccount).virtualMachines();
        Set requiredIPs = physicalInstances.stream().map(physicalInstance -> ((VirtualMachine)virtualMachines.getById(physicalInstance.getAzureVMInstanceId())).getPrimaryNetworkInterface().primaryIPConfiguration().privateIpAddress()).collect(Collectors.toSet());
        Set currentIPs = backend.addresses().stream().map(ApplicationGatewayBackendAddress::ipAddress).collect(Collectors.toSet());
        ApplicationGatewayBackend.Update updateBackend = applicationGatewayUpdateUtils.gateway().updateBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname));
        HashSet<String> ipsToRemove = new HashSet<String>(currentIPs);
        ipsToRemove.removeAll(requiredIPs);
        if (!ipsToRemove.isEmpty()) {
            smartLogTail.appendLine(String.format("Removing IPs (%s) from backend '%s'", ipsToRemove.stream().collect(Collectors.joining(", ")), AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)), logger, Priority.INFO);
        }
        ipsToRemove.forEach(arg_0 -> ((ApplicationGatewayBackend.Update)updateBackend).withoutIPAddress(arg_0));
        HashSet<String> ipsToAdd = new HashSet<String>(requiredIPs);
        ipsToAdd.removeAll(currentIPs);
        if (!ipsToAdd.isEmpty()) {
            smartLogTail.appendLine(String.format("Adding IPs (%s) to backend '%s'", ipsToAdd.stream().collect(Collectors.joining(", ")), AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)), logger, Priority.INFO);
        }
        ipsToAdd.forEach(arg_0 -> ((ApplicationGatewayBackend.Update)updateBackend).withIPAddress(arg_0));
    }

    private void emptyExistingBackend(ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, ApplicationGatewayBackend backend) {
        smartLogTail.appendLine("Setting up for backend emptying: '" + AzureCloudLoadBalancerService.getResourceIdForHostname(hostname) + "'", logger, Priority.INFO);
        backend.addresses().forEach(arg_0 -> ((ApplicationGatewayBackend.Update)applicationGatewayUpdateUtils.gateway().updateBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname))).withoutAddress(arg_0));
    }

    private void createBackend(LogicalLoadBalancer loadBalancer, ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail, String hostname, Set<PhysicalInstance> physicalInstances) {
        smartLogTail.appendLine("Setting up for backend creation: '" + AzureCloudLoadBalancerService.getResourceIdForHostname(hostname) + "'", logger, Priority.INFO);
        CloudAccount cloudAccount = loadBalancer.getVirtualNetwork().getCloudAccount();
        VirtualMachines virtualMachines = this.clientService.getAzureClient(cloudAccount).virtualMachines();
        ApplicationGatewayBackend.UpdateDefinitionStages.Blank backend = applicationGatewayUpdateUtils.gateway().defineBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname));
        for (PhysicalInstance physicalInstance : physicalInstances) {
            VirtualMachine virtualMachine = (VirtualMachine)virtualMachines.getById(physicalInstance.getAzureVMInstanceId());
            NetworkInterface networkInterface = virtualMachine.getPrimaryNetworkInterface();
            NicIpConfiguration primaryIPConfiguration = networkInterface.primaryIPConfiguration();
            String privateIp = primaryIPConfiguration.privateIpAddress();
            backend.withIPAddress(privateIp).attach();
        }
    }

    private void createEmptyBackend(ApplicationGatewayUpdateUtils applicationGatewayUpdateUtils, DKUtils.SmartLogTailBuilder smartLogTail, String hostname) {
        smartLogTail.appendLine("Setting up for empty backend creation: '" + AzureCloudLoadBalancerService.getResourceIdForHostname(hostname) + "'", logger, Priority.INFO);
        applicationGatewayUpdateUtils.gateway().defineBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).attach();
    }

    private void updateDnsRecords(ApplicationGateway applicationGateway, LogicalLoadBalancer loadBalancer, DatabaseAccessService.ReadWriteTransaction rwt, DKUtils.SmartLogTailBuilder smartLogTail) throws InterruptedException {
        try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement dnsRecordsStep = FutureProgress.pushAutoCloseableState((String)"Updating DNS records", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
            if (loadBalancer.getVirtualNetwork().getDnsStrategy() == VirtualNetwork.DNSStrategy.NONE) {
                return;
            }
            Map<String, ARecordSet> dnsRecordPerHostname = this.azureDNSService.getDNSRecordPerLoadBalancerHostname(loadBalancer.getVirtualNetwork());
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = loadBalancer.getLoadBalancerActiveNodeMappingsPerHostName();
            Set recordsToDelete = dnsRecordPerHostname.keySet().stream().filter(hostname -> !nodeMappingsPerHostName.containsKey(hostname)).collect(Collectors.toSet());
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deleteRecordsStep = FutureProgress.pushAutoCloseableState((String)"Deleting DNS records", (double)recordsToDelete.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                for (String hostname2 : recordsToDelete) {
                    smartLogTail.appendLine("Deleting orphan DNS record '" + hostname2 + "'", logger, Priority.INFO);
                    ARecordSet record = dnsRecordPerHostname.get(hostname2);
                    this.azureDNSService.removeAzureDNSRecord(loadBalancer.getVirtualNetwork(), record.name());
                    PhysicalDNSRecord physicalDNSRecord = this.dbService.getSingleResult(PhysicalDNSRecord.class, "SELECT pr from physicaldnsrecord pr where pr.name=?1", record.name());
                    if (physicalDNSRecord != null) {
                        this.dbService.getThreadEM().remove((Object)physicalDNSRecord);
                    }
                    FutureProgress.incrementState((double)1.0);
                }
            }
            PublicIpAddress publicLbIpAddress = applicationGateway.defaultPublicFrontend().getPublicIpAddress();
            Set recordsToCreate = nodeMappingsPerHostName.keySet().stream().filter(hostname -> !dnsRecordPerHostname.containsKey(hostname) || !((ARecordSet)dnsRecordPerHostname.get(hostname)).ipv4Addresses().contains(publicLbIpAddress.ipAddress())).collect(Collectors.toSet());
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement createRecordsStep = FutureProgress.pushAutoCloseableState((String)"Creating DNS records", (double)recordsToCreate.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);){
                for (String hostname3 : recordsToCreate) {
                    smartLogTail.appendLine("Setting up DNS record for '" + hostname3 + "' -> '" + publicLbIpAddress.ipAddress() + "'", logger, Priority.INFO);
                    Map<DNSservice.ZoneType, PhysicalDNSRecord> zoneTypePhysicalDNSRecordMap = this.azureDNSService.addDNSRecords(loadBalancer.getVirtualNetwork(), hostname3, publicLbIpAddress.ipAddress(), null, DNSservice.RecordType.A, AzureUtils.getTagsWithName(LB_RESOURCE_NAME_PREFIX + hostname3, loadBalancer.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())));
                    nodeMappingsPerHostName.get(hostname3).forEach(nodeMapping -> {
                        if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PRIVATE)) {
                            nodeMapping.setPrivatePhysicalDNSRecord((PhysicalDNSRecord)zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PRIVATE));
                        }
                        if (zoneTypePhysicalDNSRecordMap.containsKey((Object)DNSservice.ZoneType.PUBLIC)) {
                            nodeMapping.setPublicPhysicalDNSRecord((PhysicalDNSRecord)zoneTypePhysicalDNSRecordMap.get((Object)DNSservice.ZoneType.PUBLIC));
                        }
                    });
                    FutureProgress.incrementState((double)1.0);
                }
            }
        }
    }

    private String getCertificateConfigId(String physicalLoadBalancerId) {
        return "lb-cert-" + physicalLoadBalancerId;
    }

    private String buildApplicationGatewayResourceId(String resourceGroupName, String azureSubscriptionId, String physicalLoadBalancerId) {
        return "/subscriptions/" + azureSubscriptionId + "/resourceGroups/" + resourceGroupName + "/providers/Microsoft.Network/applicationGateways/" + physicalLoadBalancerId;
    }

    private String buildExternalIpLink(String tenantId, String subscriptionId, String resourceGroupName, String externalIpName) {
        return "https://app.azure.com/" + tenantId + "/subscriptions/" + subscriptionId + "/resourceGroups/" + resourceGroupName + "/providers/Microsoft.Network/publicIPAddresses/" + externalIpName;
    }

    private class AzureGatewayBuilder {
        private final LogicalLoadBalancer lb;
        private final PhysicalLoadBalancer plb;
        private ApplicationGateway.DefinitionStages.WithRequestRoutingRule setupGatewayResult;
        private ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate setupRulesResult;
        private ApplicationGateway.DefinitionStages.WithCreate setupListenersResult;
        private ApplicationGateway.DefinitionStages.WithCreate setupBackendsResult;
        private ApplicationGateway.DefinitionStages.WithCreate setupIPResult;
        private ApplicationGateway.DefinitionStages.WithCreate setupCertificateResult;

        public AzureGatewayBuilder(LogicalLoadBalancer lb, PhysicalLoadBalancer plb) {
            this.lb = lb;
            this.plb = plb;
        }

        public ApplicationGateway build() {
            return this.setupGateway().setupRules().setupListeners().setupBackends().setupCertificate().setupIp().createGateway();
        }

        private AzureGatewayBuilder setupGateway() {
            CloudAccount cloudAccount = this.lb.getVirtualNetwork().getCloudAccount();
            this.setupGatewayResult = (ApplicationGateway.DefinitionStages.WithRequestRoutingRule)((ApplicationGateway.DefinitionStages.WithGroup)((ApplicationGateway.DefinitionStages.Blank)AzureCloudLoadBalancerService.this.clientService.getAzureClient(cloudAccount).applicationGateways().define(this.plb.getId())).withRegion(this.lb.getVirtualNetwork().getAzureRegion())).withExistingResourceGroup(this.lb.getVirtualNetwork().getAzureRgName());
            return this;
        }

        private AzureGatewayBuilder setupRules() {
            assert (this.setupGatewayResult != null);
            ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate attach = null;
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = this.lb.getLoadBalancerActiveNodeMappingsPerHostName();
            for (String hostname : nodeMappingsPerHostName.keySet()) {
                String ruleId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
                logger.info((Object)("Creating rule '" + ruleId + "'"));
                attach = (ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate)(attach == null ? this.setupGatewayResult.defineRequestRoutingRule(ruleId) : attach.defineRequestRoutingRule(ruleId)).fromListener(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).toBackendHttpConfiguration(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).toBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).attach();
            }
            this.setupRulesResult = attach;
            return this;
        }

        private AzureGatewayBuilder setupListeners() {
            assert (this.setupRulesResult != null);
            logger.info((Object)"Defines listeners");
            ApplicationGateway.DefinitionStages.WithCreate withCreate = null;
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = this.lb.getLoadBalancerActiveNodeMappingsPerHostName();
            for (String hostname : nodeMappingsPerHostName.keySet()) {
                String listenerId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
                logger.info((Object)("Creating listener '" + listenerId + "'"));
                String nodeMappingHostname = AzureCloudLoadBalancerService.this.azureDNSService.computeNodeMappingHostname(this.lb, hostname);
                if (this.lb.getCertificateMode() == CertificateMode.NO_CERTIFICATE) {
                    withCreate = (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayListener.DefinitionStages.WithAttach)(withCreate == null ? this.setupRulesResult.defineListener(listenerId) : withCreate.defineListener(listenerId)).withPublicFrontend().withFrontendPort(80).withHttp().withHostname(nodeMappingHostname)).attach();
                    continue;
                }
                withCreate = (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayListener.DefinitionStages.WithAttach)((ApplicationGatewayListener.DefinitionStages.WithAttach)(withCreate == null ? this.setupRulesResult.defineListener(listenerId) : withCreate.defineListener(listenerId)).withPublicFrontend().withFrontendPort(443).withHttps().withSslCertificate(AzureCloudLoadBalancerService.this.getCertificateConfigId(this.plb.getId()))).withHostname(nodeMappingHostname)).attach();
            }
            this.setupListenersResult = withCreate;
            return this;
        }

        private AzureGatewayBuilder setupBackends() {
            assert (this.setupListenersResult != null);
            logger.info((Object)"Defines backend");
            ApplicationGateway.DefinitionStages.WithCreate withCreate = this.setupListenersResult;
            Map<String, Set<LoadBalancerNodeMapping>> nodeMappingsPerHostName = this.lb.getLoadBalancerActiveNodeMappingsPerHostName();
            for (String hostname : nodeMappingsPerHostName.keySet()) {
                String backendConfigId = AzureCloudLoadBalancerService.getResourceIdForHostname(hostname);
                logger.info((Object)("Creating backend config '" + backendConfigId + "'"));
                withCreate = this.lb.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.NONE ? (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayBackendHttpConfiguration.DefinitionStages.WithAttach)withCreate.defineBackendHttpConfiguration(backendConfigId).withPort(80)).withCookieBasedAffinity().attach() : (ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGatewayBackendHttpConfiguration.DefinitionStages.WithAttach)withCreate.defineBackendHttpConfiguration(backendConfigId).withPort(443)).withHttps().withCookieBasedAffinity().attach();
                Set<LoadBalancerNodeMapping> nodeMappings = nodeMappingsPerHostName.get(hostname);
                Set physicalInstances = nodeMappings.stream().filter(LoadBalancerNodeMapping::isInstanceProvisioned).map(nodeMapping -> nodeMapping.getLogicalInstance().getCurrentPhysicalInstance()).collect(Collectors.toSet());
                if (!physicalInstances.isEmpty()) {
                    CloudAccount cloudAccount = this.lb.getVirtualNetwork().getCloudAccount();
                    VirtualMachines virtualMachines = AzureCloudLoadBalancerService.this.clientService.getAzureClient(cloudAccount).virtualMachines();
                    for (PhysicalInstance physicalInstance : physicalInstances) {
                        String privateIp = ((VirtualMachine)virtualMachines.getById(physicalInstance.getAzureVMInstanceId())).getPrimaryNetworkInterface().primaryIPConfiguration().privateIpAddress();
                        withCreate = (ApplicationGateway.DefinitionStages.WithCreate)withCreate.defineBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).withIPAddress(privateIp).attach();
                    }
                    continue;
                }
                withCreate = (ApplicationGateway.DefinitionStages.WithCreate)withCreate.defineBackend(AzureCloudLoadBalancerService.getResourceIdForHostname(hostname)).attach();
            }
            this.setupBackendsResult = withCreate;
            return this;
        }

        private AzureGatewayBuilder setupCertificate() {
            assert (this.setupBackendsResult != null);
            String certificateConfigId = AzureCloudLoadBalancerService.this.getCertificateConfigId(this.plb.getId());
            switch (this.lb.getCertificateMode()) {
                case AZURE_SECRET_ID: {
                    logger.info((Object)("Creating certificate config '" + certificateConfigId + "'"));
                    this.setupCertificateResult = (ApplicationGateway.DefinitionStages.WithCreate)this.setupBackendsResult.defineSslCertificate(certificateConfigId).withKeyVaultSecretId(this.lb.getAzureCertificateSecretId()).attach();
                    break;
                }
                default: {
                    this.setupCertificateResult = this.setupBackendsResult;
                }
            }
            return this;
        }

        private AzureGatewayBuilder setupIp() {
            assert (this.setupCertificateResult != null);
            switch (this.lb.getPublicIpMode()) {
                case STATIC_PUBLIC_IP: {
                    CloudAccount cloudAccount1 = this.lb.getVirtualNetwork().getCloudAccount();
                    PublicIpAddress publicIPAddress = (PublicIpAddress)AzureCloudLoadBalancerService.this.clientService.getAzureClient(cloudAccount1).publicIpAddresses().getById(this.lb.getAzurePublicIPID());
                    logger.info((Object)("Public IP address: " + publicIPAddress.id() + " -> " + publicIPAddress.ipAddress()));
                    this.setupIPResult = (ApplicationGateway.DefinitionStages.WithCreate)this.setupCertificateResult.withExistingPublicIpAddress(publicIPAddress);
                    break;
                }
                case DYNAMIC_PUBLIC_IP: {
                    logger.info((Object)"Creating IP address ");
                    CloudAccount cloudAccount = this.lb.getVirtualNetwork().getCloudAccount();
                    PublicIpAddress publicIPAddress = (PublicIpAddress)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithCreate)((PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)AzureCloudLoadBalancerService.this.clientService.getAzureClient(cloudAccount).publicIpAddresses().define("ip-" + this.plb.getId())).withRegion(this.lb.getVirtualNetwork().getAzureRegion())).withExistingResourceGroup(this.lb.getVirtualNetwork().getAzureRgName())).withSku(PublicIPSkuType.STANDARD).withStaticIP().withTags(AzureUtils.getTagsWithName(String.format("Public IP address for %s", this.lb.getName()), this.lb.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())))).create();
                    logger.info((Object)("Public IP address: " + publicIPAddress.id() + " -> " + publicIPAddress.ipAddress()));
                    this.plb.setAzureExternalIpId(publicIPAddress.id());
                    this.setupIPResult = (ApplicationGateway.DefinitionStages.WithCreate)this.setupCertificateResult.withExistingPublicIpAddress(publicIPAddress);
                }
            }
            return this;
        }

        private ApplicationGateway createGateway() {
            assert (this.setupIPResult != null);
            HashMap<String, ManagedServiceIdentityUserAssignedIdentities> identities = new HashMap<String, ManagedServiceIdentityUserAssignedIdentities>();
            String lbIdentity = this.lb.getVirtualNetwork().getCloudAccount().getAzureManagedIdentityId();
            identities.put(StringUtils.nullIfBlank((String)lbIdentity) == null ? FMApp.getFMSettingsUnsafe().azureSettings.managedIdentityId : lbIdentity, new ManagedServiceIdentityUserAssignedIdentities());
            ManagedServiceIdentity managedServiceIdentity = new ManagedServiceIdentity().withType(ResourceIdentityType.USER_ASSIGNED).withUserAssignedIdentities(identities);
            logger.info((Object)("Creating gateway of tier '" + String.valueOf((Object)this.lb.getTier()) + "'"));
            switch (this.lb.getTier()) {
                case WAF_V2: {
                    this.setupIPResult = this.setupIPResult.withTier(ApplicationGatewayTier.WAF_V2).withSize(ApplicationGatewaySkuName.WAF_V2).withWebApplicationFirewall(true, ApplicationGatewayFirewallMode.PREVENTION);
                    break;
                }
                default: {
                    this.setupIPResult = this.setupIPResult.withTier(ApplicationGatewayTier.STANDARD_V2).withSize(ApplicationGatewaySkuName.STANDARD_V2);
                }
            }
            return (ApplicationGateway)((ApplicationGateway.DefinitionStages.WithCreate)((ApplicationGateway.DefinitionStages.WithCreate)this.setupIPResult.withInstanceCount(1).withIdentity(managedServiceIdentity).withTags(AzureUtils.getTagsWithName(this.lb.getName(), this.lb.getCloudApplicableTags(FMApp.getFMSettingsUnsafe())))).withExistingSubnet(this.lb.getVirtualNetwork().getAzureVnId(), this.lb.getVirtualNetwork().getAzureSecondSubnet())).create();
        }
    }

    private static class ApplicationGatewayUpdateUtils {
        private ApplicationGateway.Update gateway;
        public boolean needUpdate = false;

        public ApplicationGatewayUpdateUtils(ApplicationGateway.Update gateway) {
            this.gateway = gateway;
        }

        public ApplicationGateway.Update gateway() {
            this.needUpdate = true;
            return this.gateway;
        }
    }

    public static enum LoadBalancerAzureCodes implements InfoMessage.MessageCode
    {
        AZURE_LB_NOT_PROVISIONED("Azure load balancer not provisioned", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_CLOUD_UNAVAILABLE("Azure load balancer exists but is not available in the cloud", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_CLOUD_PARTIALLY_PROVISIONED("Azure load balancer is partially provisioned in the cloud", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_PROVISIONING("Azure load balancer is starting", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_MISSING_DNS_RECORD("Azure load balancer is missing DNS records in Azure", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_WRONG_DNS_RECORD("Azure load balancer has wrong DNS records in Azure", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_WRONG_NETWORK("Azure load balancer is on the WRONG network", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_ORPHAN_RESOURCES("Azure load balancer has orphan resources", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_VM_LOOKUP_FAILED("Could not retrieve VM or network information", InfoMessage.FixabilityCategory.IRRELEVANT),
        AZURE_LB_PROVISIONED("Azure load balancer started", InfoMessage.FixabilityCategory.IRRELEVANT),
        LB_NODES_UPDATED_NODE_MAPPING_NEED_REPROVISIONING("Load balancer has some rules which needs to be updated.", InfoMessage.FixabilityCategory.IRRELEVANT);

        private final String title;
        private final InfoMessage.FixabilityCategory fixability;

        private LoadBalancerAzureCodes(String title, InfoMessage.FixabilityCategory fixability) {
            this.title = title;
            this.fixability = fixability;
        }

        public String getCode() {
            return this.name();
        }

        public String getCodeTitle() {
            return this.title;
        }

        public InfoMessage.FixabilityCategory getFixability() {
            return this.fixability;
        }
    }
}

