/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.com.google.api.services.compute.Compute;
import com.dataiku.dss.shadelib.com.google.api.services.compute.ComputeRequest;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.Firewall;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.Network;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.NetworkPeering;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.NetworkRoutingConfig;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.NetworksAddPeeringRequest;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.NetworksRemovePeeringRequest;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.Operation;
import com.dataiku.dss.shadelib.com.google.api.services.compute.model.Subnetwork;
import com.dataiku.dss.shadelib.com.google.common.base.Joiner;
import com.dataiku.fm.cloud.CloudNetworkServiceInterface;
import com.dataiku.fm.cloud.CloudNetworkServiceUtils;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.cloud.gcp.GCPClientService;
import com.dataiku.fm.cloud.gcp.GCPDNSService;
import com.dataiku.fm.cloud.gcp.GCPInstanceMetadataReader;
import com.dataiku.fm.cloud.gcp.GCPUtils;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;

public class GCPCloudNetworkService
implements CloudNetworkServiceInterface {
    private static final Pattern SUBNETWORK_SELFLINK_PATTERN = Pattern.compile("^.*googleapis.com/compute/v1/projects/([^/]+)/regions/([^/]+)/subnetworks/([^/]+)(/.*)?$");
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private GCPClientService clientService;
    @Autowired
    private CloudAccountsService cloudAccountsService;
    @Autowired
    private GCPDNSService gcpdnsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.cloud.gcp.network");

    @Override
    public VirtualNetwork createManagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        VirtualNetwork newVN;
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        assert (tenant != null);
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String networkProjectId = GCPUtils.getNetworkProjectId(input.gcpProjectId, tenant, settings);
        String zone = settings.gcpSettings.zone;
        Compute apiClient = this.clientService.getAPIClient(tenant.getVirtualCloudAccount(settings));
        String region = GCPUtils.getRegionOfZone(networkProjectId, zone, apiClient);
        String cidr = CloudNetworkServiceUtils.findUniqueCIDR(this.dbService);
        CloudAccount cloudAccount = input.accountId != null ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(settings);
        String id = "vn-" + SecretKeyGenerator.generate((int)12).toLowerCase();
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            VirtualNetwork newVN2 = new VirtualNetwork();
            newVN2.setId(id);
            newVN2.setManagedCidr(cidr);
            if (StringUtils.isNotEmpty((String)input.accountId)) {
                newVN2.setCloudAccount(cloudAccount);
            }
            newVN2.setTenant(tenant);
            rwt.getThreadEM().persist((Object)newVN2);
            rwt.commit();
        }
        String networkUrl = String.format("projects/%s/global/networks/%s", networkProjectId, id);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Compute.Subnetworks.Insert insertSubnetwork;
            Compute.Networks.Insert insertNetwork;
            newVN = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)id);
            newVN.setLabel(input.label);
            newVN.setDescription(input.description);
            newVN.setMode(VirtualNetwork.VirtualNetworkMode.FM_MANAGED);
            String networkId = id;
            String subnetworkId = id + "-" + region;
            newVN.setGcpProjectId(networkProjectId);
            newVN.setGcpNetwork(networkId);
            newVN.setGcpSubnetwork(subnetworkId);
            newVN.setGcpRegion(region);
            Network network = new Network().setName(networkId).setAutoCreateSubnetworks(Boolean.valueOf(false)).setRoutingConfig(new NetworkRoutingConfig().setRoutingMode("REGIONAL"));
            try (FutureProgress.AutocloseableFutureProgressState networkStep = FutureProgress.pushAutoCloseableState((String)"Creating network");){
                insertNetwork = apiClient.networks().insert(networkProjectId, network);
            }
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)insertNetwork, networkProjectId, apiClient);
            Subnetwork subnetwork = new Subnetwork().setName(subnetworkId).setRegion(region).setNetwork(networkUrl).setIpCidrRange(cidr);
            try (FutureProgress.AutocloseableFutureProgressState networkStep = FutureProgress.pushAutoCloseableState((String)"Creating subnet");){
                insertSubnetwork = apiClient.subnetworks().insert(networkProjectId, region, subnetwork);
            }
            FutureProgress.updateState((double)1.0);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)insertSubnetwork, networkProjectId, apiClient);
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
        }
        try (FutureProgress.AutocloseableFutureProgressState peeringStep = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
            this.createPeering(apiClient, networkProjectId, id, newVN);
        }
        FutureProgress.updateState((double)2.0);
        if (input.allowIngressSSH) {
            Firewall rule = new Firewall().setName("allow-ssh-" + id).setNetwork(networkUrl).setDirection("INGRESS").setPriority(Integer.valueOf(1000)).setAllowed((List)Lists.newArrayList((Object[])new Firewall.Allowed[]{new Firewall.Allowed().setIPProtocol("tcp").setPorts((List)Lists.newArrayList((Object[])new String[]{"22"}))})).setSourceRanges((List)Lists.newArrayList((Object[])new String[]{"0.0.0.0/0"}));
            Compute.Firewalls.Insert insertRule = apiClient.firewalls().insert(networkProjectId, rule);
            GCPUtils.waitForOperation((ComputeRequest<Operation>)insertRule, networkProjectId, apiClient);
        }
        return newVN;
    }

    @Override
    public VirtualNetwork createUnmanagedVirtualNetwork(String tenantId, ProtoVirtualNetworkDTO input, DKUtils.SmartLogTailBuilder smartLogTail) throws Exception {
        String id = input.forcedID != null ? input.forcedID : "vn-" + SecretKeyGenerator.generate((int)12).toLowerCase();
        Tenant tenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", tenantId);
        CloudAccount cloudAccount = input.accountId != null ? this.cloudAccountsService.getAccountMandatory(tenant, input.accountId) : tenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe());
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String networkProjectId = GCPUtils.getNetworkProjectId(input.gcpProjectId, tenant, settings);
        String gcpRegion = null;
        try {
            Network network = (Network)this.clientService.getAPIClient(cloudAccount).networks().get(networkProjectId, input.gcpNetwork).execute();
            for (String selfLink : network.getSubnetworks()) {
                Matcher selfLinkMatcher = SUBNETWORK_SELFLINK_PATTERN.matcher(selfLink);
                if (!selfLinkMatcher.matches() || !input.gcpSubnetwork.equals(selfLinkMatcher.group(3))) continue;
                gcpRegion = selfLinkMatcher.group(2);
            }
            if (gcpRegion == null) {
                throw new IllegalArgumentException("Subnetwork " + input.gcpSubnetwork + " is not a subnet of " + input.gcpNetwork);
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to fetch region of subnetwork", e);
        }
        String gcpNetworkTags = input.gcpNetworkTags != null ? Joiner.on((String)",").join(input.gcpNetworkTags) : "";
        VirtualNetwork newVN = new VirtualNetwork();
        newVN.setId(id);
        newVN.setMode(input.mode);
        newVN.setLabel(input.label);
        newVN.setCloudTags(CloudTagList.toJSON(input.cloudTags));
        newVN.setDescription(input.description);
        if (StringUtils.isNotEmpty((String)input.accountId)) {
            newVN.setCloudAccount(cloudAccount);
        }
        newVN.setTenant(tenant);
        newVN.setGcpProjectId(networkProjectId);
        newVN.setGcpNetwork(input.gcpNetwork);
        newVN.setGcpSubnetwork(input.gcpSubnetwork);
        newVN.setGcpRegion(gcpRegion);
        newVN.setGcpAssignPublicIP(true);
        newVN.setGcpNetworkTags(gcpNetworkTags);
        String fmRegion = settings.gcpSettings.zone.substring(0, settings.gcpSettings.zone.lastIndexOf(45));
        String fmNetwork = settings.gcpSettings.network;
        logger.info((Object)("Creating VN in region '" + gcpRegion + "', FM region='" + fmRegion + "'"));
        newVN.setPeeringState(VirtualNetwork.PeeringState.NONE);
        if (!input.gcpNetwork.equals(fmNetwork)) {
            Compute apiClient = this.clientService.getAPIClient(cloudAccount);
            if (input.autoCreatePeerings) {
                try (FutureProgress.AutocloseableFutureProgressState createPeeringStep = FutureProgress.pushAutoCloseableState((String)"Creating peering");){
                    smartLogTail.appendLine("Creating peering ...", logger, Priority.INFO);
                    this.createPeering(apiClient, networkProjectId, input.gcpNetwork, newVN);
                    smartLogTail.replaceLastLine("Peering created", logger, Priority.INFO);
                }
            } else {
                logger.info((Object)"No peering auto creation, peering should be defined externally.");
                smartLogTail.appendLine("No peering auto creation, peering should be defined externally.");
                if (this.detectPeering(tenant, apiClient, networkProjectId, input.gcpNetwork, newVN)) {
                    smartLogTail.appendLine("Existing peering detected");
                } else {
                    smartLogTail.appendLine("No existing peering detected");
                }
            }
        }
        FutureProgress.updateState((double)1.0);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().persist((Object)newVN);
            rwt.commit();
            VirtualNetwork virtualNetwork = newVN;
            return virtualNetwork;
        }
    }

    @Override
    public boolean needsPeering(String tenantId, VirtualNetwork vn) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String fmNetwork = settings.gcpSettings.network;
        return !vn.getGcpNetwork().equals(fmNetwork);
    }

    @Override
    public Optional<String> getPeeringId(String tenantId, VirtualNetwork vn) {
        return StringUtils.isEmpty((String)vn.getGcpPeeringConnectionId()) ? Optional.empty() : Optional.of(vn.getGcpPeeringConnectionId());
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetwork(VirtualNetwork vn, boolean deletePeering) {
        InfoMessage.InfoMessages result = new InfoMessage.InfoMessages();
        if (vn.getGcpPeeringConnectionId() == null || !deletePeering || vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL) {
            return result;
        }
        Compute apiClient = this.clientService.getAPIClient(vn.getCloudAccount());
        try {
            this.deletePeering(apiClient, vn.getGcpProjectId(), vn.getGcpNetwork(), vn.getTenant());
        }
        catch (Exception e) {
            logger.warn((Object)"Error during peering deletion", (Throwable)e);
            result.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_PEERING_NOT_DELETED, e.getMessage());
        }
        return result;
    }

    @Override
    public InfoMessage.InfoMessages deleteVirtualNetworkSecurityGroups(VirtualNetwork vn) {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public VirtualNetworkMetadata getDefaultCreationValues(String tenantId) {
        return new GCPInstanceMetadataReader().getVirtualNetworkMetadata();
    }

    @Override
    public void validateSettings(VirtualNetwork vn, VirtualNetworkSettingsDTO dto) {
        if (dto.dnsStrategy == VirtualNetwork.DNSStrategy.VN_SPECIFIC_CLOUD_DNS_SERVICE) {
            if (!StringUtils.isEmpty((String)dto.gcpCloudDnsPrivateIPZoneId)) {
                this.gcpdnsService.checkIfZoneExist(vn, dto.gcpCloudDnsPrivateIPZoneId);
            }
            if (!StringUtils.isEmpty((String)dto.gcpCloudDnsPublicIPZoneId)) {
                this.gcpdnsService.checkIfZoneExist(vn, dto.gcpCloudDnsPublicIPZoneId);
            }
        }
    }

    private boolean detectPeering(Tenant tenant, Compute apiClient, String networkProjectId, String id, VirtualNetwork newVN) throws Exception {
        block5: {
            FMNetwork fm = this.getFMNetwork();
            Compute.Networks.Get request = apiClient.networks().get(networkProjectId, id);
            try {
                Network response = (Network)request.execute();
                if (response.getPeerings() == null) {
                    return false;
                }
                Optional<NetworkPeering> peering = response.getPeerings().stream().filter(p -> p.getNetwork().endsWith(fm.network)).findFirst();
                if (peering.isPresent()) {
                    newVN.setGcpPeeringConnectionId(peering.get().getName());
                    newVN.setPeeringState(VirtualNetwork.PeeringState.EXTERNAL);
                    for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
                        if (vn.getPeeringState() != VirtualNetwork.PeeringState.INTERNAL || !peering.get().getName().equals(vn.getGcpPeeringConnectionId())) continue;
                        newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
                    }
                    return true;
                }
            }
            catch (Exception exc) {
                if (exc.getMessage().contains("404 Not Found")) break block5;
                logger.error((Object)"Fail getting peer ", (Throwable)exc);
            }
        }
        return false;
    }

    private void createPeering(Compute apiClient, String networkProjectId, String id, VirtualNetwork newVN) throws Exception {
        FMNetwork fm = this.getFMNetwork();
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", "main");
        Compute fmClient = this.clientService.getAPIClient(fmTenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()));
        String networkUrl = String.format("projects/%s/global/networks/%s", networkProjectId, id);
        String fmNetworkUrl = String.format("projects/%s/global/networks/%s", fm.projectId, fm.network);
        String peeringName = id + "-peer-to-" + fm.network;
        if (this.detectPeering(fmTenant, apiClient, networkProjectId, id, newVN)) {
            return;
        }
        NetworksAddPeeringRequest peeringToFM = new NetworksAddPeeringRequest();
        NetworkPeering peeringToFMPeering = new NetworkPeering().setName(this.getPeeringName(id, fm.network)).setNetwork(fmNetworkUrl).setImportSubnetRoutesWithPublicIp(Boolean.valueOf(true)).setExchangeSubnetRoutes(Boolean.valueOf(true));
        peeringToFM.setNetworkPeering(peeringToFMPeering);
        Compute.Networks.AddPeering addPeeringToFM = apiClient.networks().addPeering(networkProjectId, id, peeringToFM);
        GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)addPeeringToFM, networkProjectId, apiClient);
        try {
            NetworksAddPeeringRequest peeringFromFM = new NetworksAddPeeringRequest();
            NetworkPeering peeringFromFMPeering = new NetworkPeering().setName(this.getPeeringName(fm.network, id)).setNetwork(networkUrl).setImportSubnetRoutesWithPublicIp(Boolean.valueOf(true)).setExchangeSubnetRoutes(Boolean.valueOf(true));
            peeringFromFM.setNetworkPeering(peeringFromFMPeering);
            Compute.Networks.AddPeering addPeeringFromFM = fmClient.networks().addPeering(fm.projectId, fm.network, peeringFromFM);
            GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)addPeeringFromFM, fm.projectId, fmClient);
            newVN.setGcpPeeringConnectionId(peeringName);
            newVN.setPeeringState(VirtualNetwork.PeeringState.INTERNAL);
        }
        catch (Exception exc) {
            this.removePeeringToFM(apiClient, networkProjectId, id);
        }
    }

    private String getPeeringName(String networkFrom, String networkTo) {
        return networkFrom + "-peer-to-" + networkTo;
    }

    private void removePeeringToFM(Compute apiClient, String networkProjectId, String id) throws Exception {
        FMNetwork fm = this.getFMNetwork();
        NetworksRemovePeeringRequest peeringToFM = new NetworksRemovePeeringRequest();
        peeringToFM.setName(this.getPeeringName(id, fm.network));
        Compute.Networks.RemovePeering removePeeringToFM = apiClient.networks().removePeering(networkProjectId, id, peeringToFM);
        GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)removePeeringToFM, networkProjectId, apiClient);
    }

    private void deletePeering(Compute apiClient, String networkProjectId, String id, Tenant tenant) throws Exception {
        FMNetwork fm = this.getFMNetwork();
        Tenant fmTenant = this.dbService.getSingleResult(Tenant.class, "SELECT t FROM tenant t where t.id=?1", "main");
        Compute fmClient = this.clientService.getAPIClient(fmTenant.getVirtualCloudAccount(FMApp.getFMSettingsUnsafe()));
        String peeringName = this.getPeeringName(id, fm.network);
        if (this.countPeerings(fm, tenant, peeringName) > 1) {
            logger.info((Object)"Peering is not deleted, as it's still in use.");
            return;
        }
        this.removePeeringToFM(apiClient, networkProjectId, id);
        NetworksRemovePeeringRequest peeringFromFM = new NetworksRemovePeeringRequest();
        peeringFromFM.setName(this.getPeeringName(fm.network, id));
        Compute.Networks.RemovePeering addPeeringFromFM = fmClient.networks().removePeering(fm.projectId, fm.network, peeringFromFM);
        GCPUtils.waitForOperationOrThrow((ComputeRequest<Operation>)addPeeringFromFM, fm.projectId, fmClient);
    }

    private int countPeerings(FMNetwork fm, Tenant tenant, String peeringName) {
        int count = 0;
        for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, this.dbService)) {
            if (!this.getPeeringName(vn.getGcpNetwork(), fm.network).equals(peeringName)) continue;
            ++count;
        }
        return count;
    }

    public FMNetwork getFMNetwork() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        String fmProjectId = settings.gcpSettings.projectId;
        String fmNetwork = settings.gcpSettings.network;
        String fmSubnetwork = settings.gcpSettings.subnetwork;
        if (StringUtils.isBlank((String)fmNetwork) || StringUtils.isBlank((String)fmSubnetwork)) {
            logger.info((Object)"FM network info missing in settings, detecting from instance metadata");
            VirtualNetworkMetadata detected = new GCPInstanceMetadataReader().getVirtualNetworkMetadata();
            fmProjectId = detected.gcpProjectId;
            fmNetwork = detected.gcpNetwork;
            fmSubnetwork = detected.gcpSubnetwork;
            if (StringUtils.isBlank((String)fmNetwork) || StringUtils.isBlank((String)fmSubnetwork)) {
                throw new IllegalArgumentException("Failed to detect FM network to peer to");
            }
        }
        return new FMNetwork(fmProjectId, fmNetwork, fmSubnetwork);
    }

    static class FMNetwork {
        final String projectId;
        final String network;
        final String subNetwork;

        public FMNetwork(String projectId, String network, String subNetwork) {
            this.projectId = projectId;
            this.network = network;
            this.subNetwork = subNetwork;
        }
    }
}

