/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.license;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.license.License;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.license.LicenseUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.io.File;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FMLicenseStatusService
implements LicenseStatusService {
    private License cachedLicense;
    private long cachedTS;
    private static Logger logger = Logger.getLogger((String)"dku.licensing");

    public synchronized LicenseStatusService.LicensingStatus getLicensingStatus() {
        try (DSSMetrics.TimeCtx c = DSSMetrics.timeCtx((String)"services.licenses.getLocalFile");){
            LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
            File f = new File(DKUApp.getBaseFolderF(), "config/license.json");
            if (!f.isFile()) {
                ls.hasLicense = false;
                ls.invalidMessage = "No license found";
                LicenseStatusService.LicensingStatus licensingStatus = ls;
                return licensingStatus;
            }
            long ts = f.lastModified();
            if (ts != this.cachedTS) {
                try {
                    this.cachedLicense = (License)JSON.parseFile((File)f, License.class);
                    this.cachedTS = ts;
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to read license file", (Throwable)e);
                    ls.invalidMessage = "Failed to parse license file. Please check logs.";
                    LicenseStatusService.LicensingStatus licensingStatus = ls;
                    if (c != null) {
                        c.close();
                    }
                    return licensingStatus;
                }
            }
            LicenseStatusService.LicensingStatus licensingStatus = this.getLicensingStatus(this.cachedLicense);
            return licensingStatus;
        }
    }

    public LicenseStatusService.LicensingStatus getLicensingStatus(License license) {
        LicenseStatusService.LicensingStatus ls = new LicenseStatusService.LicensingStatus();
        try {
            if (System.getenv("DKU_HA_LICENSE") == null) {
                LicenseUtils.verify((License)license);
            }
            ls.valid = true;
        }
        catch (Exception e) {
            logger.info((Object)"Validation failed", (Throwable)e);
            ls.invalidMessage = e.getMessage();
        }
        ls.licenseContent = (License.Content)JSON.deepCopy((Object)license.content);
        ls.sublicense = license.sublicense;
        ls.properties = ls.licenseContent.properties != null ? new Params(ls.licenseContent.properties) : new Params();
        this.checkExpiration(ls);
        return ls;
    }

    protected void checkExpiration(LicenseStatusService.LicensingStatus ls) {
        if (ls.licenseContent.expiresOn != null) {
            long now = System.currentTimeMillis();
            ls.expiresOn = ISODateTimeFormat.basicDate().parseMillis(ls.licenseContent.expiresOn);
            if (now > ls.expiresOn) {
                ls.expired = true;
                if (now - ls.expiresOn > 604800000L) {
                    ls.valid = false;
                    ls.invalidMessage = "License has expired";
                }
            }
        }
    }

    public void failIfLocked() {
        if (!this.getLicensingStatus().valid) {
            throw new SecurityException("License error. Action denied");
        }
    }
}

