/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.CloudStaticData;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettingsRepository;
import com.dataiku.fm.server.settings.SettingsDAO;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class FMApp
extends DKUApp {
    public static final boolean ENABLE_CLOUD_SIMULATOR = "true".equalsIgnoreCase(System.getenv("DKU_CLOUD_SIMULATOR"));

    public static void autoconfigure() {
        FMApp.ensureCorrectJavaVersionForDev();
        String dipHome = System.getenv("DIP_HOME");
        String installDir = System.getenv("DKUINSTALLDIR");
        if (dipHome != null && installDir != null) {
            FMApp.setBaseFolder((String)dipHome, (String)installDir);
            ProxyUtils.registerProxyAuthenticator(() -> FMApp.getFMSettingsUnsafe().proxySettings);
        }
    }

    public static FMSettings getFMSettingsUnsafe() {
        try {
            FMSettings ret = ((SettingsDAO)SpringUtils.getBean(SettingsDAO.class)).getUnsafeAutoTXN();
            if (ret == null) {
                return new FMSettings();
            }
            return ret;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static InstanceImagesSettings getInstanceImagesSettings(Cloud cloud) {
        try {
            return InstanceImagesSettingsRepository.of(cloud).getAll();
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static CloudStaticData getCloudStaticData(Cloud cloud) {
        try {
            if (DKUApp.getUserResourceFile((String[])new String[]{cloud.staticDataFilename}).isFile()) {
                return (CloudStaticData)JSON.parseFile((File)DKUApp.getUserResourceFile((String[])new String[]{cloud.staticDataFilename}), CloudStaticData.class);
            }
            return (CloudStaticData)JSON.parseFile((File)DKUApp.getResourceFile((String)cloud.staticDataFilename), CloudStaticData.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static DevAgentBundle getDevAgentCode() {
        File libAgentDevFolder = DKUApp.getFile((String[])new String[]{"lib", "agent", "dev"});
        File agentZip = new File(libAgentDevFolder, "dataikufmagent.zip");
        if (agentZip.exists() && agentZip.isFile()) {
            DevAgentBundle ret = new DevAgentBundle();
            ret.exists = true;
            ret.hash = DKUtils.md5Base64((String)(agentZip.getName() + "/" + agentZip.length() + "/" + agentZip.lastModified()));
            return ret;
        }
        return new DevAgentBundle();
    }

    public static void streamDevAgentCode(String hash, HttpServletResponse resp) throws IOException {
        block14: {
            try {
                File libAgentDevFolder = DKUApp.getFile((String[])new String[]{"lib", "agent", "dev"});
                File agentZip = new File(libAgentDevFolder, "dataikufmagent.zip");
                if (agentZip.exists() && agentZip.isFile()) {
                    String fileHash = DKUtils.md5Base64((String)(agentZip.getName() + "/" + agentZip.length() + "/" + agentZip.lastModified()));
                    if (!StringUtils.equals((String)hash, (String)fileHash)) {
                        throw new IllegalArgumentException("Hash mismatch");
                    }
                    resp.setContentType("application/zip");
                    resp.setHeader("Content-Disposition", "inline; filename=\"dataikufmagent.zip\"");
                    resp.setStatus(200);
                    try (BufferedOutputStream bos = new BufferedOutputStream((OutputStream)resp.getOutputStream());
                         FileInputStream input = new FileInputStream(agentZip);){
                        IOUtils.copy((InputStream)input, (OutputStream)bos);
                        break block14;
                    }
                }
                throw new IllegalArgumentException("No dev bundle to send");
            }
            catch (Exception e) {
                resp.setStatus(404);
                resp.getWriter().write("Can't send bundle: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
        }
    }

    public static boolean isCloudProxyEnabled() {
        return FMApp.isCloudProxyEnabled(FMApp.getFMSettingsUnsafe());
    }

    public static boolean isCloudProxyEnabled(FMSettings fmSettings) {
        return FMApp.getProperty((String)"dku.fm.proxifyCloudRequests", null) != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)fmSettings.proxySettings.host);
    }

    public boolean isCloudProxyEnabledWrapper(FMSettings fmSettings) {
        return FMApp.isCloudProxyEnabled(fmSettings);
    }

    public FMSettings getFMSettings() {
        return FMApp.getFMSettingsUnsafe();
    }

    public boolean isSSLVerificationDisabled() {
        return false;
    }

    public static class DevAgentBundle {
        public boolean exists;
        public String hash;
    }
}

