/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.accounts;

import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.fm.cloud.CloudCredentialsTestService;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudAccountDTO;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class CloudAccountsService {
    private static final String HIDDEN_SECRET = "************";
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private CloudCredentialsTestService cloudCredentialsTestService;

    public CloudAccountDTO convertToDto(Tenant tenant, CloudAccount account) {
        CloudAccountDTO cloudCredentialsDTO = new CloudAccountDTO();
        cloudCredentialsDTO.id = account.getId();
        cloudCredentialsDTO.label = account.getLabel();
        cloudCredentialsDTO.description = account.getDescription();
        cloudCredentialsDTO.cloudTags = CloudTagList.fromJSON(account.getCloudTags());
        if (account.getAwsAuthenticationMode() != null) {
            cloudCredentialsDTO.authenticationMode = account.getAwsAuthenticationMode().name();
        }
        if (account.getAzureAuthenticationMode() != null) {
            cloudCredentialsDTO.authenticationMode = account.getAzureAuthenticationMode().name();
        }
        if (account.getGcpAuthenticationMode() != null) {
            cloudCredentialsDTO.authenticationMode = account.getGcpAuthenticationMode().name();
        }
        cloudCredentialsDTO.awsAuthenticationMode = account.getAwsAuthenticationMode();
        cloudCredentialsDTO.awsIAMRoleExternalId = StringUtils.isNotEmpty((String)account.getAwsIAMRoleExternalId()) ? HIDDEN_SECRET : "";
        cloudCredentialsDTO.awsIAMRoleARN = account.getAwsIAMRoleARN();
        cloudCredentialsDTO.awsAccessKeyId = account.getAwsAccessKeyId();
        cloudCredentialsDTO.awsSecretAccessKey = StringUtils.isNotBlank((String)account.getAwsSecretAccessKey()) ? HIDDEN_SECRET : "";
        cloudCredentialsDTO.azureAuthenticationMode = account.getAzureAuthenticationMode();
        cloudCredentialsDTO.azureEnvironment = account.getAzureEnvironment();
        cloudCredentialsDTO.azureSubscription = account.getAzureSubscription();
        cloudCredentialsDTO.azureTenantId = account.getAzureTenantId();
        cloudCredentialsDTO.azureManagedIdentityId = account.getAzureManagedIdentityId();
        cloudCredentialsDTO.azureClientId = account.getAzureClientId();
        cloudCredentialsDTO.azureCertificatePath = account.getAzureCertificatePath();
        cloudCredentialsDTO.azureCertificatePassword = account.getAzureCertificatePassword();
        cloudCredentialsDTO.azureClientId = account.getAzureClientId();
        cloudCredentialsDTO.azureSecret = StringUtils.isNotBlank((String)account.getAzureSecret()) ? HIDDEN_SECRET : "";
        cloudCredentialsDTO.azureFMAppClientId = FMApp.getFMSettingsUnsafe().azureSettings.clientId;
        cloudCredentialsDTO.azureImageResourceGroup = account.getAzureImageResourceGroup();
        cloudCredentialsDTO.gcpAuthenticationMode = account.getGcpAuthenticationMode();
        cloudCredentialsDTO.gcpProjectId = account.getGcpProjectId();
        cloudCredentialsDTO.gcpServiceAccountKey = StringUtils.isNotBlank((String)account.getGcpServiceAccountKeyOrKeyPath()) ? HIDDEN_SECRET : "";
        cloudCredentialsDTO.nbNetworks = this.dbService.getSingleResult(Long.class, "SELECT count(*) from virtualnetwork vn where vn.tenant=?1 and vn.cloudAccount=?2", tenant, account).intValue();
        return cloudCredentialsDTO;
    }

    public List<CloudAccount> getAccounts(Tenant tenant) {
        return this.dbService.listResults(CloudAccount.class, "SELECT a from cloudaccount a where a.tenant=?1", tenant);
    }

    public List<CloudAccountDTO> list(Tenant tenant) {
        return this.getAccounts(tenant).stream().map(cloudAccount -> this.convertToDto(tenant, (CloudAccount)cloudAccount)).collect(Collectors.toList());
    }

    public CloudAccountDTO getAccountDTO(Tenant tenant, String accountId) {
        return this.convertToDto(tenant, this.getAccountMandatory(tenant, accountId));
    }

    public CloudAccount getAccountMandatory(Tenant tenant, String accountId) {
        CloudAccount cloudAccount = this.dbService.getSingleResult(CloudAccount.class, "SELECT a from cloudaccount a where a.id=?1 AND a.tenant=?2", accountId, tenant);
        if (cloudAccount == null) {
            throw new IllegalArgumentException(String.format("Unknown account: accountId=%s", accountId));
        }
        return cloudAccount;
    }

    public CloudAccountDTO create(Tenant tenant, CloudAccountDTO dto) throws Exception {
        CloudAccount account = new CloudAccount();
        account.setId("account-" + SecretKeyGenerator.generate((int)12));
        account.setTenant(tenant);
        this.assignFromDto(account, dto);
        this.cloudCredentialsTestService.testCredentials(tenant, dto);
        try (DatabaseAccessService.ReadWriteTransaction t = this.dbService.rwTransaction();){
            t.getThreadEM().persist((Object)account);
            t.commit();
        }
        return this.convertToDto(tenant, account);
    }

    public CommandResult delete(Tenant tenant, String accountId) {
        CloudAccount account = this.getAccountMandatory(tenant, accountId);
        if (account == null) {
            throw new IllegalArgumentException("Account does not exists. It may have already been deleted.");
        }
        int nbNetworks = this.dbService.getSingleResult(Long.class, "SELECT count(*) from virtualnetwork vn where vn.tenant=?1 and vn.cloudAccount=?2", tenant, account).intValue();
        if (nbNetworks > 0) {
            throw new IllegalArgumentException("Account still in use by some networks. It cannot be deleted.");
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            rwt.getThreadEM().remove((Object)account);
            rwt.commit();
        }
        return CommandResult.withSuccess(true);
    }

    public CloudAccountDTO save(Tenant tenant, CloudAccountDTO dto) throws Exception {
        CloudAccount account = this.getAccountMandatory(tenant, dto.id);
        if (account == null) {
            throw new IllegalArgumentException(String.format("Unknown account: accountId=%s", dto.id));
        }
        this.setupSecretsIfNeeded(account, dto);
        this.cloudCredentialsTestService.testCredentials(tenant, dto);
        this.assignFromDto(account, dto);
        try (DatabaseAccessService.ReadWriteTransaction t = this.dbService.rwTransaction();){
            t.getThreadEM().persist((Object)account);
            t.commit();
        }
        return this.convertToDto(tenant, account);
    }

    public boolean updateEncryption(CloudAccount account, Tenant current, Tenant updated) {
        boolean wasEncryptionEnabled = this.cryptoService.isAbleToEncrypt(current);
        boolean isNowEncryptionEnabled = this.cryptoService.isAbleToEncrypt(updated);
        if (wasEncryptionEnabled) {
            if (StringUtils.isNotBlank((String)account.getAwsSecretAccessKey())) {
                account.setAwsSecretAccessKey(account.getAwsSecretAccessKey());
            }
            if (StringUtils.isNotBlank((String)account.getAwsIAMRoleExternalId())) {
                account.setAwsIAMRoleExternalId(account.getAwsIAMRoleExternalId());
            }
            if (StringUtils.isNotBlank((String)account.getGcpServiceAccountKeyOrKeyPath())) {
                account.setGcpServiceAccountKey(account.getGcpServiceAccountKeyOrKeyPath());
            }
            if (StringUtils.isNotBlank((String)account.getAzureSecret())) {
                account.setAzureSecret(account.getAzureSecret());
            }
            if (StringUtils.isNotBlank((String)account.getAzureCertificatePassword())) {
                account.setAzureCertificatePassword(account.getAzureCertificatePassword());
            }
        }
        if (isNowEncryptionEnabled) {
            if (StringUtils.isNotBlank((String)account.getAwsSecretAccessKey())) {
                account.setAwsSecretAccessKey(this.cryptoService.encrypt(updated, account.getAwsSecretAccessKey()));
            }
            if (StringUtils.isNotBlank((String)account.getAwsIAMRoleExternalId())) {
                account.setAwsIAMRoleExternalId(this.cryptoService.encrypt(updated, account.getAwsIAMRoleExternalId()));
            }
            if (StringUtils.isNotBlank((String)account.getGcpServiceAccountKeyOrKeyPath())) {
                account.setGcpServiceAccountKey(this.cryptoService.encrypt(updated, account.getGcpServiceAccountKeyOrKeyPath()));
            }
            if (StringUtils.isNotBlank((String)account.getAzureSecret())) {
                account.setAzureSecret(this.cryptoService.encrypt(updated, account.getAzureSecret()));
            }
            if (StringUtils.isNotBlank((String)account.getAzureCertificatePassword())) {
                account.setAzureCertificatePassword(this.cryptoService.encrypt(updated, account.getAzureCertificatePassword()));
            }
        }
        return true;
    }

    private void setupSecretsIfNeeded(CloudAccount account, CloudAccountDTO dto) {
        boolean ableToEncrypt = this.cryptoService.isAbleToEncryptUsingTenantMasterKey();
        if (!StringUtils.isEmpty((String)dto.awsSecretAccessKey) && !this.checkNotMarker(dto.awsSecretAccessKey)) {
            dto.awsSecretAccessKey = ableToEncrypt ? this.cryptoService.decrypt(account.getTenant(), account.getAwsSecretAccessKey()) : account.getAwsSecretAccessKey();
        }
        if (!StringUtils.isEmpty((String)dto.awsIAMRoleExternalId) && !this.checkNotMarker(dto.awsIAMRoleExternalId)) {
            dto.awsIAMRoleExternalId = ableToEncrypt ? this.cryptoService.decrypt(account.getTenant(), account.getAwsIAMRoleExternalId()) : account.getAwsIAMRoleExternalId();
        }
        if (!StringUtils.isEmpty((String)dto.azureSecret) && !this.checkNotMarker(dto.azureSecret)) {
            dto.azureSecret = ableToEncrypt ? this.cryptoService.decrypt(account.getTenant(), account.getAzureSecret()) : account.getAzureSecret();
        }
        if (!StringUtils.isEmpty((String)dto.azureCertificatePassword) && !this.checkNotMarker(dto.azureCertificatePassword)) {
            dto.azureCertificatePassword = ableToEncrypt ? this.cryptoService.decrypt(account.getTenant(), account.getAzureCertificatePassword()) : account.getAzureCertificatePassword();
        }
        if (!StringUtils.isEmpty((String)dto.gcpServiceAccountKey) && !this.checkNotMarker(dto.gcpServiceAccountKey)) {
            dto.gcpServiceAccountKey = ableToEncrypt ? this.cryptoService.decrypt(account.getTenant(), account.getGcpServiceAccountKeyOrKeyPath()) : account.getGcpServiceAccountKeyOrKeyPath();
        }
    }

    private boolean checkNotMarker(String text) {
        return StringUtils.isNotBlank((String)text) && !text.replaceAll("\\*", "").isEmpty();
    }

    public CloudAccount toEntity(CloudAccountDTO dto, Tenant tenant) {
        CloudAccount cloudAccount = new CloudAccount();
        cloudAccount.setTenant(tenant);
        this.assignFromDto(cloudAccount, dto);
        return cloudAccount;
    }

    private void assignFromDto(CloudAccount account, CloudAccountDTO dto) {
        boolean ableToEncrypt = this.cryptoService.isAbleToEncryptUsingTenantMasterKey();
        account.setLabel(dto.label);
        account.setDescription(dto.description);
        account.setCloudTags(CloudTagList.toJSON(dto.cloudTags));
        account.setAwsAuthenticationMode(dto.awsAuthenticationMode);
        account.setAwsIAMRoleARN(dto.awsIAMRoleARN);
        account.setAwsAccessKeyId(dto.awsAccessKeyId);
        if (this.checkNotMarker(dto.awsSecretAccessKey)) {
            if (StringUtils.isNotEmpty((String)dto.awsSecretAccessKey)) {
                if (ableToEncrypt) {
                    account.setAwsSecretAccessKey(this.cryptoService.encrypt(account.getTenant(), dto.awsSecretAccessKey));
                } else {
                    account.setAwsSecretAccessKey(dto.awsSecretAccessKey);
                }
            } else if (ableToEncrypt && !account.isEncrypted() && StringUtils.isNotEmpty((String)account.getAwsSecretAccessKey())) {
                account.setAwsSecretAccessKey(this.cryptoService.encrypt(account.getTenant(), account.getAwsSecretAccessKey()));
            }
        }
        if (dto.awsAuthenticationMode == CloudAccount.AWSAuthenticationMode.IAM_ROLE && this.checkNotMarker(dto.awsIAMRoleExternalId)) {
            if (StringUtils.isNotEmpty((String)dto.awsIAMRoleExternalId)) {
                if (ableToEncrypt) {
                    account.setAwsIAMRoleExternalId(this.cryptoService.encrypt(account.getTenant(), dto.awsIAMRoleExternalId));
                } else {
                    account.setAwsIAMRoleExternalId(dto.awsIAMRoleExternalId);
                }
            } else if (ableToEncrypt && !account.isEncrypted() && StringUtils.isNotEmpty((String)account.getAwsIAMRoleExternalId())) {
                account.setAwsIAMRoleExternalId(this.cryptoService.encrypt(account.getTenant(), account.getAwsIAMRoleExternalId()));
            }
        } else if (StringUtils.isEmpty((String)dto.awsIAMRoleExternalId)) {
            account.setAwsIAMRoleExternalId(null);
        }
        account.setAzureAuthenticationMode(dto.azureAuthenticationMode);
        account.setAzureEnvironment(dto.azureEnvironment);
        account.setAzureSubscription(dto.azureSubscription);
        account.setAzureTenantId(dto.azureTenantId);
        account.setAzureManagedIdentityId(dto.azureManagedIdentityId);
        if (StringUtils.isBlank((String)dto.azureSubscription)) {
            account.setAzureSubscription(account.getTenant().getAzureSubscription());
        }
        if (StringUtils.isNotEmpty((String)dto.azureManagedIdentityId)) {
            String id = dto.azureManagedIdentityId;
            int prefixSize = "/subscriptions/".length();
            String subscription = id.substring(prefixSize, id.indexOf(47, prefixSize));
            account.setAzureSubscription(subscription);
        }
        account.setAzureClientId(dto.azureClientId);
        if (this.checkNotMarker(dto.azureSecret)) {
            if (StringUtils.isNotEmpty((String)dto.azureSecret)) {
                if (ableToEncrypt) {
                    account.setAzureSecret(this.cryptoService.encrypt(account.getTenant(), dto.azureSecret));
                } else {
                    account.setAzureSecret(dto.azureSecret);
                }
            } else if (ableToEncrypt && !account.isEncrypted() && StringUtils.isNotEmpty((String)account.getAzureSecret())) {
                account.setAzureSecret(this.cryptoService.encrypt(account.getTenant(), account.getAzureSecret()));
            }
        }
        account.setAzureCertificatePath(dto.azureCertificatePath);
        if (this.checkNotMarker(dto.azureCertificatePassword)) {
            if (StringUtils.isNotEmpty((String)dto.azureCertificatePassword)) {
                if (ableToEncrypt) {
                    account.setAzureCertificatePassword(this.cryptoService.encrypt(account.getTenant(), dto.azureCertificatePassword));
                } else {
                    account.setAzureCertificatePassword(dto.azureCertificatePassword);
                }
            } else if (ableToEncrypt && !account.isEncrypted() && StringUtils.isNotEmpty((String)account.getAzureCertificatePassword())) {
                account.setAzureCertificatePassword(this.cryptoService.encrypt(account.getTenant(), account.getAzureCertificatePassword()));
            }
        }
        account.setAzureImageResourceGroup(dto.azureImageResourceGroup);
        account.setGcpAuthenticationMode(dto.gcpAuthenticationMode);
        account.setGcpProjectId(dto.gcpProjectId);
        if (this.checkNotMarker(dto.gcpServiceAccountKey)) {
            if (StringUtils.isNotEmpty((String)dto.gcpServiceAccountKey)) {
                if (ableToEncrypt) {
                    account.setGcpServiceAccountKey(this.cryptoService.encrypt(account.getTenant(), dto.gcpServiceAccountKey));
                } else {
                    account.setGcpServiceAccountKey(dto.gcpServiceAccountKey);
                }
            } else if (ableToEncrypt && !account.isEncrypted() && StringUtils.isNotEmpty((String)account.getGcpServiceAccountKeyOrKeyPath())) {
                account.setGcpServiceAccountKey(this.cryptoService.encrypt(account.getTenant(), account.getGcpServiceAccountKeyOrKeyPath()));
            }
        }
        account.setEncrypted(true);
    }
}

