/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.futures.FMFutureThread;
import com.dataiku.fm.server.core.FMFutureResponse;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMFutureService
extends NoRemoteFutureService {
    @Autowired
    private DatabaseAccessService dbService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.futures.fm");

    public synchronized <T> FMFutureResponse<T> getUpdate(String jobId) throws Exception {
        if (!this.runningJobs.containsKey(jobId)) {
            logger.warn((Object)String.format("JobID not found: %s. Running jobs: %s", jobId, JSON.json(this.runningJobs.keySet())));
            throw ErrorContext.iaef((String)"JobID not found : %s.", (Object)jobId, (Object[])new Object[0]);
        }
        return this.toFMFutureResponse((FMFutureThread)((Object)this.runningJobs.get(jobId)), true);
    }

    public synchronized List<FMFutureResponse> getUpdates() {
        return this.runningJobs.values().stream().filter(f -> f instanceof FMFutureThread).map(f -> this.toFMFutureResponse((FMFutureThread)((Object)f), false)).collect(Collectors.toList());
    }

    public synchronized <T> FutureResponse<T> getProgress(String jobId) {
        FMFutureThread ft = (FMFutureThread)((Object)this.runningJobs.get(jobId));
        if (ft == null) {
            return null;
        }
        return this.toFMFutureResponse(ft, false);
    }

    private <T> FMFutureResponse<T> toFMFutureResponse(FMFutureThread<?> ft, boolean rethrowException) {
        FMFutureResponse fr = new FMFutureResponse();
        fr.jobId = ft.jobId;
        fr.action = ft.action;
        fr.sourceObjectId = ft.sourceObjectId;
        fr.type = ft.type;
        fr.startTime = ft.creationTime;
        fr.runningTime = (ft.finishTime > 0L ? ft.finishTime : System.currentTimeMillis()) - ft.creationTime;
        fr.tenantId = ft.tenantId;
        if (ft.isAlive()) {
            fr.alive = true;
            fr.hasResult = false;
            fr.jobId = ft.jobId;
            fr.progress = ft.getProgressSnapshot();
            fr.log = ft.getLog();
            fr.fekPort = ft.getUsedFekPort();
        } else {
            fr.alive = false;
            fr.aborted = ft.aborted;
            fr.log = ft.getLog();
            if (!ft.aborted && ft.storedException != null) {
                if (rethrowException) {
                    throw new RuntimeException(ft.storedException);
                }
                fr.exception = ft.storedException;
            } else if (!ft.aborted && ft.storedError != null) {
                if (rethrowException) {
                    throw ft.storedError;
                }
                fr.exception = ft.storedError;
            } else {
                fr.hasResult = true;
                fr.result = ft.getResult();
            }
        }
        return fr;
    }
}

