/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.core;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.ProtoVirtualNetworkDTO;
import com.dataiku.fm.model.published.VirtualNetworkSettingsDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VirtualNetworksController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private VirtualNetworksService virtualNetworksService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudAccountsService cloudAccountsService;

    @RequestMapping(value={"/api/ui/virtual-networks/start-create"})
    public void startCreate(HttpServletRequest req, HttpServletResponse resp, @RequestParam String virtualNetwork) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        ProtoVirtualNetworkDTO dto = (ProtoVirtualNetworkDTO)JSON.parse((String)virtualNetwork, ProtoVirtualNetworkDTO.class);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, this.virtualNetworksService.startCreate(authCtx, dto));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/list"})
    public void listVirtualNetworks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, this.virtualNetworksService.list(tenant));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/get-default-values"})
    public void getDefaultCreationValues(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, (Object)this.virtualNetworksService.getDefaultCreationValues(tenant));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/get"})
    public void getVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @RequestParam String virtualNetworkId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, (Object)this.virtualNetworksService.getVirtualNetworkDTO(tenant, virtualNetworkId));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/cloud-account/get"})
    public void getVirtualNetworkCloudAccount(HttpServletRequest req, HttpServletResponse resp, @RequestParam String virtualNetworkId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)virtualNetworkId);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.convertToDto(tenant, vn.getCloudAccount()));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/save"})
    public void saveVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @RequestParam String virtualNetwork) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        VirtualNetworkSettingsDTO dto = (VirtualNetworkSettingsDTO)JSON.parse((String)virtualNetwork, VirtualNetworkSettingsDTO.class);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, (Object)this.virtualNetworksService.saveVirtualNetwork(authCtx, tenant, dto.id, dto));
    }

    @RequestMapping(value={"/api/ui/virtual-networks/start-delete"})
    public void startDeleteVirtualNetwork(HttpServletRequest req, HttpServletResponse resp, @RequestParam String virtualNetworkId, @RequestParam boolean deleteAutogeneratedSecurityGroups, @RequestParam boolean deleteAutogeneratedPeering) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        VirtualNetworksController.writeJSON((HttpServletResponse)resp, this.virtualNetworksService.startDelete(authCtx, virtualNetworkId, deleteAutogeneratedSecurityGroups, deleteAutogeneratedPeering));
    }
}

