/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.db;

import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DatabaseAccessService {
    protected EntityManagerFactory emf;
    private ThreadLocal<EntityManager> emtl = new ThreadLocal();
    private static Logger logger = Logger.getLogger((String)"com.dataiku.fm.dbaccess");

    @PostConstruct
    public void init() {
        this.emf = Persistence.createEntityManagerFactory((String)"PU", this.getPersistenceProperties());
    }

    private Map<String, String> getPersistenceProperties() {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("hibernate.dialect", settings.databaseSettings.dbDialect);
        p.put("hibernate.connection.driver_class", settings.databaseSettings.dbDriver);
        p.put("hibernate.connection.url", settings.databaseSettings.dbURL);
        if (settings.databaseSettings.schema != null) {
            p.put("hibernate.default_schema", settings.databaseSettings.schema);
        }
        p.put("hibernate.id.new_generator_mappings", "true");
        p.put("javax.persistence.jdbc.url", settings.databaseSettings.dbURL);
        p.put("javax.persistence.jdbc.driver_class", settings.databaseSettings.dbDriver);
        return p;
    }

    private void threadBegin() {
        EntityManager em = this.getThreadEM();
        logger.debug((Object)("Begin on EM" + String.valueOf(em)));
        assert (!em.getTransaction().isActive());
        em.getTransaction().begin();
    }

    private void threadCommit() {
        EntityManager em = this.getThreadEM();
        logger.debug((Object)("Commit on EM" + String.valueOf(em)));
        em.getTransaction().commit();
    }

    private void threadRollbackIfActive() {
        EntityManager em = this.getThreadEM();
        if (em.getTransaction().isActive()) {
            logger.debug((Object)("Rollback on EM" + String.valueOf(em)));
            em.getTransaction().rollback();
        }
    }

    public ReadWriteTransaction rwTransaction() {
        return new ReadWriteTransaction();
    }

    public EntityManager getThreadEM() {
        if (this.emtl.get() == null) {
            this.emtl.set(this.emf.createEntityManager());
        }
        return this.emtl.get();
    }

    public void close() {
        EntityManager entityManager = this.emtl.get();
        if (entityManager != null) {
            entityManager.close();
            this.emtl.remove();
        }
    }

    public <T> T getSingleResult(Class<T> type, String query, Object ... params) {
        TypedQuery q = this.getThreadEM().createQuery(query, type);
        for (int i = 0; i < params.length; ++i) {
            q.setParameter(i + 1, params[i]);
        }
        List resultList = q.getResultList();
        int size = resultList.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new IllegalArgumentException("Expected a single result");
        }
        return (T)resultList.get(0);
    }

    public <T> List<T> listResults(Class<T> type, String query, Object ... params) {
        return this.listResults(type, null, query, params);
    }

    public <T> List<T> listResults(Class<T> type, Integer maxResult, String query, Object ... params) {
        TypedQuery q = this.getThreadEM().createQuery(query, type);
        if (maxResult != null) {
            q.setMaxResults(maxResult.intValue());
        }
        for (int i = 0; i < params.length; ++i) {
            q.setParameter(i + 1, params[i]);
        }
        return q.getResultList();
    }

    public class ReadWriteTransaction
    implements AutoCloseable {
        public ReadWriteTransaction() {
            DatabaseAccessService.this.threadBegin();
        }

        public EntityManager getThreadEM() {
            return DatabaseAccessService.this.getThreadEM();
        }

        public void commit() {
            DatabaseAccessService.this.threadCommit();
        }

        @Override
        public void close() {
            DatabaseAccessService.this.threadRollbackIfActive();
        }
    }
}

