/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.cloud.CloudDNSservice;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.BlueprintsService;
import com.dataiku.fm.server.instances.CreationDataUtils;
import com.dataiku.fm.server.instances.InstancesController;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class BlueprintsController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private BlueprintsService blueprintsService;
    @Autowired
    private CloudDNSservice cloudDNSservice;

    @RequestMapping(value={"/api/ui/blueprints/deploy"})
    public void deployBlueprint(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintRequest) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        BlueprintsService.BlueprintDeploymentRequest request = (BlueprintsService.BlueprintDeploymentRequest)JSON.parse((String)blueprintRequest, BlueprintsService.BlueprintDeploymentRequest.class);
        List hostnames = Stream.of(request.settings.designHostnameMapping, request.settings.deployerHostnameMapping, request.settings.automationHostnameMapping, request.settings.adminHostnameMapping).filter(Objects::nonNull).collect(Collectors.toList());
        Set duplicatedHostnames = hostnames.stream().filter(i -> Collections.frequency(hostnames, i) > 1).collect(Collectors.toSet());
        if (duplicatedHostnames.size() > 0) {
            throw new IllegalArgumentException("Can't use the same hostname(s) twice: '" + duplicatedHostnames.stream().collect(Collectors.joining("', '")) + "'");
        }
        BlueprintsController.writeJSON((HttpServletResponse)resp, this.blueprintsService.deploy(authCtx, request));
    }

    @RequestMapping(value={"/api/ui/blueprints/get-networks"})
    public void getNetworks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        CreationDataUtils.InstanceCreationData ret = new CreationDataUtils.InstanceCreationData();
        Tenant tenant = (Tenant)dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        for (VirtualNetwork vn : dbService.listResults(VirtualNetwork.class, "SELECT vn from virtualnetwork vn where vn.tenant=?1", tenant)) {
            List<LogicalInstance> instanceList = dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.virtualNetwork=?1", vn);
            if (instanceList.size() > 0) continue;
            String publicDnsZone = this.cloudDNSservice.getPublicDNSZoneDomain(vn);
            String privateDnsZone = this.cloudDNSservice.getPrivateDNSZoneDomain(vn);
            ret.virtualNetworks.add(new InstancesController.VirtualNetworkSummary(vn.getLabel(), vn.getId(), vn.getHttpsStrategy(), vn.getHttpStrategy(), vn.getAwsSecondSubnetId() != null, publicDnsZone, privateDnsZone, vn.getDnsStrategy()));
        }
        BlueprintsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }
}

