/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.fm.cloud.CloudDNSservice;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Sublicense;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.model.published.PublicProtoLogicalInstance;
import com.dataiku.fm.model.settings.Cloud;
import com.dataiku.fm.model.settings.CloudStaticData;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.model.settings.InstanceImagesSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.core.VirtualNetworksService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.instances.InstancesController;
import java.util.ArrayList;
import java.util.List;

public class CreationDataUtils {
    public static final int DEFAULT_ROOT_VOLUME_SIZE_GB = 32;
    public static final int DEFAULT_AWS_DATA_VOLUME_SIZE_GB = 200;
    public static final int DEFAULT_AWS_DATA_VOLUME_SIZE_MAX_GB = 2000;
    public static final int DEFAULT_AZURE_DATA_VOLUME_SIZE_GB = 1000;
    public static final int DEFAULT_GCP_DATA_VOLUME_SIZE_GB = 200;
    public static final int DEFAULT_GCP_DATA_VOLUME_SIZE_MAX_GB = 2000;
    public static final String DEFAULT_AZURE_DATA_VOLUME_TYPE = "StandardSSD_LRS";
    public static final String DEFAULT_GCP_DATA_VOLUME_TYPE = "pd-ssd";
    public static final String DEFAULT_AWS_DATA_VOLUME_TYPE = "gp2";
    public static final int DEFAULT_SNAPSHOT_PERIOD = 24;
    public static final int DEFAULT_SNAPSHOT_RETENTION = 30;

    public static InstanceCreationData getInstanceCreationData(String tenantId) {
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        InstanceSettingsTemplateCRUDService istCRUDService = (InstanceSettingsTemplateCRUDService)SpringUtils.getBean(InstanceSettingsTemplateCRUDService.class);
        DatabaseAccessService dbService = (DatabaseAccessService)SpringUtils.getBean(DatabaseAccessService.class);
        CloudDNSservice cloudDNSservice = (CloudDNSservice)SpringUtils.getBean(CloudDNSservice.class);
        InstanceCreationData ret = new InstanceCreationData();
        for (InstanceSettingsTemplateDTO instanceSettingsTemplateDTO : istCRUDService.list(tenantId)) {
            if (instanceSettingsTemplateDTO.id.startsWith("ist-snap")) continue;
            ret.instanceSettingsTemplates.add(new InstancesController.IdAndLabel(instanceSettingsTemplateDTO.id, instanceSettingsTemplateDTO.label));
        }
        Tenant tenant = (Tenant)dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        block22: for (VirtualNetwork vn : VirtualNetworksService.getNetworks(tenant, dbService)) {
            String string = cloudDNSservice.getPublicDNSZoneDomain(vn);
            String privateDnsZone = cloudDNSservice.getPrivateDNSZoneDomain(vn);
            switch (settings.cloud) {
                case AWS: {
                    ret.virtualNetworks.add(new InstancesController.VirtualNetworkSummary(vn.getLabel(), vn.getId(), vn.getHttpsStrategy(), vn.getHttpStrategy(), vn.getAwsSecondSubnetId() != null, string, privateDnsZone, vn.getDnsStrategy()));
                    continue block22;
                }
            }
            ret.virtualNetworks.add(new InstancesController.VirtualNetworkSummary(vn.getLabel(), vn.getId(), vn.getHttpsStrategy(), vn.getHttpStrategy(), true, string, privateDnsZone, vn.getDnsStrategy()));
        }
        for (Sublicense sl : dbService.listResults(Sublicense.class, "SELECT sl from sublicense sl where sl.tenant.id=?1", tenantId)) {
            ret.sublicenses.add(new InstancesController.SublicenseSummary(sl.getLabel(), sl.getId()));
        }
        CloudStaticData cloudStaticData = FMApp.getCloudStaticData(settings.cloud);
        ret.dataVolumeTypes = cloudStaticData.dataVolumeSettings.volumeTypes;
        ret.defaultDataVolumeType = cloudStaticData.dataVolumeSettings.defaultVolumeType;
        ret.defaultDataVolumeSizeGB = cloudStaticData.dataVolumeSettings.defaultVolumeSizeGB;
        ret.defaultDataVolumeSizeMaxGB = cloudStaticData.dataVolumeSettings.defaultVolumeSizeMaxGB;
        ret.defaultDataVolumeIOPS = cloudStaticData.dataVolumeSettings.defaultVolumeIOPS;
        if (ret.defaultDataVolumeType == null) {
            switch (settings.cloud) {
                case AWS: {
                    ret.defaultDataVolumeType = DEFAULT_AWS_DATA_VOLUME_TYPE;
                    break;
                }
                case AZURE: {
                    ret.defaultDataVolumeType = DEFAULT_AZURE_DATA_VOLUME_TYPE;
                    break;
                }
                case GCP: {
                    ret.defaultDataVolumeType = DEFAULT_GCP_DATA_VOLUME_TYPE;
                }
            }
        }
        if (ret.defaultDataVolumeSizeGB == 0) {
            switch (settings.cloud) {
                case AWS: {
                    ret.defaultDataVolumeSizeGB = 200;
                    break;
                }
                case AZURE: {
                    ret.defaultDataVolumeSizeGB = 1000;
                    break;
                }
                case GCP: {
                    ret.defaultDataVolumeSizeGB = 200;
                }
            }
        }
        if (ret.defaultDataVolumeSizeMaxGB == 0) {
            switch (settings.cloud) {
                case AWS: {
                    ret.defaultDataVolumeSizeMaxGB = 2000;
                    break;
                }
                case AZURE: {
                    break;
                }
                case GCP: {
                    ret.defaultDataVolumeSizeMaxGB = 2000;
                }
            }
        }
        if (ret.defaultRootVolumeSizeGB == null) {
            switch (settings.cloud) {
                case AWS: 
                case AZURE: {
                    ret.defaultRootVolumeSizeGB = 32;
                    break;
                }
            }
        }
        for (CloudStaticData.CloudInstanceType cloudInstanceType : cloudStaticData.instanceTypesSettings.cloudInstanceTypes) {
            ret.cloudInstanceTypes.add(new InstancesController.IdAndLabel(cloudInstanceType.id, cloudInstanceType.label));
        }
        ret.defaultCloudInstanceType = cloudStaticData.instanceTypesSettings.defaultCloudInstanceType;
        for (InstanceImagesSettings.InstanceImage instanceImage : FMApp.getInstanceImagesSettings((Cloud)settings.cloud).images) {
            ret.dssImages.add(new InstancesController.IdAndLabel(instanceImage.id, instanceImage.label));
        }
        ret.defaultImageId = FMApp.getInstanceImagesSettings((Cloud)settings.cloud).defaultImageId;
        return ret;
    }

    public static NetworkCreationData getNetworkCreationData(Tenant tenant) {
        CloudAccountsService cloudAccountsService = (CloudAccountsService)SpringUtils.getBean(CloudAccountsService.class);
        NetworkCreationData data = new NetworkCreationData();
        for (CloudAccount cloudAccount : cloudAccountsService.getAccounts(tenant)) {
            data.accounts.add(new InstancesController.IdAndLabel(cloudAccount.getId(), cloudAccount.getLabel()));
        }
        return data;
    }

    public static class InstanceCreationData {
        public List<InstancesController.IdAndLabel> instanceSettingsTemplates = new ArrayList<InstancesController.IdAndLabel>();
        public List<InstancesController.VirtualNetworkSummary> virtualNetworks = new ArrayList<InstancesController.VirtualNetworkSummary>();
        public List<InstancesController.SublicenseSummary> sublicenses = new ArrayList<InstancesController.SublicenseSummary>();
        public List<InstancesController.IdAndLabel> dataVolumeTypes = new ArrayList<InstancesController.IdAndLabel>();
        public String defaultDataVolumeType;
        public int defaultDataVolumeSizeGB;
        public int defaultDataVolumeSizeMaxGB;
        public int defaultDataVolumeIOPS;
        public Integer defaultRootVolumeSizeGB;
        public PublicProtoLogicalInstance.VolumeEncryptionMode defaultVolumesEncryptionMode = PublicProtoLogicalInstance.VolumeEncryptionMode.DEFAULT_KEY;
        public List<InstancesController.IdAndLabel> cloudInstanceTypes = new ArrayList<InstancesController.IdAndLabel>();
        public String defaultCloudInstanceType;
        public List<InstancesController.IdAndLabel> dssImages = new ArrayList<InstancesController.IdAndLabel>();
        public String defaultImageId;
        public boolean defaultEnableAutomatedSnapshot = true;
        public int defaultAutomatedSnapshotPeriod = 24;
        public int defaultAutomatedSnapshotRetention = 30;
    }

    public static class NetworkCreationData {
        public List<InstancesController.IdAndLabel> accounts = new ArrayList<InstancesController.IdAndLabel>();
    }
}

