/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.cloud.PhysicalInstanceCloudState;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.db.DataVolumeSnapshot;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.db.PhysicalInstanceCreationState;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.model.published.UpdateAction;
import com.dataiku.fm.model.published.UpdateInstanceSettingsTemplateResult;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateUpdater;
import com.dataiku.fm.server.instances.JSonHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class InstanceSettingsTemplateCRUDService {
    public static final String SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY = "privateKey";
    public static final String SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_ALIAS = "alias";
    public static final String SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_STORAGE_MODE = "storageMode";
    public static final String SETUP_ACTION_ADD_SSH_KEY_PARAM_VALUE_STORAGE_MODE_INLINE = "INLINE_ENCRYPTED";
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudCryptoService cryptoService;
    @Autowired
    private CloudInstanceService cloudInstanceService;

    public List<InstanceSettingsTemplateDTO> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        ArrayList<InstanceSettingsTemplateDTO> result = new ArrayList<InstanceSettingsTemplateDTO>();
        List<InstanceSettingsTemplate> templates = this.dbService.listResults(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.tenant=?1", tenant);
        for (InstanceSettingsTemplate ist : templates) {
            result.add(this.convertToDTOAndEnrich(ist));
        }
        return result;
    }

    public InstanceSettingsTemplateDTO get(String tenantId, String istId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        InstanceSettingsTemplate ist = this.dbService.getSingleResult(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.tenant=?1 AND ist.id=?2", tenant, istId);
        if (ist == null) {
            throw new IllegalArgumentException("Instance template does not exists. It may have been deleted.");
        }
        return this.convertToDTOAndEnrich(ist);
    }

    public static List<SetupAction> getHiddenSetupActions(String dssNodeType) {
        ArrayList<SetupAction> ret = new ArrayList<SetupAction>();
        if (!"apideployer".equalsIgnoreCase(dssNodeType)) {
            ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_GRAPHICS_EXPORT));
        }
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_RUNTIME_DATABASE));
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_MEMORY_SETTINGS));
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_MUS_AUTOCREATE));
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_UI_CUSTOMIZATION));
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_INSTANCE_NAME));
        ret.add(new SetupAction(SetupAction.SetupActionType.SETUP_SECURE_COOKIES));
        ret.add(new SetupAction(SetupAction.SetupActionType.UPDATE_DSS_PORT));
        return ret;
    }

    public InstanceSettingsTemplateDTO create(AuthCtx authCtx, String tenantId, InstanceSettingsTemplateDTO dto) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            InstanceSettingsTemplate ist = new InstanceSettingsTemplate();
            if (dto.forcedID == null) {
                ist.setId("ist-" + SecretKeyGenerator.generate((int)12));
            } else {
                ist.setId(dto.forcedID);
            }
            ist.setTenant(tenant);
            InstanceSettingsTemplateUpdater instanceSettingsTemplateUpdater = new InstanceSettingsTemplateUpdater(this.cryptoService, ist);
            this.encryptAddSSHKeyPrivateKey(dto, tenant);
            instanceSettingsTemplateUpdater.update(authCtx, tenant, dto);
            rwt.getThreadEM().persist((Object)ist);
            rwt.commit();
            InstanceSettingsTemplateDTO instanceSettingsTemplateDTO = this.convertToDTOAndEnrich(ist);
            return instanceSettingsTemplateDTO;
        }
    }

    public UpdateInstanceSettingsTemplateResult update(AuthCtx authCtx, String tenantId, InstanceSettingsTemplateDTO dto) {
        List<UpdateInstanceSettingsTemplateResult.LogicalInstanceRef> impactedInstances;
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        InstanceSettingsTemplate ist = this.dbService.getSingleResult(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.tenant=?1 AND ist.id=?2", tenant, dto.id);
        if (ist == null) {
            throw new IllegalArgumentException("Unknown IST: " + dto.id);
        }
        InstanceSettingsTemplateUpdater updater = new InstanceSettingsTemplateUpdater(this.cryptoService, ist);
        this.encryptAddSSHKeyPrivateKey(dto, tenant);
        updater.update(authCtx, tenant, dto);
        this.dbService.getThreadEM().persist((Object)ist);
        UpdateInstanceSettingsTemplateResult result = new UpdateInstanceSettingsTemplateResult();
        result.ist = this.convertToDTOAndEnrich(ist);
        if (updater.requiresAction != UpdateAction.NO_ACTION_REQUIRED && !(impactedInstances = this.computeImpactedInstances(updater.requiresAction, ist)).isEmpty()) {
            result.requiredAction = updater.requiresAction;
            result.impactedInstances = impactedInstances;
        }
        return result;
    }

    private List<UpdateInstanceSettingsTemplateResult.LogicalInstanceRef> computeImpactedInstances(UpdateAction requiresAction, InstanceSettingsTemplate ist) {
        ArrayList<PhysicalInstance> impactedInstances = new ArrayList<PhysicalInstance>();
        for (LogicalInstance li : this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.instanceSettingsTemplate=?1", ist)) {
            if (li.getCurrentPhysicalInstance() == null) continue;
            impactedInstances.add(li.getCurrentPhysicalInstance());
        }
        ArrayList<UpdateInstanceSettingsTemplateResult.LogicalInstanceRef> result = new ArrayList<UpdateInstanceSettingsTemplateResult.LogicalInstanceRef>();
        if (!impactedInstances.isEmpty()) {
            for (PhysicalInstanceCloudState impactedInstanceState : this.cloudInstanceService.getPhysicalInstancesCloudState(ist.getTenant(), impactedInstances)) {
                if (!impactedInstanceState.cloudMachineExists) continue;
                LogicalInstance li = impactedInstanceState.physicalInstance.getLogicalInstance();
                switch (requiresAction) {
                    case REQUIRES_REPLAY_SETUP_ACTIONS: 
                    case REQUIRES_REBOOT: {
                        if (!impactedInstanceState.cloudMachineIsUp) break;
                        result.add(new UpdateInstanceSettingsTemplateResult.LogicalInstanceRef(li.getId(), li.getLabel()));
                        break;
                    }
                    case REQUIRES_REPROVISION: {
                        result.add(new UpdateInstanceSettingsTemplateResult.LogicalInstanceRef(li.getId(), li.getLabel()));
                        break;
                    }
                }
            }
        }
        return result;
    }

    public CommandResult delete(String tenantId, String istId) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            InstanceSettingsTemplate ist = this.dbService.getSingleResult(InstanceSettingsTemplate.class, "SELECT ist from instancesettingstemplate ist where ist.tenant=?1 AND ist.id=?2", tenant, istId);
            if (ist == null) {
                throw new IllegalArgumentException("Instance template does not exists. It may have already been deleted.");
            }
            List<LogicalInstance> instanceList = this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.instanceSettingsTemplate=?1", ist);
            if (instanceList.size() > 0) {
                String culpritInstance = instanceList.get(0).getLabel();
                CommandResult commandResult = InstanceSettingsTemplateCRUDService.templateInUseError("The instance \"%s\" is based on this template. Only templates without any usage can be deleted.", culpritInstance);
                return commandResult;
            }
            List<PhysicalInstanceCreationState> picsList = this.dbService.listResults(PhysicalInstanceCreationState.class, "SELECT pics from physicalinstancecreationstate pics where pics.instanceSettingsTemplate=?1", ist);
            if (picsList.size() > 0) {
                PhysicalInstanceCreationState picsCulprit = picsList.get(0);
                List<PhysicalInstance> piList = this.dbService.listResults(PhysicalInstance.class, "SELECT pi from physicalinstance pi where pi.creationState=?1", picsCulprit);
                if (piList.size() > 0) {
                    String culpritInstance = piList.get(0).getLogicalInstance().getLabel();
                    CommandResult commandResult = InstanceSettingsTemplateCRUDService.templateInUseError("The instance \"%s\" is currently provisioned using this template. Only templates without any usage can be deleted.", culpritInstance);
                    return commandResult;
                }
                List<DataVolumeSnapshot> dvsList = this.dbService.listResults(DataVolumeSnapshot.class, "SELECT dvs from DataVolumeSnapshot dvs where dvs.creationState=?1", picsCulprit);
                if (dvsList.size() > 0) {
                    DataVolumeSnapshot snapshot = dvsList.get(0);
                    String culpritInstance = snapshot.getLogicalInstance().getLabel();
                    String snapshotDescription = snapshot.getDescription();
                    String snapshotDate = DKUDateUtils.formatUTC((long)snapshot.getCreationDate(), (String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                    CommandResult commandResult = InstanceSettingsTemplateCRUDService.templateInUseError("The instance \"%s\" has a snapshot that references it (\"%s\" created on %s). Only templates without any usage can be deleted.", culpritInstance, snapshotDescription, snapshotDate);
                    return commandResult;
                }
                int culpridId = picsList.get(0).getId();
                CommandResult commandResult = InstanceSettingsTemplateCRUDService.templateInUseError("The PhysicalInstanceCreationState id=%d references this template. Contact an administrator to delete it.", culpridId);
                return commandResult;
            }
            rwt.getThreadEM().remove((Object)ist);
            rwt.commit();
            CommandResult commandResult = CommandResult.withSuccess(true);
            return commandResult;
        }
    }

    public void encryptAddSSHKeyPrivateKey(InstanceSettingsTemplateDTO dto, Tenant tenant) {
        if (dto.setupActions != null) {
            dto.setupActions.stream().filter(s -> s.type == SetupAction.SetupActionType.ADD_SSH_KEY).forEach(s -> {
                JsonElement privateKey = s.params.get(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY);
                if (privateKey != null && StringUtils.isNotBlank((String)privateKey.getAsString())) {
                    s.params.remove(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY);
                    s.params.add(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY, (JsonElement)new JsonPrimitive(this.cryptoService.encrypt(tenant, privateKey.getAsString())));
                }
            });
        }
    }

    public void decryptSecrets(InstanceSettingsTemplateDTO dto, Tenant tenant) {
        if (dto.setupActions != null) {
            dto.setupActions.stream().filter(s -> s.type == SetupAction.SetupActionType.ADD_SSH_KEY).filter(s -> SETUP_ACTION_ADD_SSH_KEY_PARAM_VALUE_STORAGE_MODE_INLINE.equals(s.params.get(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_STORAGE_MODE).getAsString())).forEach(s -> {
                JsonElement privateKey = s.params.get(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY);
                s.params.remove(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY);
                s.params.add(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY, (JsonElement)new JsonPrimitive(this.cryptoService.decrypt(tenant, privateKey.getAsString())));
            });
        }
    }

    public boolean updateEncryption(InstanceSettingsTemplate template, Tenant current, Tenant updated) {
        String key = template.getDataikuAwsSecretAccessKey();
        if (StringUtils.isNotEmpty((String)key)) {
            String plainKey;
            boolean currentAbleToEncrypt = this.cryptoService.isAbleToEncrypt(current);
            String string = plainKey = currentAbleToEncrypt ? this.cryptoService.decrypt(current, key) : key;
            if (this.cryptoService.isAbleToEncrypt(updated)) {
                template.setDataikuAwsSecretAccessKey(this.cryptoService.encrypt(updated, plainKey));
            } else {
                template.setDataikuAwsSecretAccessKey(plainKey);
            }
            SetupAction.SetupActionList actions = JSonHelper.parseJsonSetupActions(template.getSetupActions());
            actions.stream().filter(s -> s.type == SetupAction.SetupActionType.ADD_SSH_KEY).filter(s -> SETUP_ACTION_ADD_SSH_KEY_PARAM_VALUE_STORAGE_MODE_INLINE.equals(s.params.get(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_STORAGE_MODE).getAsString())).forEach(s -> this.updateEncryption(s.params, current, updated, currentAbleToEncrypt));
            template.setSetupActions(JSonHelper.toJsonString(actions));
            return true;
        }
        return false;
    }

    private void updateEncryption(JsonObject params, Tenant current, Tenant updated, boolean currentAbleToEncrypt) {
        String key = params.get(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY).getAsString();
        String plainKey = currentAbleToEncrypt ? this.cryptoService.decrypt(current, key) : key;
        params.remove(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY);
        key = this.cryptoService.isAbleToEncrypt(updated) ? this.cryptoService.encrypt(updated, plainKey) : plainKey;
        params.add(SETUP_ACTION_ADD_SSH_KEY_PARAM_KEY_PRIVATE_KEY, (JsonElement)new JsonPrimitive(key));
    }

    private InstanceSettingsTemplateDTO convertToDTO(InstanceSettingsTemplate ist) {
        InstanceSettingsTemplateDTO dto = new InstanceSettingsTemplateDTO();
        dto.id = ist.getId();
        dto.label = ist.getLabel();
        dto.description = ist.getDescription();
        dto.setupActions = JSonHelper.parseJsonSetupActions(ist.getSetupActions());
        dto.license = ist.getLicense();
        dto.awsKeyPairName = ist.getAwsKeyPairName();
        dto.azureSshKey = ist.getAzureSshKey();
        dto.startupInstanceProfileArn = ist.getStartupInstanceProfileArn();
        dto.runtimeInstanceProfileArn = ist.getRuntimeInstanceProfileArn();
        dto.startupManagedIdentity = ist.getStartupManagedIdentity();
        dto.runtimeManagedIdentity = ist.getRuntimeManagedIdentity();
        dto.startupServiceAccount = ist.getStartupServiceAccount();
        dto.restrictAwsMetadataServerAccess = ist.isRestrictAwsMetadataServerAccess();
        dto.restrictGcpMetadataServerAccess = ist.isRestrictGcpMetadataServerAccess();
        dto.gcpBlockProjectWideKeys = ist.isGcpBlockProjectWideKeys();
        dto.gcpSshKey = ist.getGcpSshKey();
        dto.restrictAzureMetadataServerAccess = ist.isRestrictAzureMetadataServerAccess();
        dto.dataikuAwsAPIAccessMode = ist.getDataikuAWSAPIAccessMode();
        dto.dataikuAwsKeypairStorageMode = ist.getDataikuAwsKeypairStorageMode();
        dto.dataikuAwsAccessKeyId = ist.getDataikuAwsAccessKeyId();
        dto.dataikuAwsSecretAccessKeyAwsSecretName = ist.getDataikuAwsSecretAccessKeyAwsSecretName();
        dto.dssPort = ist.getDssPort();
        dto.storiesEnabled = ist.getStoriesEnabled();
        return dto;
    }

    private InstanceSettingsTemplateDTO convertToDTOAndEnrich(InstanceSettingsTemplate ist) {
        InstanceSettingsTemplateDTO dto = this.convertToDTO(ist);
        List<LogicalInstance> instanceList = this.dbService.listResults(LogicalInstance.class, "SELECT li from logicalinstance li where li.instanceSettingsTemplate=?1", ist);
        dto.nbInstances = instanceList.size();
        dto.nbInstancesProvisioned = InstanceSettingsTemplateCRUDService.filterProvisioned(instanceList).size();
        return dto;
    }

    private static List<LogicalInstance> filterProvisioned(List<LogicalInstance> instanceList) {
        ArrayList<LogicalInstance> result = new ArrayList<LogicalInstance>();
        for (LogicalInstance li : instanceList) {
            if (li.getCurrentPhysicalInstance() == null) continue;
            result.add(li);
        }
        return result;
    }

    private static CommandResult templateInUseError(String errMsgFormat, Object ... args) {
        CommandResult result = CommandResult.withSuccess(false);
        result.statusMessages.withFatal((InfoMessage.MessageCode)FMServerCodes.ERR_TEMPLATE_IN_USE, String.format(errMsgFormat, args));
        return result;
    }
}

