/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.instances;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.FMServerCodes;
import com.dataiku.fm.model.SetupAction;
import com.dataiku.fm.model.db.InstanceSettingsTemplate;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.PhysicalInstance;
import com.dataiku.fm.model.published.PublicLogicalInstance;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceAgentActionsQueueService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.InstancesHelper;
import com.dataiku.fm.server.instances.JSonHelper;
import com.dataiku.fm.server.instances.PhysicalInstanceProvisioningService;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PhysicalInstanceCommandService {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private InstanceAgentActionsQueueService instanceAgentActionsQueueService;
    @Autowired
    private InstancesCRUDService instancesService;
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private PhysicalInstanceProvisioningService physicalInstancesService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fm.instances.commands");

    public FutureResponse<JsonObject> resetUserPassword(FMAuthCtx authCtx, String instanceId, String username, String password) throws Exception {
        PhysicalInstance.LifecycleStage stage = InstancesHelper.getLifeCycleStage(this.dbService, authCtx.getTenantId(), instanceId);
        InstancesHelper.assertInstanceRunning(stage);
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.RESET_USER_PASSWORD;
        ac.payload = JF.obj().with("username", username).with("password", password).get();
        String tenantId = authCtx.getTenantId();
        return this.instanceAgentActionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac, (jsonObject, infoMessages) -> this.instancesService.clearInitialAdminPassword(tenantId, instanceId));
    }

    public FutureResponse<JsonObject> replaySetupActions(FMAuthCtx authCtx, String instanceId) throws Exception {
        PhysicalInstance.LifecycleStage stage = InstancesHelper.getLifeCycleStage(this.dbService, authCtx.getTenantId(), instanceId);
        InstancesHelper.assertInstanceRunning(stage);
        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
        ac.type = InstanceAgentActionsQueueService.AgentCommandType.REPLAY_SETUP_ACTIONS;
        LogicalInstance li = InstancesHelper.getInstanceMandatory(this.dbService, authCtx.getTenantId(), instanceId);
        InstanceSettingsTemplate ist = li.getInstanceSettingsTemplate();
        SetupAction.SetupActionList setupActions = JSonHelper.parseJsonSetupActions(ist.getSetupActions());
        SetupAction.SetupActionList replayActions = PhysicalInstanceCommandService.filterReplayActions(setupActions);
        if (replayActions.isEmpty()) {
            throw new ApplicativeException("No setup actions to replay", String.format("The instance template '%s' does not contain any setup action that can be replayed on a running instance.", ist.getLabel()));
        }
        InstanceAgentActionsQueueService.OnCommandResultSuccess onCommandResultSuccess = null;
        if (replayActions.stream().anyMatch(SetupAction::needRestart)) {
            onCommandResultSuccess = (jsonObject, infoMessages) -> infoMessages.withWarning((InfoMessage.MessageCode)FMServerCodes.WARN_NEED_INSTANCE_RESTART, "Some setup actions require the instance to be restarted.");
        }
        ac.payload = JF.obj().with("actions", (JsonElement)JSON.toJsonArray((Object)replayActions)).get();
        return this.instanceAgentActionsQueueService.enqueueAndStartWait(authCtx, instanceId, ac, onCommandResultSuccess);
    }

    private static SetupAction.SetupActionList filterReplayActions(SetupAction.SetupActionList setupActionList) {
        SetupAction.SetupActionList result = new SetupAction.SetupActionList();
        for (SetupAction setupAction : setupActionList) {
            if (!setupAction.enabled || !setupAction.canBeReplayed()) continue;
            result.add(setupAction);
        }
        return result;
    }

    public FutureResponse<DisableUserResult> disableUser(FMAuthCtx authCtx, String username, List<String> instanceIds) throws Exception {
        return this.futureService.runFuture(new DisableUserThread(this.dbService, authCtx, username, instanceIds), 0L, (TypeToken)new TypeToken<FutureResponse<DisableUserResult>>(){});
    }

    class DisableUserThread
    extends SimpleFMFutureThread<DisableUserResult> {
        private final String username;
        private final List<String> instanceIds;

        public DisableUserThread(DatabaseAccessService dbService, FMAuthCtx owner, String username, List<String> instanceIds) {
            super(dbService, owner, "disableUser");
            this.username = username;
            this.instanceIds = instanceIds;
        }

        @Override
        protected DisableUserResult compute() throws Exception {
            List<PublicLogicalInstance> instances = PhysicalInstanceCommandService.this.instancesService.list(this.owner.getTenantId());
            DisableUserResult result = new DisableUserResult();
            double steps = instances.size();
            if (this.instanceIds != null && !this.instanceIds.isEmpty()) {
                steps = this.instanceIds.size();
            }
            try (FutureProgress.AutocloseableFutureProgressState ignored = FutureProgress.pushAutoCloseableState((String)"Disabling user on instances", (double)steps, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                for (PublicLogicalInstance pli : instances) {
                    if (this.isAborted()) {
                        logger.info((Object)"Disable user aborted, skipping remaining instances");
                        break;
                    }
                    if (this.instanceIds != null && !this.instanceIds.isEmpty() && !this.instanceIds.contains(pli.id)) continue;
                    FutureProgress.getState().increment(1.0);
                    InstanceDisableUserResult instanceResult = new InstanceDisableUserResult();
                    instanceResult.success = true;
                    result.perInstanceResults.put(pli.id, instanceResult);
                    try (FutureProgress.AutocloseableFutureProgressState ignored2 = FutureProgress.pushAutoCloseableState((String)("Disabling user on " + pli.label));){
                        LogicalInstance li = PhysicalInstanceCommandService.this.instancesService.getInternal(this.owner.getTenantId(), pli.id);
                        PhysicalInstance pi = PhysicalInstanceCommandService.this.physicalInstancesService.getPhysicalInstance(li);
                        if (pi == null) {
                            logger.info((Object)("Instance " + pli.id + " is not provisioned, skipping"));
                            throw new IllegalStateException("Instance is not provisioned, cannot disable user");
                        }
                        if (pi.getLifecycleStage() != PhysicalInstance.LifecycleStage.RUNNING) {
                            logger.info((Object)("Instance " + pli.id + " is not running, skipping"));
                            throw new IllegalStateException("Instance is not fully running, cannot disable user");
                        }
                        logger.info((Object)("Instance " + pli.id + " has physical instance " + pi.getId()));
                        InstanceAgentActionsQueueService.AgentCommand ac = new InstanceAgentActionsQueueService.AgentCommand();
                        ac.commandId = "ac-" + SecretKeyGenerator.generate((int)8);
                        ac.type = InstanceAgentActionsQueueService.AgentCommandType.ENABLE_OR_DISABLE_USER;
                        ac.payload = JF.obj().with("username", this.username).with("enable", Boolean.valueOf(false)).get();
                        FutureResponse<JsonObject> initialResponse = PhysicalInstanceCommandService.this.instanceAgentActionsQueueService.enqueueAndStartWaitWithTimeout(this.owner, pli.id, ac, 30000L);
                        PhysicalInstanceCommandService.this.futureService.waitForFinalResponse(initialResponse);
                    }
                    catch (Exception e) {
                        logger.info((Object)("Failed to disable user on instance " + pli.id), (Throwable)e);
                        instanceResult.success = false;
                        instanceResult.error = new SerializedError((Throwable)e, false);
                    }
                    logger.info((Object)("Done on instance " + pli.id + " (" + pli.label + ")"));
                }
            }
            return result;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"disable_user", (String)("Disabling user " + this.username));
        }
    }

    static class DisableUserResult {
        Map<String, InstanceDisableUserResult> perInstanceResults = new HashMap<String, InstanceDisableUserResult>();

        DisableUserResult() {
        }
    }

    static class InstanceDisableUserResult {
        boolean success;
        SerializedError error;

        InstanceDisableUserResult() {
        }
    }
}

