/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.loadbalancers;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.APIIllegalArgumentException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.server.api.PublicAPICodes;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.fm.cloud.CloudDNSservice;
import com.dataiku.fm.cloud.CloudLoadBalancerService;
import com.dataiku.fm.futures.SimpleFMFutureThread;
import com.dataiku.fm.model.db.CertificateMode;
import com.dataiku.fm.model.db.LoadBalancerNodeMapping;
import com.dataiku.fm.model.db.LoadBalancerPublicIPMode;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalLoadBalancer;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.published.CommandResult;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.LoadBalancerLogicalStatus;
import com.dataiku.fm.model.published.LoadBalancerNodeMappingDTO;
import com.dataiku.fm.model.published.LoadBalancerPhysicalStatus;
import com.dataiku.fm.model.published.ProtoLoadBalancer;
import com.dataiku.fm.model.published.ProtoLoadBalancerNodeMapping;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.core.FMFutureResponse;
import com.dataiku.fm.server.core.FMFutureService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstancesCRUDService;
import com.dataiku.fm.server.instances.NodesDirectoryUpdateService;
import com.dataiku.fm.server.loadbalancers.LoadBalancerCodes;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Priority;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadBalancersCRUDService {
    private static final DKULogger logger = DKULogger.getLogger((String)"fm.lb");
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private CloudLoadBalancerService cloudLoadBalancerService;
    @Autowired
    private FMFutureService futureService;
    @Autowired
    private InstancesCRUDService instancesCRUDService;
    @Autowired
    private CloudDNSservice cloudDNSservice;
    @Autowired
    private NodesDirectoryUpdateService nodesDirectoryUpdateService;

    public List<LoadBalancerDTO> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        ArrayList<LoadBalancerDTO> ret = new ArrayList<LoadBalancerDTO>();
        for (LogicalLoadBalancer lb : this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.tenant=?1", tenant)) {
            ret.add(this.convertToDTO(lb, false));
        }
        return ret;
    }

    public List<LoadBalancerDTO> list(VirtualNetwork virtualNetwork) {
        return this.listInternal(virtualNetwork).stream().map(lb -> this.convertToDTO((LogicalLoadBalancer)lb, false)).collect(Collectors.toList());
    }

    public List<LogicalLoadBalancer> listInternal(VirtualNetwork virtualNetwork) {
        return this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.virtualNetwork=?1", virtualNetwork);
    }

    public LoadBalancerDTO create(String tenantId, ProtoLoadBalancer plb) {
        this.checkNotBlank(plb.name, "Load balancer name is null", new Object[0]);
        this.checkNotBlank(plb.virtualNetworkId, "Load balancer virtual network id is null", new Object[0]);
        this.checkNotNull((Object)plb.certificateMode, "Load balancer certificate mode is null", new Object[0]);
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                if (plb.certificateMode != CertificateMode.AWS_ARN) break;
                this.checkNotBlank(plb.awsCertificateARN, "Load balancer AWS certificate ARN is null", new Object[0]);
                break;
            }
            case AZURE: {
                this.checkNotNull((Object)plb.tier, "Load balancer type is null", new Object[0]);
                this.checkNotNull((Object)plb.publicIpMode, "Load balancer public ip mode is null", new Object[0]);
                if (plb.certificateMode == CertificateMode.AZURE_SECRET_ID) {
                    this.checkNotBlank(plb.azureCertificateSecretId, "Load balancer certificate secret id is null", new Object[0]);
                }
                if (plb.publicIpMode != LoadBalancerPublicIPMode.STATIC_PUBLIC_IP) break;
                this.checkNotBlank(plb.azurePublicIPID, "Load balancer public IP id is null", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Load balancer not supported for cloud type: " + String.valueOf((Object)settings.cloud));
            }
        }
        LogicalLoadBalancer lb = new LogicalLoadBalancer();
        lb.setId("lb-" + SecretKeyGenerator.generate((int)12));
        lb.setName(plb.name);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            List<LogicalLoadBalancer> existingLBs = this.dbService.listResults(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.name=?1", plb.name);
            this.checkArgument(existingLBs.size() == 0, (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Load balancer name is already in use", new Object[0]);
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            lb.setTenant(tenant);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)plb.virtualNetworkId);
            this.checkNotNull(vn, "Virtual network '" + plb.virtualNetworkId + "' doesn't exist.", new Object[0]);
            assert (vn.getTenant().getId().equals(tenant.getId()));
            lb.setVirtualNetwork(vn);
            lb.setCloudTags(CloudTagList.toJSON(plb.cloudTags));
            lb.setDescription(plb.description);
            lb.setTier(plb.tier);
            lb.setCertificateMode(plb.certificateMode);
            lb.setAwsCertificateARN(plb.awsCertificateARN);
            lb.setAzureCertificateSecretId(plb.azureCertificateSecretId);
            lb.setPublicIpMode(plb.publicIpMode);
            lb.setAzurePublicIPID(plb.azurePublicIPID);
            this.dbService.getThreadEM().persist((Object)lb);
            lb.setLoadBalancerNodeMapping(plb.nodes.stream().map(n -> this.createEntity((ProtoLoadBalancerNodeMapping)n, lb)).collect(Collectors.toSet()));
            for (LoadBalancerNodeMapping node : lb.getLoadBalancerNodeMapping()) {
                LogicalInstance logicalInstance = node.getLogicalInstance();
                this.checkArgument(this.instancesCRUDService.getLoadBalancer(logicalInstance) == null || this.instancesCRUDService.getLoadBalancer(logicalInstance).getId().equals(lb.getId()), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Instance '" + logicalInstance.getLabel() + "' already associated to another load balancer", new Object[0]);
            }
            rwt.commit();
            LoadBalancerDTO loadBalancerDTO = this.convertToDTO(lb, true);
            return loadBalancerDTO;
        }
    }

    public LoadBalancerDTO save(String tenantId, LoadBalancerDTO loadBalancerDTO) {
        this.checkNotBlank(loadBalancerDTO.name, "Load balancer name is null", new Object[0]);
        this.checkNotBlank(loadBalancerDTO.virtualNetworkId, "Load balancer virtual network id is null", new Object[0]);
        this.checkNotNull((Object)loadBalancerDTO.certificateMode, "Load balancer certificate mode is null", new Object[0]);
        FMSettings settings = FMApp.getFMSettingsUnsafe();
        switch (settings.cloud) {
            case AWS: {
                if (loadBalancerDTO.certificateMode != CertificateMode.AWS_ARN) break;
                this.checkNotBlank(loadBalancerDTO.awsCertificateARN, "Load balancer AWS certificate ARN is null", new Object[0]);
                break;
            }
            case AZURE: {
                this.checkNotNull((Object)loadBalancerDTO.tier, "Load balancer type is null", new Object[0]);
                this.checkNotNull((Object)loadBalancerDTO.publicIpMode, "Load balancer public ip mode is null", new Object[0]);
                if (loadBalancerDTO.certificateMode == CertificateMode.AZURE_SECRET_ID) {
                    this.checkNotBlank(loadBalancerDTO.azureCertificateSecretId, "Load balancer certificate secret id is null", new Object[0]);
                }
                if (loadBalancerDTO.publicIpMode != LoadBalancerPublicIPMode.STATIC_PUBLIC_IP) break;
                this.checkNotBlank(loadBalancerDTO.azurePublicIPID, "Load balancer public IP id is null", new Object[0]);
                break;
            }
            default: {
                throw new IllegalStateException("Load balancer not supported for cloud type: " + String.valueOf((Object)settings.cloud));
            }
        }
        LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerDTO.id);
        lb.setDescription(loadBalancerDTO.description);
        Map oldLBNodeMapping = lb.getLoadBalancerNodeMapping().stream().collect(Collectors.toMap(LoadBalancerNodeMapping::getId, Function.identity()));
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            LogicalInstance logicalInstance;
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            lb.setTenant(tenant);
            VirtualNetwork vn = (VirtualNetwork)this.dbService.getThreadEM().find(VirtualNetwork.class, (Object)loadBalancerDTO.virtualNetworkId);
            this.checkNotNull(vn, "Virtual network '" + loadBalancerDTO.virtualNetworkId + "' doesn't exist.", new Object[0]);
            assert (vn.getTenant().getId().equals(tenant.getId()));
            lb.setVirtualNetwork(vn);
            lb.setTier(loadBalancerDTO.tier);
            lb.setCloudTags(CloudTagList.toJSON(loadBalancerDTO.cloudTags));
            HashSet<LoadBalancerNodeMapping> loadBalancerNodeMappings = new HashSet<LoadBalancerNodeMapping>();
            for (LoadBalancerNodeMappingDTO loadBalancerNodeMappingDTO : loadBalancerDTO.nodes) {
                LogicalInstance instance = this.instancesCRUDService.getLogicalInstanceMand(lb.getTenant().getId(), loadBalancerNodeMappingDTO.instanceId);
                LoadBalancerNodeMapping loadBalancerNodeMapping = this.getLoadBalancerMapping(lb.getId(), loadBalancerNodeMappingDTO.instanceId);
                if (loadBalancerNodeMapping == null) {
                    loadBalancerNodeMapping = new LoadBalancerNodeMapping();
                    loadBalancerNodeMapping.setLogicalInstance(instance);
                    loadBalancerNodeMapping.setLogicalLoadBalancer(lb);
                    loadBalancerNodeMapping.setId("lb-node-mapping-" + SecretKeyGenerator.generate((int)12));
                } else {
                    oldLBNodeMapping.remove(loadBalancerNodeMapping.getId());
                    loadBalancerNodeMapping.setStatus(LoadBalancerNodeMapping.Status.ACTIVE);
                }
                loadBalancerNodeMapping.setHostname(loadBalancerNodeMappingDTO.hostname);
                loadBalancerNodeMappings.add(loadBalancerNodeMapping);
            }
            lb.setLoadBalancerNodeMapping(loadBalancerNodeMappings);
            lb.setCertificateMode(loadBalancerDTO.certificateMode);
            lb.setAwsCertificateARN(loadBalancerDTO.awsCertificateARN);
            lb.setAzureCertificateSecretId(loadBalancerDTO.azureCertificateSecretId);
            lb.setPublicIpMode(loadBalancerDTO.publicIpMode);
            lb.setAzurePublicIPID(loadBalancerDTO.azurePublicIPID);
            this.dbService.getThreadEM().persist((Object)lb);
            for (LoadBalancerNodeMapping loadBalancerNodeMapping : oldLBNodeMapping.values()) {
                if (this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned(lb, loadBalancerNodeMapping)) {
                    loadBalancerNodeMapping.setStatus(LoadBalancerNodeMapping.Status.INACTIVE);
                    this.dbService.getThreadEM().persist((Object)loadBalancerNodeMapping);
                    continue;
                }
                logicalInstance = loadBalancerNodeMapping.getLogicalInstance();
                this.dbService.getThreadEM().remove((Object)loadBalancerNodeMapping);
            }
            for (LoadBalancerNodeMapping loadBalancerNodeMapping : lb.getLoadBalancerNodeMapping()) {
                logicalInstance = loadBalancerNodeMapping.getLogicalInstance();
                LogicalLoadBalancer loadBalancer = this.instancesCRUDService.getLoadBalancer(logicalInstance);
                if (loadBalancer == null || loadBalancer.getId().equals(lb.getId())) continue;
                throw new APIIllegalArgumentException((InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, "Instance '" + logicalInstance.getLabel() + "' already associated to another load balancer");
            }
            rwt.commit();
            LoadBalancerDTO loadBalancerDTO2 = this.convertToDTO(lb, true);
            return loadBalancerDTO2;
        }
    }

    public LoadBalancerDTO get(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
        return this.convertToDTO(lb, true);
    }

    public PhysicalLoadBalancer getPhysicalLoadBalancer(LogicalLoadBalancer logicalLoadBalancer) {
        return this.dbService.getSingleResult(PhysicalLoadBalancer.class, "SELECT pi from physicalloadbalancer pi where pi.logicalLoadBalancer=?1", logicalLoadBalancer);
    }

    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(LogicalLoadBalancer loadBalancer) {
        if (loadBalancer.getCurrentPhysicalLoadBalancer() == null) {
            return new LoadBalancerPhysicalStatus(LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED);
        }
        return this.cloudLoadBalancerService.getPhysicalLoadBalancerStatus(loadBalancer);
    }

    public LoadBalancerPhysicalStatus getPhysicalLoadBalancerStatus(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer loadBalancer = this.getLoadBalancerMand(tenantId, loadBalancerId);
        return this.getPhysicalLoadBalancerStatus(loadBalancer);
    }

    public LoadBalancerLogicalStatus getLogicalLoadBalancerStatus(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer loadBalancer = this.getLoadBalancerMand(tenantId, loadBalancerId);
        FMFutureResponse job = this.futureService.getUpdates().stream().filter(u -> u.sourceObjectId != null && u.sourceObjectId.equals(loadBalancerId)).sorted((u1, u2) -> Long.compare(u2.startTime, u1.startTime)).findFirst().orElse(null);
        return new LoadBalancerLogicalStatus(loadBalancer.getCurrentPhysicalLoadBalancer() != null ? LoadBalancerDTO.PhysicalStatus.PROVISIONED : LoadBalancerDTO.PhysicalStatus.NOT_PROVISIONED, job);
    }

    public FutureResponse<CommandResult> startDeleteLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        return this.futureService.runFuture(new LoadBalancerFutureThread(authCtx, FMFutureResponse.Action.DELETE, loadBalancerId){

            @Override
            public CommandResult action(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
                return LoadBalancersCRUDService.this.deleteLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public FutureResponse<CommandResult> startDeprovisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        return this.futureService.runFuture(new LoadBalancerFutureThread(authCtx, FMFutureResponse.Action.DEPROVISION, loadBalancerId){

            @Override
            public CommandResult action(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
                return LoadBalancersCRUDService.this.deprovisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public FutureResponse<CommandResult> startProvisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        return this.futureService.runFuture(new LoadBalancerFutureThread(authCtx, FMFutureResponse.Action.PROVISION, loadBalancerId){

            @Override
            public CommandResult action(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
                return LoadBalancersCRUDService.this.provisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public FutureResponse<CommandResult> startReprovisionLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        return this.futureService.runFuture(new LoadBalancerFutureThread(authCtx, FMFutureResponse.Action.REPROVISION, loadBalancerId){

            @Override
            public CommandResult action(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
                return LoadBalancersCRUDService.this.reprovisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public FutureResponse<CommandResult> startUpdateLoadBalancer(FMAuthCtx authCtx, String loadBalancerId) throws Exception {
        return this.futureService.runFuture(new LoadBalancerFutureThread(authCtx, FMFutureResponse.Action.UPDATE, loadBalancerId){

            @Override
            public CommandResult action(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
                return LoadBalancersCRUDService.this.updateLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<CommandResult>>(){});
    }

    public void onAfterInstanceStatusUpdate(String tenantId, String instanceId) {
        LogicalInstance logicalInstance = this.instancesCRUDService.getLogicalInstanceMand(tenantId, instanceId);
        LogicalLoadBalancer loadBalancer = this.instancesCRUDService.getLoadBalancer(logicalInstance);
        if (loadBalancer == null) {
            return;
        }
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.cloudLoadBalancerService.onInstancePhysicalStateChange(rwt, loadBalancer, logicalInstance);
            rwt.getThreadEM().persist((Object)loadBalancer);
            rwt.commit();
        }
    }

    public void deleteLoadBalancerDependencies(DatabaseAccessService.ReadWriteTransaction rwt, LogicalInstance logicalInstance) {
        LogicalLoadBalancer loadBalancer = this.instancesCRUDService.getLoadBalancer(logicalInstance);
        if (loadBalancer == null) {
            return;
        }
        LoadBalancerNodeMapping nodeMapping = loadBalancer.getLoadBalancerNodeMapping().stream().filter(n -> n.getLogicalInstance().equals(logicalInstance)).findAny().orElseThrow(() -> new IllegalStateException("Node mapping does not exist although instance '" + logicalInstance.getLabel() + " ' is linked to lb '" + loadBalancer.getName() + "'"));
        loadBalancer.getLoadBalancerNodeMapping().remove(nodeMapping);
        if (this.cloudLoadBalancerService.isLoadBalancerNodeMappingProvisioned(loadBalancer, nodeMapping)) {
            this.cloudLoadBalancerService.onInstanceDeleteEvent(rwt, loadBalancer, nodeMapping, logicalInstance);
        }
        rwt.getThreadEM().remove((Object)nodeMapping);
        rwt.getThreadEM().persist((Object)loadBalancer);
        if (loadBalancer.getCurrentPhysicalLoadBalancer() != null) {
            rwt.getThreadEM().persist((Object)loadBalancer.getCurrentPhysicalLoadBalancer());
        }
    }

    private LoadBalancerDTO convertToDTO(LogicalLoadBalancer loadBalancer, boolean populateDNS) {
        LoadBalancerDTO lbdto = new LoadBalancerDTO();
        VirtualNetwork vn = loadBalancer.getVirtualNetwork();
        lbdto.id = loadBalancer.getId();
        lbdto.name = loadBalancer.getName();
        lbdto.description = loadBalancer.getDescription();
        lbdto.tier = loadBalancer.getTier();
        lbdto.virtualNetworkId = vn.getId();
        lbdto.virtualNetworkLabel = StringUtils.isBlank((String)vn.getLabel()) ? vn.getId() : vn.getLabel();
        lbdto.cloudTags = CloudTagList.fromJSON(loadBalancer.getCloudTags());
        lbdto.inheritedCloudTags = loadBalancer.getInheritedCloudTags(FMApp.getFMSettingsUnsafe());
        lbdto.nodes = loadBalancer.getLoadBalancerNodeMapping().stream().filter(m -> m.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE).map(m -> new LoadBalancerNodeMappingDTO(m.getHostname(), m.getLogicalInstance().getId())).collect(Collectors.toSet());
        lbdto.certificateMode = loadBalancer.getCertificateMode();
        lbdto.awsCertificateARN = loadBalancer.getAwsCertificateARN();
        lbdto.azureCertificateSecretId = loadBalancer.getAzureCertificateSecretId();
        lbdto.publicIpMode = loadBalancer.getPublicIpMode();
        lbdto.azurePublicIPID = loadBalancer.getAzurePublicIPID();
        if (populateDNS) {
            lbdto.publicDnsZone = this.cloudDNSservice.getPublicDNSZoneDomain(vn);
            lbdto.privateDnsZone = this.cloudDNSservice.getPrivateDNSZoneDomain(vn);
        }
        return lbdto;
    }

    private LoadBalancerNodeMapping toEntity(ProtoLoadBalancerNodeMapping protoLoadBalancerNodeMapping, String id, LogicalLoadBalancer loadBalancer) {
        LogicalInstance instance = this.instancesCRUDService.getLogicalInstanceMand(loadBalancer.getTenant().getId(), protoLoadBalancerNodeMapping.instanceId);
        LoadBalancerNodeMapping loadBalancerNodeMapping = new LoadBalancerNodeMapping();
        loadBalancerNodeMapping.setLogicalLoadBalancer(loadBalancer);
        loadBalancerNodeMapping.setId(id);
        loadBalancerNodeMapping.setHostname(protoLoadBalancerNodeMapping.hostname);
        loadBalancerNodeMapping.setLogicalInstance(instance);
        return loadBalancerNodeMapping;
    }

    private LoadBalancerNodeMapping createEntity(ProtoLoadBalancerNodeMapping protoLoadBalancerNodeMapping, LogicalLoadBalancer loadBalancer) {
        return this.toEntity(protoLoadBalancerNodeMapping, "lb-node-mapping-" + SecretKeyGenerator.generate((int)12), loadBalancer);
    }

    private LogicalLoadBalancer getLoadBalancerMand(String tenantId, String loadBalancerId) {
        LogicalLoadBalancer lb = this.dbService.getSingleResult(LogicalLoadBalancer.class, "SELECT lb from logicalloadbalancer lb where lb.tenant.id = ?1 AND lb.id = ?2", tenantId, loadBalancerId);
        if (lb == null) {
            throw new IllegalStateException(String.format("Unknown or missing load balancer: %s.%s", tenantId, loadBalancerId));
        }
        lb.setCurrentPhysicalLoadBalancer(this.getPhysicalLoadBalancer(lb));
        return lb;
    }

    private LoadBalancerNodeMapping getLoadBalancerMapping(String loadBalancerId, String instanceId) {
        return this.dbService.getSingleResult(LoadBalancerNodeMapping.class, "SELECT lbm from loadbalancernodemapping lbm where lbm.logicalInstance.id = ?1 AND lbm.logicalLoadBalancer.id = ?2", instanceId, loadBalancerId);
    }

    private CommandResult deleteLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            CommandResult commandResult;
            block18: {
                Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
                assert (tenant != null);
                LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
                FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deletingLBStep = FutureProgress.pushAutoCloseableState((String)"Deleting node mappings", (double)1.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.SIZE, (double)1.0);
                try {
                    PhysicalLoadBalancer pi = lb.getCurrentPhysicalLoadBalancer();
                    if (pi != null) {
                        throw new IllegalStateException("Load balancer is currently provisioned. Deprovision it first to delete it.");
                    }
                    rwt.getThreadEM().remove((Object)lb);
                    rwt.commit();
                    commandResult = CommandResult.withSuccess(true);
                    if (deletingLBStep == null) break block18;
                }
                catch (Throwable pi) {
                    try {
                        if (deletingLBStep != null) {
                            try {
                                deletingLBStep.close();
                            }
                            catch (Throwable throwable) {
                                pi.addSuppressed(throwable);
                            }
                        }
                        throw pi;
                    }
                    catch (Exception e) {
                        logger.error((Object)"Could not delete physical LB.", (Throwable)e);
                        logger.info((Object)("Saving current LB physical state: " + String.valueOf(lb.getCurrentPhysicalLoadBalancer())));
                        rwt.getThreadEM().persist((Object)lb);
                        rwt.commit();
                        CommandResult commandResult2 = CommandResult.withSuccess(false);
                        commandResult2.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DELETE_ERROR, e.getMessage());
                        CommandResult commandResult3 = commandResult2;
                        if (rwt != null) {
                            rwt.close();
                        }
                        return commandResult3;
                    }
                }
                deletingLBStep.close();
            }
            return commandResult;
        }
    }

    private CommandResult provisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        logger.infoV("Starting load balancer provisioning", new Object[0]);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
            try {
                try (Object globalState = FutureProgress.pushAutoCloseableState((String)"Creating load balancer", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                    smartLogTail.appendLine("Starting the setup of load balancer components in the cloud", logger, Priority.INFO);
                    try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement s1 = FutureProgress.pushAutoCloseableState((String)"Creating load balancer components", (double)1.0);){
                        this.cloudLoadBalancerService.createPhysicalLoadBalancer(lb, rwt, smartLogTail);
                        for (LoadBalancerNodeMapping m : lb.getLoadBalancerNodeMapping()) {
                            if (m.getStatus() == LoadBalancerNodeMapping.Status.ACTIVE) continue;
                            m.setStatus(LoadBalancerNodeMapping.Status.ACTIVE);
                            if (m.getPublicPhysicalDNSRecord() != null) {
                                rwt.getThreadEM().persist((Object)m.getPublicPhysicalDNSRecord());
                            }
                            if (m.getPrivatePhysicalDNSRecord() != null) {
                                rwt.getThreadEM().persist((Object)m.getPrivatePhysicalDNSRecord());
                            }
                            rwt.getThreadEM().persist((Object)m);
                        }
                        rwt.getThreadEM().persist((Object)lb.getCurrentPhysicalLoadBalancer());
                        rwt.getThreadEM().persist((Object)lb);
                        rwt.commit();
                    }
                    try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement s2 = FutureProgress.pushAutoCloseableState((String)"Provisioning load balancer components in the cloud", (double)1.0);){
                        LoadBalancerDTO.PhysicalStatus initialStatus = this.getPhysicalLoadBalancerStatus(tenantId, loadBalancerId).getPhysicalStatus();
                        if (initialStatus == LoadBalancerDTO.PhysicalStatus.PROVISIONING) {
                            LoadBalancerDTO.PhysicalStatus newStatus;
                            int count = 0;
                            smartLogTail.appendLine("Awaiting the provisioning of load balancer components...", logger, Priority.INFO);
                            do {
                                Thread.sleep(2000L);
                                smartLogTail.replaceLastLine("Awaiting the provisioning of load balancer components..." + ".".repeat(++count), logger, Priority.INFO);
                                logger.debugV("Checking physical load balancer status to see if the load balancer components were provisioned", new Object[0]);
                            } while (initialStatus.equals((Object)(newStatus = this.getPhysicalLoadBalancerStatus(tenantId, loadBalancerId).getPhysicalStatus())));
                        }
                    }
                }
                smartLogTail.appendLine("Load balancer has been successfully provisioned.", logger, Priority.INFO);
                this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "provisioned");
                globalState = CommandResult.withSuccess(true);
                return globalState;
            }
            catch (InterruptedException e) {
                logger.error((Object)"Could not provision physical LB.", (Throwable)e);
                smartLogTail.appendLine("An error occurred during load balancer provisioning; initiating cleanup.", logger, Priority.ERROR);
                this.deprovisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
                CommandResult commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_PROVISIONING_ERROR, e.getMessage());
                CommandResult commandResult2 = commandResult;
                if (rwt != null) {
                    rwt.close();
                }
                return commandResult2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommandResult reprovisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        CommandResult commandResult = new CommandResult();
        try (FutureProgress.AutocloseableFutureProgressState s1 = FutureProgress.pushAutoCloseableState((String)"Reprovision load balancer", (double)2.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement deprovisionStep = FutureProgress.pushAutoCloseableState((String)"Deprovisioning load balancer", (double)1.0);){
                commandResult = this.deprovisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
                if (!commandResult.success) {
                    CommandResult commandResult2 = commandResult;
                    return commandResult2;
                }
            }
            try (FutureProgress.AutocloseableFutureProgressStateWithAutoincrement provisionStep = FutureProgress.pushAutoCloseableState((String)"Provisioning load balancer", (double)1.0);){
                commandResult = this.provisionLoadBalancer(tenantId, loadBalancerId, smartLogTail);
            }
            CommandResult commandResult3 = commandResult;
            return commandResult3;
        }
        catch (InterruptedException e) {
            logger.warnV("Thread reprovisioning load balancer has been interrupted", new Object[0]);
            smartLogTail.appendLine("An error occurred while reprovisioning the load balancer.", logger, Priority.INFO);
            commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_REPROVISIONING_ERROR, e.getMessage());
            return commandResult;
        }
    }

    private CommandResult deprovisionLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
            PhysicalLoadBalancer currentPhysicalLoadBalancer = lb.getCurrentPhysicalLoadBalancer();
            if (currentPhysicalLoadBalancer == null) {
                FutureProgress.pushState((String)"Already deprovisioned.");
                CommandResult commandResult = CommandResult.withSuccess(true);
                return commandResult;
            }
            CommandResult commandResult = null;
            try {
                this.cloudLoadBalancerService.deletePhysicalLoadBalancer(lb, rwt, smartLogTail);
                for (LoadBalancerNodeMapping node : lb.getLoadBalancerNodeMapping()) {
                    if (node.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE) continue;
                    this.dbService.getThreadEM().remove((Object)node);
                }
                lb.getLoadBalancerNodeMapping().removeIf(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE);
                rwt.getThreadEM().remove((Object)currentPhysicalLoadBalancer);
                lb.setCurrentPhysicalLoadBalancer(null);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(true);
            }
            catch (Exception e) {
                logger.error((Object)"Could not deprovision physical LB.", (Throwable)e);
                logger.info((Object)("Saving current LB physical state: " + String.valueOf(currentPhysicalLoadBalancer)));
                rwt.getThreadEM().persist((Object)currentPhysicalLoadBalancer);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DEPROVISIONING_ERROR, e.getMessage());
            }
            this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "deprovisioned");
            CommandResult commandResult2 = commandResult;
            return commandResult2;
        }
    }

    private CommandResult updateLoadBalancer(String tenantId, String loadBalancerId, DKUtils.SmartLogTailBuilder smartLogTail) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)rwt.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            LogicalLoadBalancer lb = this.getLoadBalancerMand(tenantId, loadBalancerId);
            if (lb.getCurrentPhysicalLoadBalancer() == null) {
                throw new IllegalStateException("Application gateway not provisioned. Please provision or re-provision instead.");
            }
            LoadBalancerPhysicalStatus physicalLoadBalancerPhysicalStatus = this.cloudLoadBalancerService.getPhysicalLoadBalancerStatus(lb);
            if (physicalLoadBalancerPhysicalStatus.getPhysicalStatus() != LoadBalancerDTO.PhysicalStatus.NEED_UPDATING) {
                logger.warn((Object)("Could not update physical LB with status: " + String.valueOf((Object)physicalLoadBalancerPhysicalStatus.getPhysicalStatus())));
                CommandResult commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_DEPROVISIONING_ERROR, "Could not update physical LB with status: " + String.valueOf((Object)physicalLoadBalancerPhysicalStatus.getPhysicalStatus()));
                CommandResult commandResult2 = commandResult;
                return commandResult2;
            }
            CommandResult commandResult = null;
            try {
                this.cloudLoadBalancerService.updatePhysicalLoadBalancer(lb, rwt, smartLogTail, lb.getCurrentPhysicalLoadBalancer());
                for (LoadBalancerNodeMapping node : lb.getLoadBalancerNodeMapping()) {
                    if (node.getStatus() != LoadBalancerNodeMapping.Status.INACTIVE) continue;
                    this.dbService.getThreadEM().remove((Object)node);
                }
                lb.getLoadBalancerNodeMapping().removeIf(nodeMapping -> nodeMapping.getStatus() == LoadBalancerNodeMapping.Status.INACTIVE);
                rwt.getThreadEM().persist((Object)lb);
                rwt.commit();
                commandResult = CommandResult.withSuccess(true);
            }
            catch (Exception e) {
                logger.error((Object)"Could not update physical LB.", (Throwable)e);
                commandResult = CommandResult.withSuccess(false);
                commandResult.statusMessages.withError((InfoMessage.MessageCode)LoadBalancerCodes.LOAD_BALANCER_UPDATE_ERROR, e.getMessage());
            }
            this.nodesDirectoryUpdateService.onAfterLoadBalancerStatusUpdate(tenantId, lb.getVirtualNetwork().getId(), lb.getId(), "updated");
            CommandResult commandResult3 = commandResult;
            return commandResult3;
        }
    }

    protected void checkNotNull(Object o, String message, Object ... arguments) {
        this.checkArgument(o != null, (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected void checkNotEmpty(String str, String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotEmpty((String)str), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected void checkNotBlank(String str, String message, Object ... arguments) {
        this.checkArgument(StringUtils.isNotBlank((String)str), (InfoMessage.MessageCode)PublicAPICodes.ERR_PUBLICAPI_EMPTY_PARAMETER, message, arguments);
    }

    protected void checkArgument(boolean expression, InfoMessage.MessageCode code, String message, Object ... arguments) {
        if (!expression) {
            throw new APIIllegalArgumentException(code, String.format(message, arguments));
        }
    }

    private abstract class LoadBalancerFutureThread
    extends SimpleFMFutureThread<CommandResult> {
        private final String loadBalancerId;
        private final String label;
        final DKUtils.SmartLogTailBuilder smartLogTail;

        public LoadBalancerFutureThread(FMAuthCtx owner, FMFutureResponse.Action action, String loadBalancerId) {
            super(LoadBalancersCRUDService.this.dbService, owner, action.name());
            this.smartLogTail = new DKUtils.SmartLogTailBuilder();
            this.loadBalancerId = loadBalancerId;
            this.label = action.name() + " load balancer";
            this.action = action;
            this.sourceObjectId = loadBalancerId;
            this.type = FMFutureResponse.SourceObjectType.LOAD_BALANCER;
        }

        @Override
        protected CommandResult compute() {
            return this.action(this.tenantId, this.loadBalancerId, this.smartLogTail);
        }

        public abstract CommandResult action(String var1, String var2, DKUtils.SmartLogTailBuilder var3);

        public FuturePayload getPayload() {
            return null;
        }

        public SmartLogTail getLog() {
            return this.smartLogTail.get();
        }
    }
}

