/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.loadbalancers;

import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.utils.JSON;
import com.dataiku.fm.model.published.LoadBalancerDTO;
import com.dataiku.fm.model.published.ProtoLoadBalancer;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.loadbalancers.CreationDataService;
import com.dataiku.fm.server.loadbalancers.LoadBalancersCRUDService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMUIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class LoadBalancersController
extends DIPInternalControllerBase {
    @Autowired
    private FMUIAuthService uiAuthService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private LoadBalancersCRUDService loadBalancersCRUDService;
    @Autowired
    private CreationDataService creationDataService;

    @RequestMapping(value={"/api/ui/load-balancers/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        List<LoadBalancerDTO> ret = this.loadBalancersCRUDService.list(authCtx.getTenantId());
        LoadBalancersController.writeJSON((HttpServletResponse)resp, ret);
    }

    @RequestMapping(value={"/api/ui/load-balancers/create"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String loadBalancer) throws Exception {
        ProtoLoadBalancer plb = (ProtoLoadBalancer)JSON.parse((String)loadBalancer, ProtoLoadBalancer.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.create(authCtx.getTenantId(), plb));
    }

    @RequestMapping(value={"/api/ui/load-balancers/get-creation-data"})
    public void getCreationData(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.creationDataService.getCreationData(authCtx.getTenantId()));
    }

    @RequestMapping(value={"/api/ui/load-balancers/{loadBalancerId}/physical/status"})
    public void getPhysicalLoadBalancerStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.getPhysicalLoadBalancerStatus(authCtx.getTenantId(), loadBalancerId));
    }

    @RequestMapping(value={"/api/ui/load-balancers/{loadBalancerId}/status"})
    public void getLogicalLoadBalancerStatus(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.getLogicalLoadBalancerStatus(authCtx.getTenantId(), loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/api/ui/load-balancers/{loadBalancerId}"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.get(authCtx.getTenantId(), loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.PUT}, value={"/api/ui/load-balancers/"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String loadBalancer) throws Exception {
        LoadBalancerDTO dto = (LoadBalancerDTO)JSON.parse((String)loadBalancer, LoadBalancerDTO.class);
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, (Object)this.loadBalancersCRUDService.save(authCtx.getTenantId(), dto));
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/ui/load-balancers/{loadBalancerId}"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancersCRUDService.startDeleteLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/ui/load-balancers/{loadBalancerId}/start-provision"})
    public void provision(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancersCRUDService.startProvisionLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/ui/load-balancers/{loadBalancerId}/start-deprovision"})
    public void deprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancersCRUDService.startDeprovisionLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/ui/load-balancers/{loadBalancerId}/start-reprovision"})
    public void reprovision(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancersCRUDService.startReprovisionLoadBalancer(authCtx, loadBalancerId));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/api/ui/load-balancers/{loadBalancerId}/start-update"})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable(value="loadBalancerId") String loadBalancerId) throws Exception {
        FMAuthCtx authCtx = (FMAuthCtx)this.uiAuthService.getMandatoryUserAs(req, FMAuthCtx.class);
        this.permissionsService.checkOwnTenantAdmin(authCtx);
        LoadBalancersController.writeJSON((HttpServletResponse)resp, this.loadBalancersCRUDService.startUpdateLoadBalancer(authCtx, loadBalancerId));
    }
}

