/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.CloudAccountDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPICloudAccountsController
extends PublicAPIControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private CloudAccountsService cloudAccountsService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-accounts"}, method={RequestMethod.POST})
    public void createCloudAccount(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccountDTO dto = (CloudAccountDTO)this.getRequestBodyAs(req, CloudAccountDTO.class);
        PublicAPICloudAccountsController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.create(tenant, dto));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-accounts"}, method={RequestMethod.GET})
    public void getCloudAccounts(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        PublicAPICloudAccountsController.writeJSON((HttpServletResponse)resp, this.cloudAccountsService.list(tenant));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-accounts/{accountId}"}, method={RequestMethod.GET})
    public void getCloudAccount(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String accountId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccount vn = (CloudAccount)this.dbService.getThreadEM().find(CloudAccount.class, (Object)accountId);
        if (vn == null) {
            throw new IllegalArgumentException("Cloud account does not exists. It may have been deleted.");
        }
        if (!vn.getTenant().getId().equals(tenantId)) {
            throw new UnauthorizedException("Forbidden", "forbidden");
        }
        PublicAPICloudAccountsController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.getAccountDTO(tenant, accountId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-accounts/{accountId}"}, method={RequestMethod.PUT})
    public void saveAccount(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String accountId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccountDTO dto = (CloudAccountDTO)this.getRequestBodyAs(req, CloudAccountDTO.class);
        dto.id = accountId;
        this.cloudAccountsService.save(tenant, dto);
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/cloud-accounts/{accountId}"}, method={RequestMethod.DELETE})
    public void deleteAccount(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String accountId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)authCtx.getTenantId());
        assert (tenant != null);
        CloudAccount account = (CloudAccount)this.dbService.getThreadEM().find(CloudAccount.class, (Object)accountId);
        if (!account.getTenant().getId().equals(tenantId)) {
            throw new UnauthorizedException("Forbidden", "forbidden");
        }
        PublicAPICloudAccountsController.writeJSON((HttpServletResponse)resp, (Object)this.cloudAccountsService.delete(tenant, accountId));
    }
}

