/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.publicapi;

import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.fm.model.published.InstanceSettingsTemplateDTO;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.instances.InstanceSettingsTemplateCRUDService;
import com.dataiku.fm.server.security.FMPermissionsService;
import com.dataiku.fm.server.security.FMPublicAPIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PublicAPIInstanceSettingsTemplatesController
extends PublicAPIControllerBase {
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private FMPublicAPIAuthService authService;
    @Autowired
    private FMPermissionsService permissionsService;
    @Autowired
    private InstanceSettingsTemplateCRUDService crudService;

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instance-settings-templates"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, this.crudService.list(tenantId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instance-settings-templates"}, method={RequestMethod.POST})
    public void create(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        InstanceSettingsTemplateDTO dto = (InstanceSettingsTemplateDTO)this.getRequestBodyAs(req, InstanceSettingsTemplateDTO.class);
        PublicAPIInstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)this.crudService.create(authCtx, tenantId, dto));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instance-settings-templates/{istId}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String istId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)this.crudService.get(tenantId, istId));
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instance-settings-templates/{istId}"}, method={RequestMethod.PUT})
    public void update(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String istId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        InstanceSettingsTemplateDTO dto = (InstanceSettingsTemplateDTO)this.getRequestBodyAs(req, InstanceSettingsTemplateDTO.class);
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.crudService.update(authCtx, tenantId, dto);
            rwt.commit();
        }
    }

    @RequestMapping(value={"/api/public/tenants/{tenantId}/instance-settings-templates/{istId}"}, method={RequestMethod.DELETE})
    public void delete(HttpServletRequest req, HttpServletResponse resp, @PathVariable String tenantId, @PathVariable String istId) throws Exception {
        FMAuthCtx authCtx = this.authService.getUserMandatory(req);
        this.permissionsService.checkTenantAdmin(authCtx, tenantId);
        PublicAPIInstanceSettingsTemplatesController.writeJSON((HttpServletResponse)resp, (Object)this.crudService.delete(tenantId, istId));
    }
}

