/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.DkuLoginEventService;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserIdentity;
import com.dataiku.dip.security.auth.UserNotFoundException;
import com.dataiku.dip.security.sso.OpenIDErrorCode;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.fm.model.settings.FMTenancy;
import com.dataiku.fm.security.sso.FMSSOService;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.security.FMUIAuthService;
import com.dataiku.fm.server.security.auth.FMUserAuthenticationFactory;
import com.lastpass.saml.AttributeSet;
import com.lastpass.saml.SAMLException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FMAuthController
extends DIPInternalControllerBase {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.auth");
    private static final String DKU_MAX_LOGIN_SIZE = "dku.max.login.size";
    private static final int DEFAULT_MAX_LOGIN_SIZE = 241;
    @Autowired
    private FMUIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private FMSSOService ssoAssistants;
    @Autowired
    private DkuLoginEventService loginEventService;
    @Autowired
    private FMUserAuthenticationFactory fmUserAuthenticationFactory;

    @AuditInline
    @RequestMapping(value={"/api/ui/login"}, method={RequestMethod.POST})
    public void login(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="tenantId") String tenantId, @RequestParam(value="login") String inputLogin, @RequestParam(value="password") String password) {
        long loginStart = System.currentTimeMillis();
        try {
            this.assertNotSaasInstance();
            int maxLoginSize = DKUApp.getProperty((String)DKU_MAX_LOGIN_SIZE, (int)241);
            if (inputLogin != null && inputLogin.length() > maxLoginSize) {
                logger.warnV("Rejecting too long login input (" + inputLogin.length() + " characters > limit " + maxLoginSize + "). Login size can be increased using the dip property 'dku.max.login.size'", new Object[0]);
                resp.setStatus(401);
                resp.getWriter().write("Authentication failed.");
                return;
            }
            logger.infoV("Start authentication of login '%s' with Login/Password method", new Object[]{inputLogin});
            if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
                tenantId = "main";
            }
            try {
                DkuUser dkuUser = this.fmUserAuthenticationFactory.getUserAuthenticationService(tenantId).authenticateWithPassword(inputLogin, password);
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onPasswordBasedLoginSuccess(req, dkuUser);
                this.authService.createSession(resp, dkuUser);
            }
            catch (UnauthorizedException | UserAuthenticationException e) {
                logger.infoV("Authentication failed for login '%s': %s", new Object[]{inputLogin, e.getMessage()});
                this.sleepConstantTime(loginStart);
                this.loginEventService.onLoginError(inputLogin);
                resp.setStatus(401);
                resp.getWriter().write("Authentication failed.");
            }
            catch (UserAuthenticationService.UserDisabledException e) {
                logger.infoV("Authentication failed for login '%s': %s", new Object[]{inputLogin, e.getMessage()});
                this.sleepConstantTime(loginStart);
                this.loginEventService.onLoginError(inputLogin);
                resp.setStatus(401);
                resp.getWriter().write("User is disabled");
            }
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while trying to log user '%s'", new Object[]{inputLogin});
            this.sleepConstantTime(loginStart);
            this.loginEventService.onLoginError(inputLogin);
            resp.setStatus(500);
        }
    }

    @RequestMapping(value={"/api/ui/get-saml-redirect-url"}, method={RequestMethod.POST})
    public void getSAMLRedirectURL(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="main") String tenantId) throws SAMLException, IOException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (FMApp.getFMSettingsUnsafe().tenancy != FMTenancy.MONOTENANT) {
            params.add((Object)"tenantId", (Object)tenantId);
        }
        FMAuthController.writeJSON((HttpServletResponse)resp, (Object)this.ssoAssistants.saml().getRedirectURL((MultiValueMap)params));
    }

    @RequestMapping(value={"/api/saml-callback"}, method={RequestMethod.POST})
    public void samlLogin(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="main") String tenantId) {
        logger.infoV("Start SSO SAML callback", new Object[0]);
        if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
            tenantId = "main";
        }
        try {
            String authResponse = req.getParameter("SAMLResponse");
            AttributeSet aset = this.ssoAssistants.saml().validateResponse(authResponse);
            logger.info((Object)("SAML response validated, Attribute Set:\n" + JSON.pretty((Object)aset)));
            UserIdentity userIdentity = this.ssoAssistants.saml().getUserIdentity(aset);
            logger.info((Object)("Extracted user identity from SSO before remapping: " + String.valueOf(userIdentity)));
            DkuUser dkuUser = this.linkToDSSUser(userIdentity, tenantId);
            if (dkuUser != null) {
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onSSOLoginSuccess(dkuUser);
                this.authService.createSession(resp, dkuUser);
                resp.setStatus(302);
                resp.setHeader("Location", "/");
            } else {
                logger.infoV("Authentication failed for login '%s'", new Object[]{userIdentity.login});
                this.loginEventService.onLoginError(userIdentity.login);
                resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        catch (Exception e) {
            logger.error((Object)"SAML login failed", (Throwable)e);
            resp.setStatus(302);
            resp.setHeader("Location", "/sso-error?error=SAML%20Login%20failed&errorDescription=" + UserAuthenticationService.getDesensitizedMessageForUserAuthenticationException((Exception)e));
            this.auditTrailService.generic("login-failure").with("type", "saml").emit();
        }
    }

    @RequestMapping(value={"/api/ui/get-openid-redirect-url"}, method={RequestMethod.GET})
    public void getOpenIDRedirectURL(HttpServletRequest req, HttpServletResponse resp, @RequestParam String dssUrl) throws IOException, URISyntaxException {
        try {
            Assert.notNull((Object)dssUrl, (String)"Missing 'dssUrl' parameter");
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)e.getMessage());
            resp.setStatus(HttpStatus.BAD_REQUEST.value());
            return;
        }
        Pair redirectURLAndCodeVerifier = this.ssoAssistants.openid().getRedirectURL(dssUrl);
        this.authService.createPKCECodeVerifierCookie(resp, (String)redirectURLAndCodeVerifier.second);
        FMAuthController.writeJSON((HttpServletResponse)resp, (Object)redirectURLAndCodeVerifier.first);
    }

    @RequestMapping(value={"/api/ui/openid-callback"}, method={RequestMethod.POST})
    public void openidCallback(HttpServletRequest req, HttpServletResponse resp, @RequestParam String code, @RequestParam String state, @RequestParam String dssUrl, @RequestParam(defaultValue="main") String tenantId) throws Exception {
        UserIdentity userIdentity;
        logger.infoV("Start SSO OpenID callback", new Object[0]);
        if (FMApp.getFMSettingsUnsafe().tenancy == FMTenancy.MONOTENANT) {
            tenantId = "main";
        }
        if (this.ssoAssistants.openid().isPKCEEnabled()) {
            Optional<String> codeVerifier = this.authService.getCodeVerifierFromCookie(req);
            if (!codeVerifier.isPresent()) {
                throw new CodedException((InfoMessage.MessageCode)OpenIDErrorCode.ERR_OPENID_PKCE_CODE_VERIFIER_MISSING, "Couldn't exchange the authorization code, the PKCE code verifier is missing. Please contact your administrator.");
            }
            this.authService.deletePKCECodeVerifierCookie(resp);
            userIdentity = this.ssoAssistants.openid().getUserIdentity(code, state, dssUrl, codeVerifier.get());
        } else {
            userIdentity = this.ssoAssistants.openid().getUserIdentity(code, state, dssUrl, null);
        }
        logger.info((Object)("Extracted user identity from SSO before remapping: " + String.valueOf(userIdentity)));
        try {
            DkuUser dkuUser = this.linkToDSSUser(userIdentity, tenantId);
            if (dkuUser != null) {
                logger.infoV("Authentication success for login '%s'", new Object[]{dkuUser.getLogin()});
                this.loginEventService.onSSOLoginSuccess(dkuUser);
                this.authService.createSession(resp, dkuUser);
                resp.setStatus(HttpStatus.CREATED.value());
            } else {
                logger.infoV("Authentication failed for login '%s'", new Object[]{userIdentity.login});
                this.loginEventService.onLoginError(userIdentity.login);
                resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            }
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "OpenID authentication failed for login '%s'", new Object[]{userIdentity.login});
            this.loginEventService.onLoginError(userIdentity.login);
            resp.setStatus(HttpStatus.UNAUTHORIZED.value());
            throw UserAuthenticationService.getDesensitizedExceptionForUserAuthenticationException((Exception)e);
        }
    }

    @AuditedCall(value={"msgType", "logout"})
    @RequestMapping(value={"/api/ui/logout"}, method={RequestMethod.POST})
    public void logout(HttpServletRequest req, HttpServletResponse resp) throws IOException, DKUSecurityException {
        AuthCtx user;
        this.assertNotSaasInstance();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getUser(req);
        }
        this.authService.destroyCurrentSession(req, resp);
        if (user != null) {
            this.loginEventService.onLogout(user);
        }
    }

    private DkuUser linkToDSSUser(UserIdentity userIdentity, String tenantId) throws ServerAuthenticationFailure, UserNotFoundException, UserAuthenticationService.UserDisabledException, UnauthorizedException {
        userIdentity.login = this.ssoAssistants.userMapper().remapProvidedLogin(userIdentity.login);
        logger.infoV("Finding a matching DSS user for login '%s' or provision it if possible", new Object[]{userIdentity.login});
        UserAuthenticationService userAuthenticationService = this.fmUserAuthenticationFactory.getUserAuthenticationService(tenantId);
        return userAuthenticationService.syncOrProvisionFromTrustedSourceAtLoginTime(userIdentity, userAuthenticationService.getUserWithCaseSensitivenessRule(userIdentity.login));
    }

    private void assertNotSaasInstance() {
        try (Transaction t = this.transactionService.beginRead();){
            if (DKUApp.isSAASAuth()) {
                throw new IllegalArgumentException("Cannot login/logout on a SAAS instance");
            }
        }
    }

    private void sleepConstantTime(long loginStart) {
        long authFailureTargetTime = DKUApp.getParams().getLongParam("dku.security.login.authFailureTargetTime", 2000L);
        long timeAlreadySpent = System.currentTimeMillis() - loginStart;
        if (timeAlreadySpent >= 0L && timeAlreadySpent < authFailureTargetTime) {
            try {
                Thread.sleep(authFailureTargetTime - timeAlreadySpent);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

