/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.fm.model.db.FMGroup;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.db.Tenant;
import com.dataiku.fm.model.published.FMGroupDTO;
import com.dataiku.fm.server.db.DatabaseAccessService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMGroupsService {
    @Autowired
    private DatabaseAccessService dbService;

    public List<FMGroupDTO> list(String tenantId) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        ArrayList<FMGroupDTO> groupDTOs = new ArrayList<FMGroupDTO>();
        List<FMGroup> groups = this.dbService.listResults(FMGroup.class, "SELECT grp from fmgroup grp where grp.tenant=?1", tenant);
        for (FMGroup group : groups) {
            groupDTOs.add(this.convertToDTO(group));
        }
        return groupDTOs;
    }

    public FMGroupDTO get(String tenantId, Integer gid) throws NotFoundException {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        FMGroup group = this.dbService.getSingleResult(FMGroup.class, "SELECT grp from fmgroup grp where grp.tenant=?1 AND grp.id=?2", tenant, gid);
        if (group == null) {
            throw new NotFoundException("FMGroup not found");
        }
        return this.convertToDTO(group);
    }

    public FMGroupDTO create(String tenantId, FMGroupDTO fmGroupDTO) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
            assert (tenant != null);
            FMGroup fmGroup = new FMGroup();
            fmGroup.setTenant(tenant);
            fmGroup.setGroupId(fmGroupDTO.groupId);
            fmGroup.setAdmin(fmGroupDTO.admin);
            fmGroup.setWrite(fmGroupDTO.write);
            fmGroup.setRead(fmGroupDTO.read);
            fmGroup.setUsers(new HashSet<FMUser>());
            this.dbService.getThreadEM().persist((Object)fmGroup);
            rwt.commit();
            FMGroupDTO fMGroupDTO = this.convertToDTO(fmGroup);
            return fMGroupDTO;
        }
    }

    public FMGroupDTO update(String tenantId, FMGroupDTO dto) {
        Tenant tenant = (Tenant)this.dbService.getThreadEM().find(Tenant.class, (Object)tenantId);
        assert (tenant != null);
        FMGroup group = this.dbService.getSingleResult(FMGroup.class, "SELECT grp from fmgroup grp where grp.tenant=?1 AND grp.id=?2", tenant, dto.id);
        if (group == null) {
            throw new Error("unknown Group");
        }
        group.setTenant(tenant);
        group.setGroupId(dto.groupId);
        group.setAdmin(dto.admin);
        group.setWrite(dto.write);
        group.setRead(dto.read);
        group.setUsers(new HashSet<FMUser>());
        this.dbService.getThreadEM().persist((Object)group);
        return this.convertToDTO(group);
    }

    private FMGroupDTO convertToDTO(FMGroup group) {
        FMGroupDTO dto = new FMGroupDTO();
        dto.admin = group.isAdmin();
        dto.write = group.isWrite();
        dto.read = group.isRead();
        dto.groupId = group.getGroupId();
        dto.id = group.getId();
        return dto;
    }
}

