/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.auth.APIAuthUtilsBase;
import com.dataiku.dip.util.HTTPClientBaseUtils;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.db.DatabaseAccessService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMPublicAPIAuthService {
    @Autowired
    private DatabaseAccessService dbService;

    public FMAuthCtx getUserMandatory(HttpServletRequest req) throws DKUSecurityException, CodedException {
        APIAuthUtilsBase.BasicCredential lp = HTTPClientBaseUtils.decodeAuth((HttpServletRequest)req);
        if (lp == null) {
            throw new DKUSecurityException("Not authenticated");
        }
        FMPersonalAPIKey pak = this.dbService.getSingleResult(FMPersonalAPIKey.class, "SELECT pak from fmpersonalapikey pak WHERE pak.keyId = ?1", lp.user);
        if (pak != null && pak.verifySecret(lp.password)) {
            return FMAuthCtx.forUserFromUI(pak.getUser(), null);
        }
        throw new DKUSecurityException("Not authenticated");
    }
}

