/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.UIAuthServiceBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.model.db.FMPersonalAPIKey;
import com.dataiku.fm.model.db.FMUser;
import com.dataiku.fm.model.db.FMUserSession;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.security.FMAuthCtx;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.db.DatabaseAccessService;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FMUIAuthService
extends UIAuthServiceBase {
    public static final String DKU_FM_FORCE_SINGLE_SESSION_PER_USER = "dku.fm.forceSingleSessionPerUser";
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private TransactionService transactionService;
    public static final String PKCE_CODE_VERIFIER_COOKIE_NAME = "pkce_code_verifier";
    private static final String JETTY_SAME_SITE_NONE = "__SAME_SITE_NONE__";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.fm.auth");

    public FMUserSession createSession(HttpServletResponse resp, DkuUser user) {
        if (DKUApp.getParams().getBoolParam(DKU_FM_FORCE_SINGLE_SESSION_PER_USER, false)) {
            this.removeExistingSessionsForUser((FMUser)user);
        }
        FMUserSession ret = new FMUserSession();
        ret.setUser((FMUser)user);
        ret.setAccessToken(SecretKeyGenerator.generate());
        ret.setXsrfTokenSalt(SecretKeyGenerator.generate((int)8));
        ret.setGranted(System.currentTimeMillis());
        ret.setRefreshed(System.currentTimeMillis());
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            this.dbService.getThreadEM().persist((Object)ret);
            rwt.commit();
        }
        Cookie c = new Cookie(UIAuthServiceBase.getAccessCookieName(), ret.getAccessToken());
        c.setHttpOnly(true);
        c.setSecure(DKUApp.secureCookies());
        if (DKUApp.sameSiteNoneCookies()) {
            c.setComment(JETTY_SAME_SITE_NONE);
        }
        c.setPath("/");
        resp.addCookie(c);
        return ret;
    }

    private void removeExistingSessionsForUser(FMUser user) {
        try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
            for (FMUserSession session : this.dbService.listResults(FMUserSession.class, "SELECT s from fmusersession s where s.user=?1", user)) {
                this.dbService.getThreadEM().remove((Object)session);
            }
            rwt.commit();
        }
    }

    public void destroyCurrentSession(HttpServletRequest req, HttpServletResponse resp) throws DKUSecurityException {
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        String cookieAT = (String)cookies.get(FMUIAuthService.getAccessCookieName());
        if (cookieAT == null) {
            return;
        }
        FMUserSession session = (FMUserSession)this.dbService.getThreadEM().find(FMUserSession.class, (Object)cookieAT);
        if (session != null) {
            try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                this.dbService.getThreadEM().remove((Object)session);
                rwt.commit();
            }
        }
        Cookie c = new Cookie(UIAuthServiceBase.getAccessCookieName(), "");
        c.setPath("/");
        c.setMaxAge(0);
        c.setHttpOnly(true);
        resp.addCookie(c);
    }

    private FMUserSession getLocalSession(Map<String, String> cookies) {
        String cookieAT = cookies.get(FMUIAuthService.getAccessCookieName());
        if (cookieAT == null) {
            logger.trace((Object)"No access_token cookie received");
            return null;
        }
        FMUserSession session = this.dbService.getSingleResult(FMUserSession.class, "SELECT u from fmusersession u where u.accessToken=?1", cookieAT);
        if (session == null) {
            logger.warn((Object)"Received access token does not correspond to any valid session");
        }
        return session;
    }

    public AuthCtx getUserInternal(Map<String, String> cookies, String apiKeyHeader, String xsrfTokenHeader, boolean checkXSRF) {
        FMUser user;
        if (apiKeyHeader != null && (user = this.getUserFromApiKeyHeader(apiKeyHeader)) != null) {
            return FMAuthCtx.forUserFromUI(user, null);
        }
        FMUserSession session = this.getLocalSession(cookies);
        if (session != null) {
            if (checkXSRF) {
                FMUIAuthService.checkXSRF((String)session.getAccessToken(), (String)session.getXsrfTokenSalt(), (String)xsrfTokenHeader);
            }
            FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
            long now = System.currentTimeMillis();
            if (fmSettings.sessionsMaxTotalTimeMinutes > 0 && session.getGranted() + (long)fmSettings.sessionsMaxTotalTimeMinutes * 60L * 1000L < now) {
                logger.info((Object)("Session for user '" + session.getUser().getLogin() + "' has expired."));
                try (DatabaseAccessService.ReadWriteTransaction rwt = this.dbService.rwTransaction();){
                    this.dbService.getThreadEM().remove((Object)session);
                    rwt.commit();
                }
                return null;
            }
            return FMAuthCtx.forUserFromUI(session.getUser(), session.getAccessToken());
        }
        return null;
    }

    private FMUser getUserFromApiKeyHeader(String apiKeyHeader) {
        String[] parts = apiKeyHeader.trim().split(":");
        if (parts.length == 2) {
            FMPersonalAPIKey key = this.dbService.getSingleResult(FMPersonalAPIKey.class, "SELECT pak from fmpersonalapikey pak WHERE pak.keyId = ?1", parts[0]);
            if (key != null) {
                try {
                    if (key.verifySecret(parts[1])) {
                        return key.getUser();
                    }
                }
                catch (CodedException e) {
                    logger.errorV((Throwable)e, "Unable to validate API key. The personal API key with ID=%s might be corrupted in the database.", new Object[]{key.getKeyId()});
                }
            }
        } else if (parts.length == 1 && parts[0].length() > 0) {
            for (FMPersonalAPIKey key : this.dbService.listResults(FMPersonalAPIKey.class, "SELECT pak from fmpersonalapikey pak", new Object[0])) {
                try {
                    if (!key.verifySecret(parts[0])) continue;
                    return key.getUser();
                }
                catch (CodedException e) {
                    logger.errorV((Throwable)e, "Unable to validate API key. The personal API key with ID=%s might be corrupted in the database.", new Object[]{key.getKeyId()});
                }
            }
        }
        return null;
    }

    public void setXSRFCookie(HttpServletRequest req, HttpServletResponse resp) {
        Map cookies = ServletUtils.parseCookies((HttpServletRequest)req);
        FMUserSession session = this.getLocalSession(cookies);
        assert (session != null);
        String xsrfValue = FMUIAuthService.computeXSRFToken((String)session.getAccessToken(), (String)session.getXsrfTokenSalt());
        Cookie c2 = new Cookie(FMUIAuthService.getXSRFCookieName(), xsrfValue);
        c2.setPath("/");
        c2.setSecure(DKUApp.secureCookies());
        if (DKUApp.sameSiteNoneCookies()) {
            c2.setComment(JETTY_SAME_SITE_NONE);
        }
        resp.addCookie(c2);
    }

    public void createPKCECodeVerifierCookie(HttpServletResponse resp, String codeVerifier) {
        if (codeVerifier != null) {
            Cookie ic = new Cookie(PKCE_CODE_VERIFIER_COOKIE_NAME, codeVerifier);
            ic.setHttpOnly(true);
            ic.setSecure(DKUApp.secureCookies());
            if (DKUApp.sameSiteNoneCookies()) {
                ic.setComment(JETTY_SAME_SITE_NONE);
            }
            ic.setPath("/");
            resp.addCookie(ic);
        } else {
            this.deletePKCECodeVerifierCookie(resp);
        }
    }

    public void deletePKCECodeVerifierCookie(HttpServletResponse resp) {
        Cookie ic = new Cookie(PKCE_CODE_VERIFIER_COOKIE_NAME, "");
        ic.setPath("/");
        ic.setMaxAge(0);
        ic.setHttpOnly(true);
        resp.addCookie(ic);
    }

    public Optional<String> getCodeVerifierFromCookie(HttpServletRequest req) {
        if (req.getCookies() == null) {
            return Optional.empty();
        }
        return Arrays.stream(req.getCookies()).filter(c -> PKCE_CODE_VERIFIER_COOKIE_NAME.equals(c.getName())).map(Cookie::getValue).findAny();
    }
}

