/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.utils;

import com.google.common.base.Joiner;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DnsUtils {
    private static final Pattern DNS_UNSAFE_CHARACTERS = Pattern.compile("[^0-9a-zA-Z\\-]");
    private static final int MAX_DNS_LABEL_LENGTH = 64;
    private static final int MAX_CN_LENGTH = 64;

    public static String safeDnsPrefix(String hostname, String ... domainLabels) {
        String domain = Joiner.on((String)".").join((Object[])domainLabels);
        String host = DNS_UNSAFE_CHARACTERS.matcher(StringUtils.stripAccents((String)hostname)).replaceAll("-");
        while (host.startsWith("-")) {
            host = host.substring(1);
        }
        if (host.length() > 64) {
            host = host.substring(0, 64);
        }
        if (host.length() > 64 - domain.length() - 1) {
            host = host.substring(0, 64 - domain.length() - 1);
        }
        while (host.endsWith("-")) {
            host = host.substring(0, host.length() - 1);
        }
        if (host.isEmpty()) {
            throw new IllegalArgumentException("Unable to derive a safe DNS name from the supplied hostname: " + hostname);
        }
        return host.toLowerCase(Locale.ROOT);
    }

    public static String safeDnsName(String hostname, String ... domainLabels) {
        String domain = Joiner.on((String)".").join((Object[])domainLabels);
        return (DnsUtils.safeDnsPrefix(hostname, domainLabels) + "." + domain).toLowerCase(Locale.ROOT);
    }

    public static String relativeSafeDnsName(String hostname, String ... domainLabels) {
        String dnsName = DnsUtils.safeDnsName(hostname, domainLabels);
        if (dnsName.endsWith(".")) {
            return dnsName.substring(0, dnsName.length() - 1);
        }
        return dnsName;
    }
}

