/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.security.auth.GroupProfile;
import com.dataiku.dip.security.auth.UserCredentialsAuthenticatorSettings;
import com.dataiku.dip.security.auth.UserRemappingRule;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.security.auth.UserSupplierSettings;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

@UIModel
public class CustomAuthSettings
implements UserSupplierSettings,
UserCredentialsAuthenticatorSettings {
    public String customUserAuthenticatorClassName;
    public String customUserSupplierClassName;
    public boolean enabled = false;
    @UINullable
    public Integer order;
    public boolean autoProvisionUsersAtLoginTime = true;
    public boolean autoSyncUsersAtLoginTime = true;
    public boolean allowOnDemandUsersSync = true;
    public String defaultUserProfile;
    public boolean authenticationEnabled = true;
    public List<GroupProfile> groupProfiles = new ArrayList<GroupProfile>();
    public List<String> authorizedGroups = new ArrayList<String>();
    public boolean allowOnDemandUsersProvisioning = true;

    @Override
    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled && StringUtils.isNotBlank((String)this.customUserAuthenticatorClassName);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isUsersAutoProvisioningAtLoginTimeEnabled() {
        return this.autoProvisionUsersAtLoginTime && StringUtils.isNotBlank((String)this.customUserSupplierClassName);
    }

    @Override
    public boolean isUsersAutoSyncAtLoginTimeEnabled() {
        return this.autoSyncUsersAtLoginTime && StringUtils.isNotBlank((String)this.customUserSupplierClassName);
    }

    @Override
    public boolean isOnDemandUsersSyncEnabled() {
        return this.allowOnDemandUsersSync && StringUtils.isNotBlank((String)this.customUserSupplierClassName);
    }

    @Override
    public String getDefaultUserProfile() {
        return this.defaultUserProfile;
    }

    @Override
    public Integer getOrder() {
        return this.order != null ? this.order.intValue() : this.getUserSourceType().getDefaultOrder();
    }

    @Override
    public UserSourceType getUserSourceType() {
        return UserSourceType.CUSTOM;
    }

    @Override
    public Set<String> getAuthorizedGroups() {
        return this.authorizedGroups.stream().map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }

    @Override
    public List<UserRemappingRule> getUserRemappingRules() {
        return Collections.emptyList();
    }

    @Override
    public boolean isOnDemandUsersProvisioningEnabled() {
        return this.allowOnDemandUsersProvisioning && StringUtils.isNotBlank((String)this.customUserSupplierClassName);
    }

    @Override
    public List<GroupProfile> getProfileMappings() {
        return this.groupProfiles;
    }
}

