/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.server.SharedSecretUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SharedSecretAuthService {
    private String sharedSecret = SharedSecretUtils.getSharedSecret(true);

    public boolean hasValidSharedSecret(HttpServletRequest req) throws IOException {
        String ss = req.getHeader("X-DKU-IPythonSharedSecret");
        return ss != null && StringUtils.equals((String)ss.trim(), (String)this.sharedSecret);
    }

    public void failIfNoSharedSecret(HttpServletRequest req) throws IOException {
        if (!this.hasValidSharedSecret(req)) {
            throw new SecurityException("You are not allowed to call this API");
        }
    }
}

