/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.licensing;

import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SublicenseEnforcer {
    private StandardSublicense sublicense;
    private static Logger logger = Logger.getLogger((String)"dku.licensing.sublicense");

    public SublicenseEnforcer(JsonObject rawSublicense) {
        if (rawSublicense != null) {
            this.sublicense = (StandardSublicense)JSON.parse((String)JSON.json((Object)rawSublicense), StandardSublicense.class);
        }
    }

    public void restrict(LimitsStatusComputer.LicenseLimitsStatus status) {
        if (this.sublicense == null) {
            logger.info((Object)"no sublicense");
            return;
        }
        assert (status.profileLimits.size() == 0);
        logger.debug((Object)"There is a sublicense: restricting");
        for (LimitsStatusComputer.LicensedProfile lp : status.licensedProfiles.values()) {
            Integer overrideLimit = this.sublicense.profileLimits.get(lp.profile);
            if (overrideLimit == null) continue;
            if (lp.licensedLimit < 0 || overrideLimit < lp.licensedLimit) {
                logger.debug((Object)("Sublicense, overriding for profile " + lp.profile + " " + lp.licensedLimit + " -> " + overrideLimit));
                lp.licensedLimit = overrideLimit;
                continue;
            }
            logger.debug((Object)("Sublicense, NOT overriding for profile " + lp.profile + " " + lp.licensedLimit + " -> " + overrideLimit));
        }
    }

    public static class StandardSublicense {
        public Map<String, Integer> profileLimits = new HashMap<String, Integer>();
    }
}

